/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.PIMService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;

class MessageFactory
extends HTIMessageFactory {
    private static final int uid = 270601421;

    MessageFactory() {
    }

    static HTIMessage createImportvCardMessage(String vCard) {
        byte[] vCardBytes = vCard.getBytes();
        int msgBodySize = vCardBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601421, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 1;
        System.arraycopy(vCardBytes, 0, body, 1, vCardBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createImportvCalendarMessage(String vCal) {
        byte[] vCalBytes = vCal.getBytes();
        int msgBodySize = vCalBytes.length + 1;
        byte[] header = MessageFactory.createHeader(270601421, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 2;
        System.arraycopy(vCalBytes, 0, body, 1, vCalBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteContactEntryMessage(int id) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 3;
        Util.intToLittleEndianBytes(id, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteAllContactEntriesMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 3;
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteCalendarEntryMessage(int id) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 4;
        Util.intToLittleEndianBytes(id, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteAllCalendarEntriesMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 4;
        return new HTIMessage(command);
    }

    static HTIMessage createImportSIMContactMessage(byte[] fieldTypes, String[] fieldContents) {
        int msgBodySize = 2;
        int i = 0;
        while (i < fieldContents.length) {
            msgBodySize += 2;
            msgBodySize += fieldContents[i].length();
            ++i;
        }
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 17;
        command[15] = (byte)fieldTypes.length;
        int commandIndex = 16;
        int i2 = 0;
        while (i2 < fieldContents.length) {
            command[commandIndex++] = fieldTypes[i2];
            byte fieldLength = (byte)fieldContents[i2].length();
            command[commandIndex++] = fieldLength;
            byte[] fieldContent = fieldContents[i2].getBytes();
            System.arraycopy(fieldContent, 0, command, commandIndex, fieldLength);
            commandIndex += fieldLength;
            ++i2;
        }
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteSimContactEntryMessage(int id) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 18;
        Util.intToLittleEndianBytes(id, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createDeleteAllSimContactEntriesMessage() {
        int msgBodySize = 1;
        byte[] command = MessageFactory.initMessageArray(270601421, msgBodySize);
        command[14] = 18;
        return new HTIMessage(command);
    }

    static HTIMessage createAddBookmarkMessage(String folderName, String bookmarkName, String url, String accesspoint, String username, String password) {
        int msgBodySize = 1;
        byte[] folderNameBytes = null;
        if (folderName != null) {
            folderNameBytes = folderName.getBytes();
            msgBodySize += folderNameBytes.length;
        }
        ++msgBodySize;
        byte[] bookmarkBytes = bookmarkName.getBytes();
        msgBodySize += bookmarkBytes.length;
        ++msgBodySize;
        byte[] urlBytes = url.getBytes();
        msgBodySize += urlBytes.length;
        msgBodySize += 2;
        byte[] accesspointBytes = null;
        if (accesspoint != null) {
            accesspointBytes = accesspoint.getBytes();
            msgBodySize += accesspointBytes.length;
        }
        ++msgBodySize;
        byte[] usernameBytes = null;
        if (username != null) {
            usernameBytes = username.getBytes();
            msgBodySize += usernameBytes.length;
        }
        ++msgBodySize;
        byte[] passwordBytes = null;
        if (password != null) {
            passwordBytes = password.getBytes();
            msgBodySize += passwordBytes.length;
        }
        byte[] command = MessageFactory.initMessageArray(270601421, ++msgBodySize);
        int index = 14;
        command[index++] = 26;
        if (folderNameBytes != null) {
            command[index++] = (byte)folderNameBytes.length;
            System.arraycopy(folderNameBytes, 0, command, index, folderNameBytes.length);
            index += folderNameBytes.length;
        } else {
            command[index++] = 0;
        }
        command[index++] = (byte)bookmarkBytes.length;
        System.arraycopy(bookmarkBytes, 0, command, index, bookmarkBytes.length);
        Util.intToLittleEndianBytes(urlBytes.length, command, index += bookmarkBytes.length, 2);
        System.arraycopy(urlBytes, 0, command, index += 2, urlBytes.length);
        index += urlBytes.length;
        if (accesspointBytes != null) {
            command[index++] = (byte)accesspointBytes.length;
            System.arraycopy(accesspointBytes, 0, command, index, accesspointBytes.length);
            index += accesspointBytes.length;
        } else {
            command[index++] = 0;
        }
        if (usernameBytes != null) {
            command[index++] = (byte)usernameBytes.length;
            System.arraycopy(usernameBytes, 0, command, index, usernameBytes.length);
            index += usernameBytes.length;
        } else {
            command[index++] = 0;
        }
        if (passwordBytes != null) {
            command[index++] = (byte)passwordBytes.length;
            System.arraycopy(passwordBytes, 0, command, index, passwordBytes.length);
            index += passwordBytes.length;
        } else {
            command[index++] = 0;
        }
        return new HTIMessage(command);
    }

    static HTIMessage deleteBookmarkMessage(String folderName, String bookmarkName) {
        int msgBodySize = 1;
        byte[] folderNameBytes = null;
        if (folderName != null) {
            folderNameBytes = folderName.getBytes();
            msgBodySize += folderNameBytes.length;
        }
        ++msgBodySize;
        byte[] bookmarkBytes = null;
        if (bookmarkName != null) {
            bookmarkBytes = bookmarkName.getBytes();
            msgBodySize += bookmarkBytes.length;
        }
        byte[] command = MessageFactory.initMessageArray(270601421, ++msgBodySize);
        int index = 14;
        command[index++] = 27;
        if (folderNameBytes != null) {
            command[index++] = (byte)folderNameBytes.length;
            System.arraycopy(folderNameBytes, 0, command, index, folderNameBytes.length);
            index += folderNameBytes.length;
        } else {
            command[index++] = 0;
        }
        if (bookmarkBytes != null) {
            command[index++] = (byte)bookmarkBytes.length;
            System.arraycopy(bookmarkBytes, 0, command, index, bookmarkBytes.length);
            index += bookmarkBytes.length;
        } else {
            command[index++] = 0;
        }
        return new HTIMessage(command);
    }
}

