/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.ApplicationControlService;

import com.nokia.HTI.ApplicationControlService.AppStatus;
import com.nokia.HTI.ApplicationControlService.MessageFactory;
import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ApplicationControlService
extends BaseService
implements IService {
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public HTIMessage startProcess(String programName) throws HTIException, IOException {
        return this.startProcess(programName, 0L);
    }

    public HTIMessage startProcess(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Starting process by name " + programName);
        HTIMessage command = MessageFactory.createStartProcessMessage(programName, "");
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage startProcess(String programName, String parameters) throws HTIException, IOException {
        return this.startProcess(programName, parameters, 0L);
    }

    public HTIMessage startProcess(String programName, String parameters, long timeout) throws HTIException, IOException {
        this.log.info("Starting process by name: " + programName + " with parameters: " + parameters);
        HTIMessage command = MessageFactory.createStartProcessMessage(programName, parameters);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage startProcessExitCode(String programName) throws HTIException, IOException {
        return this.startProcessExitCode(programName, 0L);
    }

    public HTIMessage startProcessExitCode(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Starting process by name " + programName + " and instructing HTI to store process exit code");
        HTIMessage command = MessageFactory.createStartProcessAndStoreExitCodeMessage(programName, "");
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage startProcessExitCode(String programName, String parameters) throws HTIException, IOException {
        return this.startProcessExitCode(programName, parameters, 0L);
    }

    public HTIMessage startProcessExitCode(String programName, String parameters, long timeout) throws HTIException, IOException {
        this.log.info("Starting process by name: " + programName + " with parameters: " + parameters + " and instructing HTI to store exit code");
        HTIMessage command = MessageFactory.createStartProcessAndStoreExitCodeMessage(programName, parameters);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage stopProcess(String programName) throws HTIException, IOException {
        return this.stopProcess(programName, 0L);
    }

    public HTIMessage stopProcess(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Stopping process by name " + programName);
        HTIMessage command = MessageFactory.createStopProcessByNameMessage(programName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage stopProcessByID(int PID) throws HTIException, IOException {
        return this.stopProcessByID(PID, 0L);
    }

    public HTIMessage stopProcessByID(int PID, long timeout) throws HTIException, IOException {
        this.log.info("Stopping process by id " + PID);
        HTIMessage command = MessageFactory.createStopProcessMessage(PID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getProcessStatus(String programName) throws HTIException, IOException {
        return this.getProcessStatus(programName, 0L);
    }

    public HTIMessage getProcessStatus(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Getting process status by name " + programName);
        HTIMessage command = MessageFactory.createProcessStatusMessage(programName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getProcessStatusByID(int PID) throws HTIException, IOException {
        return this.getProcessStatusByID(PID, 0L);
    }

    public HTIMessage getProcessStatusByID(int PID, long timeout) throws HTIException, IOException {
        this.log.info("Getting process status by id " + PID);
        HTIMessage command = MessageFactory.createProcessStatusMessage(PID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getProcessExitCode(int PID) throws HTIException, IOException {
        return this.getProcessExitCode(PID, 0L);
    }

    public HTIMessage getProcessExitCode(int PID, long timeout) throws HTIException, IOException {
        this.log.info("Getting process exit code by id " + PID);
        HTIMessage command = MessageFactory.createGetProcessExitCodeMessage(PID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage startApplication(String programName, String docName) throws HTIException, IOException {
        return this.startApplication(programName, docName, 0L);
    }

    public HTIMessage startApplication(String programName, String docName, long timeout) throws HTIException, IOException {
        this.log.info("Starting application by name " + programName + ", optional document name is " + docName);
        HTIMessage command = MessageFactory.createStartAppMessage(programName, docName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public AppStatus startApplicationByUID(int UID, String docName) throws HTIException, IOException {
        return this.startApplicationByUID(UID, docName, 0L);
    }

    public AppStatus startApplicationByUID(int UID, String docName, long timeout) throws HTIException, IOException {
        this.log.info("Starting application by uid " + UID + ", optional document name is " + docName);
        HTIMessage command = MessageFactory.createStartAppMessage(UID, docName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] responseBody = response.getBody();
        AppStatus result = new AppStatus(responseBody[0]);
        return result;
    }

    public HTIMessage startDocument(String docName) throws HTIException, IOException {
        return this.startDocument(docName, 0L);
    }

    public HTIMessage startDocument(String docName, long timeout) throws HTIException, IOException {
        this.log.info("Starting document by name " + docName);
        HTIMessage command = MessageFactory.createStartDocMessage(docName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public AppStatus getApplicationStatus(String programName) throws HTIException, IOException {
        return this.getApplicationStatus(programName, 0L);
    }

    public AppStatus getApplicationStatus(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Getting application status by name " + programName);
        HTIMessage command = MessageFactory.createGetAppStatusMessage(programName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] responseBody = response.getBody();
        AppStatus result = new AppStatus(responseBody[0]);
        return result;
    }

    public AppStatus getApplicationStatusByDocumentName(String docName) throws HTIException, IOException {
        return this.getApplicationStatusByDocumentName(docName, 0L);
    }

    public AppStatus getApplicationStatusByDocumentName(String docName, long timeout) throws HTIException, IOException {
        this.log.info("Getting application status by document name " + docName);
        HTIMessage command = MessageFactory.createGetDocStatusMessage(docName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] responseBody = response.getBody();
        AppStatus result = new AppStatus(responseBody[0]);
        return result;
    }

    public AppStatus getApplicationStatusByUID(int UID) throws HTIException, IOException {
        return this.getApplicationStatusByUID(UID, 0L);
    }

    public AppStatus getApplicationStatusByUID(int UID, long timeout) throws HTIException, IOException {
        this.log.info("Getting application status by uid " + UID);
        HTIMessage command = MessageFactory.createGetAppStatusMessage(UID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] responseBody = response.getBody();
        AppStatus result = new AppStatus(responseBody[0]);
        return result;
    }

    public HTIMessage stopApplication(String programName) throws HTIException, IOException {
        return this.stopApplication(programName, 0L);
    }

    public HTIMessage stopApplication(String programName, long timeout) throws HTIException, IOException {
        this.log.info("Stopping application by name " + programName);
        HTIMessage command = MessageFactory.createStopAppByNameMessage(programName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage stopApplicationByDocumentName(String docName) throws HTIException, IOException {
        return this.stopApplicationByDocumentName(docName, 0L);
    }

    public HTIMessage stopApplicationByDocumentName(String docName, long timeout) throws HTIException, IOException {
        this.log.info("Stopping application by document name " + docName);
        HTIMessage command = MessageFactory.createStopDocMessage(docName);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public AppStatus stopApplicationByUID(int UID) throws HTIException, IOException {
        return this.stopApplicationByUID(UID, 0L);
    }

    public AppStatus stopApplicationByUID(int UID, long timeout) throws HTIException, IOException {
        this.log.info("Stopping application by uid " + UID);
        HTIMessage command = MessageFactory.createStopAppMessage(UID);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        byte[] responseBody = response.getBody();
        AppStatus result = new AppStatus(responseBody[0]);
        return result;
    }

    public HTIMessage listProcesses(String searchPattern, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createListProcessesMessage(searchPattern);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public List listRunningApplications(boolean inludeHidden, boolean includeSystem, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createListRunningApplicationsMessage(inludeHidden, includeSystem);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (response.isErrorResponse()) {
            return null;
        }
        ArrayList<String> apps = new ArrayList<String>();
        byte[] body = response.getBody();
        int index = 1;
        byte[] countBytes = new byte[2];
        System.arraycopy(body, index, countBytes, 0, 2);
        int appCount = Util.littleEndianToInt(countBytes);
        index += 2;
        int i = 0;
        while (i < appCount) {
            System.out.println("i = " + i);
            byte[] idBytes = new byte[4];
            System.arraycopy(body, index, idBytes, 0, 4);
            int captionLength = body[index += 4] * 2;
            byte[] captionBytes = new byte[captionLength];
            System.arraycopy(body, ++index, captionBytes, 0, captionLength);
            int docLength = body[index += captionLength] * 2;
            byte[] docBytes = new byte[docLength];
            System.arraycopy(body, ++index, docBytes, 0, docLength);
            byte hiddenByte = body[index += docLength];
            byte systemByte = body[++index];
            byte readyByte = body[++index];
            byte busyByte = body[++index];
            byte closableByte = body[++index];
            ++index;
            long uid = Util.littleEndianUnsignedIntToLong(idBytes);
            String caption = new String(captionBytes, "UTF-16LE").trim();
            String doc = new String(docBytes, "UTF-16LE").trim();
            boolean hidden = hiddenByte == 1;
            boolean system = systemByte == 1;
            boolean ready = readyByte == 1;
            boolean busy = busyByte == 1;
            boolean closable = closableByte == 1;
            apps.add(String.valueOf(Long.toHexString(uid)) + ":" + caption + ":" + doc + ":" + hidden + ":" + system + ":" + ready + ":" + busy + ":" + closable);
            ++i;
        }
        return apps;
    }

    public HTIMessage installSoftware(String sisPackageName, boolean upgradeAllowed, boolean optionalItemsAllowed, boolean OCSP_Done, boolean ignoreOCSPWarnings, boolean untrustedAllowed, boolean packageInfoAllowed, boolean userCapGranted, boolean killApp, boolean overwriteAllowed, boolean downloadAllowed, String downloadUsername, String downloadPassword, String installDrive, int targetLanguage, boolean usePhoneLanguage, boolean upgradeData, long timeout) throws HTIException, IOException {
        this.log.info("Installing application by name " + sisPackageName);
        HTIMessage command = MessageFactory.createInstallSoftwareMessage(sisPackageName, upgradeAllowed, optionalItemsAllowed, OCSP_Done, ignoreOCSPWarnings, untrustedAllowed, packageInfoAllowed, userCapGranted, killApp, overwriteAllowed, downloadAllowed, downloadUsername, downloadPassword, installDrive, targetLanguage, usePhoneLanguage, upgradeData);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage uninstallSoftware(int appUI, boolean killApp, boolean breakDependency, int mimeType, long timeout) throws HTIException, IOException {
        this.log.info("Uninstalling application by UID " + appUI);
        HTIMessage command = MessageFactory.createUninstallSoftwareMessage(appUI, killApp, breakDependency, mimeType);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage uninstallSoftwareByName(String packageName, boolean killApp, boolean breakDependency, int mimeType, long timeout) throws HTIException, IOException {
        this.log.info("Uninstalling application by name: " + packageName);
        HTIMessage command = MessageFactory.createUninstallSoftwareByNameMessage(packageName, killApp, breakDependency, mimeType);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }
}

