/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.ScreenCapturingService;

import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;

public class HTIFont {
    private String name;
    private int size;
    private boolean bold;
    private boolean italic;
    private boolean antialiased;

    public HTIFont(String name, int size, boolean bold, boolean italic, boolean antialiased) {
        this.name = name;
        this.size = size;
        this.bold = bold;
        this.italic = italic;
        this.antialiased = antialiased;
    }

    public byte[] getBytes(String charset) {
        int bytesSize = 4;
        byte[] nameBytes = null;
        int nameSize = 0;
        byte nameLength = 0;
        if (this.name != null) {
            nameLength = (byte)this.name.length();
            try {
                nameBytes = this.name.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            nameSize = (byte)nameBytes.length;
            bytesSize += nameSize;
        }
        int index = 0;
        byte[] bytes = new byte[bytesSize];
        bytes[index++] = nameLength;
        if (nameSize > 0) {
            System.arraycopy(nameBytes, 0, bytes, index, nameSize);
            index += nameSize;
        }
        Util.intToLittleEndianBytes(this.size, bytes, index, 2);
        index += 2;
        int fontStyle = 0;
        if (this.bold) {
            fontStyle = (byte)(fontStyle + 1);
        }
        if (this.italic) {
            fontStyle = (byte)(fontStyle + 2);
        }
        if (!this.antialiased) {
            fontStyle = (byte)(fontStyle + 4);
        }
        bytes[index++] = fontStyle;
        return bytes;
    }

    public String toString() {
        return String.valueOf(this.name) + ", " + this.size + " px " + (this.bold ? "bold " : "") + (this.italic ? "italic " : "") + (this.antialiased ? "antialiased " : "");
    }
}

