/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.common;

import com.nokia.HTI.HTIMessage;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

public class Util {
    public static void longToLittleEndianBytes(long value, byte[] destination, int offset, int length) {
        int shiftBits = 0;
        int i = 0;
        while (i < length) {
            destination[offset + i] = (byte)(value >> shiftBits & 0xFFL);
            shiftBits += 8;
            ++i;
        }
    }

    public static void intToLittleEndianBytes(int value, byte[] destination, int offset, int length) {
        int shiftBits = 0;
        int i = 0;
        while (i < length) {
            destination[offset + i] = (byte)(value >> shiftBits & 0xFF);
            shiftBits += 8;
            ++i;
        }
    }

    public static String[] separateResponse(byte[] body) {
        Vector<Byte> temp = new Vector<Byte>();
        Vector<String> strings = new Vector<String>();
        int i = 1;
        while (i < body.length) {
            if (body[i] != 124) {
                temp.add(new Byte(body[i]));
            } else {
                strings.add(Util.s(temp));
                temp.clear();
            }
            ++i;
        }
        if (temp.size() > 0) {
            strings.add(Util.s(temp));
        }
        return strings.toArray(new String[0]);
    }

    private static String s(Vector temp) {
        byte[] bytes = new byte[temp.size()];
        int j = 0;
        while (j < temp.size()) {
            bytes[j] = (Byte)temp.elementAt(j);
            ++j;
        }
        return new String(bytes);
    }

    public static String stackTraceToString(Exception e) {
        final StringBuffer sb = new StringBuffer();
        final String lineBreak = System.getProperty("line.separator");
        if (e == null) {
            sb.append(lineBreak);
            sb.append("Exception is null so no stack trace available.");
            sb.append(lineBreak);
            return sb.toString();
        }
        Writer writer = new Writer(){
            StringBuffer innerBuffer;
            {
                this.innerBuffer = new StringBuffer(string);
            }

            public void close() {
                this.innerBuffer.append(lineBreak);
                sb.append(this.innerBuffer.toString());
            }

            public void flush() {
            }

            public void write(char[] str, int off, int len) {
                this.innerBuffer.append(str, off, len);
            }
        };
        e.printStackTrace(new PrintWriter(writer));
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static int littleEndianToInt(HTIMessage response, int offset) {
        byte[] rawResponseBody = response.getBody();
        int index = (rawResponseBody.length - offset - 1) * 8;
        int value = 0;
        int i = rawResponseBody.length - 1;
        while (i >= offset) {
            value += (rawResponseBody[i] & 0xFF) << index;
            index -= 8;
            --i;
        }
        return value;
    }

    public static long littleEndianToLong(HTIMessage response, int offset) {
        byte[] rawResponseBody = response.getBody();
        int index = (rawResponseBody.length - offset - 1) * 8;
        long value = 0L;
        int i = rawResponseBody.length - 1;
        while (i >= offset) {
            value += (long)((rawResponseBody[i] & 0xFF) << index);
            index -= 8;
            --i;
        }
        return value;
    }

    public static long littleEndianUnsignedIntToLong(HTIMessage response, int offset) {
        long value = Util.littleEndianToLong(response, offset);
        return value << 32 >>> 32;
    }

    public static int littleEndianToInt(byte[] bytes) {
        int index = (bytes.length - 1) * 8;
        int value = 0;
        int i = bytes.length - 1;
        while (i >= 0) {
            value += (bytes[i] & 0xFF) << index;
            index -= 8;
            --i;
        }
        return value;
    }

    public static long littleEndianToLong(byte[] bytes) {
        int index = (bytes.length - 1) * 8;
        long value = 0L;
        int i = bytes.length - 1;
        while (i >= 0) {
            value += (long)(bytes[i] & 0xFF) << index;
            index -= 8;
            --i;
        }
        return value;
    }

    public static long littleEndianUnsignedIntToLong(byte[] bytes) {
        long value = Util.littleEndianToLong(bytes);
        return value << 32 >>> 32;
    }

    public static String byteArrayToString(byte[] bytes) {
        String lineBreak = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            byte aByte = bytes[i];
            s.append(String.valueOf(i) + ": 0x" + Integer.toHexString(aByte) + lineBreak);
            ++i;
        }
        return s.toString();
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            buffer.append(Integer.toHexString(bytes[i] >> 4 & 0xF));
            buffer.append(Integer.toHexString(bytes[i] & 0xF));
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }
}

