/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.KeyEventService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.KeyEventService.MessageFactory;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyEventService
extends BaseService
implements IService {
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public HTIMessage pressKey(byte[] scanCode) throws HTIException, IOException {
        return this.pressKey(scanCode, 0L);
    }

    public HTIMessage pressKey(byte[] scanCode, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createPressKeyMessage(scanCode);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage pressKeySequence(List<byte[]> scanCodeList, int timeToHold, int interval) throws HTIException, IOException {
        return this.pressKeySequence(scanCodeList, timeToHold, interval, 0L);
    }

    public HTIMessage pressKeySequence(List<byte[]> scanCodeList, int timeToHold, int interval, long timeout) throws HTIException, IOException {
        this.log.info("Pressing key sequence " + scanCodeList);
        HTIMessage command = MessageFactory.createKeyPressSequenceMessage(scanCodeList, timeToHold, interval);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage pressKeyLong(byte[] scanCode, int time) throws HTIException, IOException {
        return this.pressKeyLong(scanCode, time, 0L);
    }

    public HTIMessage pressKeyLong(byte[] scanCode, int time, long timeout) throws HTIException, IOException {
        if (timeout > 0L && (long)time > timeout) {
            throw new HTIException("Pressing time (" + time + ") is longer than command timeout (" + timeout + ")");
        }
        HTIMessage command = MessageFactory.createLongKeyPressMessage(scanCode, time);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage holdKey(byte[] scanCode) throws HTIException, IOException {
        return this.holdKey(scanCode, 0L);
    }

    public HTIMessage holdKey(byte[] scanCode, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createHoldKeyMessage(scanCode);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage releaseKey(byte[] scanCode) throws HTIException, IOException {
        return this.releaseKey(scanCode, 0L);
    }

    public HTIMessage releaseKey(byte[] scanCode, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createReleaseKeyMessage(scanCode);
        HTIMessage response = this.sendHTIRequest(command);
        return response;
    }

    public HTIMessage typeText(String text) throws HTIException, IOException {
        return this.typeText(text, 0L);
    }

    public HTIMessage typeText(String text, long timeout) throws HTIException, IOException {
        this.log.info("Typing text " + text);
        if (text == null) {
            throw new HTIException("String to type was null.");
        }
        HTIMessage command = MessageFactory.createTypeMessage(text);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage typeTextPassword(String text, long timeout) throws HTIException, IOException {
        this.log.info("Typing text " + text);
        if (text == null) {
            throw new HTIException("String to type was null.");
        }
        HTIMessage command = MessageFactory.createTypePasswordMessage(text);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage tapScreen(int x, int y, int tapCount, int timeToHold, int pauseBetweenTaps) throws HTIException, IOException {
        return this.tapScreen(x, y, tapCount, timeToHold, pauseBetweenTaps, 0L);
    }

    public HTIMessage tapScreen(int x, int y, int tapCount, int timeToHold, int pauseBetweenTaps, long timeout) throws HTIException, IOException {
        this.log.info("Tapping screen " + tapCount + " time(s) at x=" + x + ", y=" + y + ". Time to hold = " + timeToHold + ". Pause between taps: " + pauseBetweenTaps);
        HTIMessage command = MessageFactory.createTapScreenMessage(x, y, tapCount, timeToHold, pauseBetweenTaps);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage tapAndDrag(int startX, int startY, int endX, int endY, int dragTime) throws HTIException, IOException {
        return this.tapAndDrag(startX, startY, endX, endY, dragTime, 0L);
    }

    public HTIMessage tapAndDrag(int startX, int startY, int endX, int endY, int dragTime, long timeout) throws HTIException, IOException {
        this.log.info("Dragging item from x:" + startX + ", y:" + startY + " to x:" + endX + ", y:" + endY + ".");
        HTIMessage command = MessageFactory.createTapAndDragMessage(startX, startY, endX, endY, dragTime);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage tapAndDragMultipoint(int pointTime, int lineTime, List coordinateList) throws HTIException, IOException {
        return this.tapAndDragMultipoint(pointTime, lineTime, coordinateList, 0L);
    }

    public HTIMessage tapAndDragMultipoint(int pointTime, int lineTime, List coordinateList, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createTapAndDragMultipointMessage(pointTime, lineTime, coordinateList);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }
}

