/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.ApplicationControlService;

import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.HTIMessageFactory;
import com.nokia.HTI.common.Util;
import java.io.UnsupportedEncodingException;

class MessageFactory
extends HTIMessageFactory {
    static final int uid = 270589639;

    MessageFactory() {
    }

    static HTIMessage createStartAppMessage(String appPath, String docName) throws UnsupportedEncodingException {
        byte[] appPathBytes = new byte[]{};
        appPathBytes = appPath.getBytes("UTF-16LE");
        byte[] docNameBytes = null;
        int msgBodySize = 3 + appPathBytes.length;
        if (docName != null && docName.length() > 0) {
            docNameBytes = docName.getBytes("UTF-16LE");
            msgBodySize += docNameBytes.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 17;
        command[15] = (byte)appPath.length();
        System.arraycopy(appPathBytes, 0, command, 16, appPathBytes.length);
        if (docNameBytes != null) {
            command[16 + appPathBytes.length] = (byte)docName.length();
            System.arraycopy(docNameBytes, 0, command, 17 + appPathBytes.length, docNameBytes.length);
        } else {
            command[16 + appPathBytes.length] = 0;
        }
        return new HTIMessage(command);
    }

    static HTIMessage createStartDocMessage(String docName) throws UnsupportedEncodingException {
        byte[] docNameBytes = new byte[]{};
        docNameBytes = docName.getBytes("UTF-16LE");
        int msgBodySize = 2 + docNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 21;
        command[15] = (byte)docName.length();
        System.arraycopy(docNameBytes, 0, command, 16, docNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStopDocMessage(String docName) throws UnsupportedEncodingException {
        byte[] docNameBytes = new byte[]{};
        docNameBytes = docName.getBytes("UTF-16LE");
        int msgBodySize = 2 + docNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 31;
        command[15] = (byte)docName.length();
        System.arraycopy(docNameBytes, 0, command, 16, docNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStartProcessMessage(String appPath, String parameters) throws UnsupportedEncodingException {
        byte[] appPathBytes = new byte[]{};
        appPathBytes = appPath.getBytes("UTF-16LE");
        byte[] parameterBytes = new byte[]{};
        parameterBytes = parameters.getBytes("UTF-16LE");
        int msgBodySize = appPathBytes.length + parameterBytes.length + 3;
        int ptr = 0;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        command[header.length] = 3;
        command[header.length + 1] = (byte)appPath.length();
        System.arraycopy(header, 0, command, 0, header.length);
        ptr = header.length + 2;
        System.arraycopy(appPathBytes, 0, command, ptr, appPathBytes.length);
        command[ptr += appPathBytes.length] = (byte)parameters.length();
        System.arraycopy(parameterBytes, 0, command, ++ptr, parameterBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createProcessStatusMessage(int processID) {
        int msgBodySize = 5;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 6;
        body[1] = (byte)(processID & 0xFF);
        body[2] = (byte)(processID >> 8 & 0xFF);
        body[3] = (byte)(processID >> 16 & 0xFF);
        body[4] = (byte)(processID >> 24 & 0xFF);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createProcessStatusMessage(String processPattern) throws UnsupportedEncodingException {
        byte[] processPatternBytes = new byte[]{};
        processPatternBytes = processPattern.getBytes("UTF-16LE");
        int msgBodySize = processPatternBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 5;
        body[1] = (byte)processPattern.length();
        System.arraycopy(processPatternBytes, 0, body, 2, processPatternBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStopAppByNameMessage(String appPath) throws UnsupportedEncodingException {
        byte[] appPathBytes = new byte[]{};
        appPathBytes = appPath.getBytes("UTF-16LE");
        int msgBodySize = appPathBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        command[header.length] = 29;
        command[header.length + 1] = (byte)appPath.length();
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(appPathBytes, 0, command, header.length + 2, appPathBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStopProcessByNameMessage(String pattern) throws UnsupportedEncodingException {
        byte[] patternBytes = new byte[]{};
        patternBytes = pattern.getBytes("UTF-16LE");
        int msgBodySize = patternBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        command[header.length] = 9;
        command[header.length + 1] = (byte)(pattern.length() & 0xFF);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(patternBytes, 0, command, header.length + 2, patternBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStopProcessMessage(int processID) {
        int msgBodySize = 5;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 10;
        body[1] = (byte)(processID & 0xFF);
        body[2] = (byte)(processID >> 8 & 0xFF);
        body[3] = (byte)(processID >> 16 & 0xFF);
        body[4] = (byte)(processID >> 24 & 0xFF);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStartAppMessage(int UID, String docName) throws UnsupportedEncodingException {
        int msgBodySize = 6;
        byte[] docNameBytes = null;
        if (docName != null && docName.length() > 0) {
            docNameBytes = docName.getBytes("UTF-16LE");
            msgBodySize += docNameBytes.length;
        }
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 19;
        Util.intToLittleEndianBytes(UID, command, 15, 4);
        if (docNameBytes != null) {
            command[19] = (byte)docName.length();
            System.arraycopy(docNameBytes, 0, command, 20, docNameBytes.length);
        } else {
            command[19] = 0;
        }
        return new HTIMessage(command);
    }

    static HTIMessage createGetAppStatusMessage(String appName) throws UnsupportedEncodingException {
        byte[] appNameBytes = new byte[]{};
        appNameBytes = appName.getBytes("UTF-16LE");
        int msgBodySize = 2 + appNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 23;
        command[15] = (byte)appName.length();
        System.arraycopy(appNameBytes, 0, command, 16, appNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createGetDocStatusMessage(String docName) throws UnsupportedEncodingException {
        byte[] docNameBytes = new byte[]{};
        docNameBytes = docName.getBytes("UTF-16LE");
        int msgBodySize = 2 + docNameBytes.length;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 25;
        command[15] = (byte)docName.length();
        System.arraycopy(docNameBytes, 0, command, 16, docNameBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStopAppMessage(int UID) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 32;
        Util.intToLittleEndianBytes(UID, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createGetAppStatusMessage(int UID) {
        int msgBodySize = 5;
        byte[] command = MessageFactory.initMessageArray(270589639, msgBodySize);
        command[14] = 26;
        Util.intToLittleEndianBytes(UID, command, 15, 4);
        return new HTIMessage(command);
    }

    static HTIMessage createListProcessesMessage(String searchPattern) throws UnsupportedEncodingException {
        byte[] processPatternBytes = new byte[]{};
        processPatternBytes = searchPattern.getBytes("UTF-16LE");
        int msgBodySize = processPatternBytes.length + 2;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 13;
        body[1] = (byte)(searchPattern.length() & 0xFF);
        System.arraycopy(processPatternBytes, 0, body, 2, processPatternBytes.length);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createListRunningApplicationsMessage(boolean inludeHidden, boolean includeSystem) {
        int msgBodySize = 3;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 37;
        body[1] = (byte)(!inludeHidden ? 1 : 0);
        body[2] = (byte)(!includeSystem ? 1 : 0);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createStartProcessAndStoreExitCodeMessage(String appPath, String parameters) throws UnsupportedEncodingException {
        byte[] appPathBytes = new byte[]{};
        appPathBytes = appPath.getBytes("UTF-16LE");
        byte[] parameterBytes = new byte[]{};
        parameterBytes = parameters.getBytes("UTF-16LE");
        int msgBodySize = appPathBytes.length + parameterBytes.length + 3;
        int ptr = 0;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] command = new byte[header.length + msgBodySize];
        command[header.length] = 7;
        command[header.length + 1] = (byte)(appPath.length() & 0xFF);
        System.arraycopy(header, 0, command, 0, header.length);
        ptr = header.length + 2;
        System.arraycopy(appPathBytes, 0, command, ptr, appPathBytes.length);
        command[ptr += appPathBytes.length] = (byte)parameters.length();
        System.arraycopy(parameterBytes, 0, command, ++ptr, parameterBytes.length);
        return new HTIMessage(command);
    }

    static HTIMessage createGetProcessExitCodeMessage(int processID) {
        int msgBodySize = 5;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[0] = 11;
        body[1] = (byte)(processID & 0xFF);
        body[2] = (byte)(processID >> 8 & 0xFF);
        body[3] = (byte)(processID >> 16 & 0xFF);
        body[4] = (byte)(processID >> 24 & 0xFF);
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createInstallSoftwareMessage(String sisPackageName, boolean upgradeAllowed, boolean optionalItemsAllowed, boolean OCSP_Done, boolean ignoreOCSPWarnings, boolean untrustedAllowed, boolean packageInfoAllowed, boolean userCapGranted, boolean killApp, boolean overwriteAllowed, boolean downloadAllowed, String downloadUsername, String downloadPassword, String installDrive, int targetLanguage, boolean usePhoneLanguage, boolean upgradeData) throws UnsupportedEncodingException {
        byte[] sisPathBytes = new byte[]{};
        sisPathBytes = sisPackageName.getBytes("UTF-16LE");
        byte[] downloadUsernameBytes = new byte[]{};
        downloadUsernameBytes = downloadUsername.getBytes("UTF-16LE");
        byte[] downloadPasswordBytes = new byte[]{};
        downloadPasswordBytes = downloadPassword.getBytes("UTF-16LE");
        byte[] installDriveBytes = installDrive.getBytes();
        byte upgradeAllowedByte = 0;
        if (upgradeAllowed) {
            upgradeAllowedByte = 1;
        }
        byte optionalItemsAllowedByte = 0;
        if (optionalItemsAllowed) {
            optionalItemsAllowedByte = 1;
        }
        byte OCSP_DoneByte = 0;
        if (OCSP_Done) {
            OCSP_DoneByte = 1;
        }
        byte ignoreOCSPWarningsByte = 0;
        if (ignoreOCSPWarnings) {
            ignoreOCSPWarningsByte = 1;
        }
        byte untrustedAllowedByte = 0;
        if (untrustedAllowed) {
            untrustedAllowedByte = 1;
        }
        byte packageInfoAllowedByte = 0;
        if (packageInfoAllowed) {
            packageInfoAllowedByte = 1;
        }
        byte userCapGrantedByte = 0;
        if (userCapGranted) {
            userCapGrantedByte = 1;
        }
        byte killAppByte = 0;
        if (killApp) {
            killAppByte = 1;
        }
        byte overwriteAllowedByte = 0;
        if (overwriteAllowed) {
            overwriteAllowedByte = 1;
        }
        byte downloadAllowedByte = 0;
        if (downloadAllowed) {
            downloadAllowedByte = 1;
        }
        byte usePhoneLanguageByte = 0;
        if (usePhoneLanguage) {
            usePhoneLanguageByte = 1;
        }
        byte upgradeDataByte = 0;
        if (upgradeData) {
            upgradeDataByte = 1;
        }
        int index = 0;
        int msgBodySize = 0;
        msgBodySize = downloadAllowed ? sisPathBytes.length + 18 : sisPathBytes.length + downloadUsernameBytes.length + downloadPasswordBytes.length + 18;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        body[index++] = 49;
        body[index++] = (byte)sisPackageName.length();
        System.arraycopy(sisPathBytes, 0, body, index, sisPathBytes.length);
        index += sisPathBytes.length;
        body[index++] = upgradeAllowedByte;
        body[index++] = optionalItemsAllowedByte;
        body[index++] = OCSP_DoneByte;
        body[index++] = ignoreOCSPWarningsByte;
        body[index++] = untrustedAllowedByte;
        body[index++] = packageInfoAllowedByte;
        body[index++] = userCapGrantedByte;
        body[index++] = killAppByte;
        body[index++] = overwriteAllowedByte;
        body[index++] = downloadAllowedByte;
        if (downloadAllowed) {
            body[index++] = (byte)downloadUsername.length();
            System.arraycopy(downloadUsernameBytes, 0, body, index, downloadUsernameBytes.length);
            index += downloadUsernameBytes.length;
            body[index++] = (byte)downloadPassword.length();
            System.arraycopy(downloadPasswordBytes, 0, body, index, downloadPasswordBytes.length);
            index += downloadPasswordBytes.length;
        } else {
            body[index++] = 0;
            body[index++] = 0;
        }
        System.arraycopy(installDriveBytes, 0, body, index, installDrive.length());
        int n = ++index;
        body[n] = (byte)targetLanguage;
        int n2 = ++index;
        body[n2] = usePhoneLanguageByte;
        int n3 = ++index;
        ++index;
        body[n3] = upgradeDataByte;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createUninstallSoftwareMessage(int appUI, boolean killApp, boolean breakDependency, int mimeType) {
        int msgBodySize = 8;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        byte killAppByte = 0;
        if (killApp) {
            killAppByte = 1;
        }
        byte breakDependencyByte = 0;
        if (breakDependency) {
            breakDependencyByte = 1;
        }
        body[0] = 50;
        Util.intToLittleEndianBytes(appUI, body, 1, 4);
        body[5] = killAppByte;
        body[6] = breakDependencyByte;
        body[7] = (byte)mimeType;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }

    static HTIMessage createUninstallSoftwareByNameMessage(String packageName, boolean killApp, boolean breakDependency, int mimeType) throws UnsupportedEncodingException {
        byte[] nameBytes = new byte[]{};
        nameBytes = packageName.getBytes("UTF-16LE");
        int msgBodySize = 5 + nameBytes.length;
        byte[] header = MessageFactory.createHeader(270589639, msgBodySize);
        byte[] body = new byte[msgBodySize];
        byte[] command = new byte[header.length + msgBodySize];
        byte killAppByte = 0;
        if (killApp) {
            killAppByte = 1;
        }
        byte breakDependencyByte = 0;
        if (breakDependency) {
            breakDependencyByte = 1;
        }
        int index = 0;
        body[index++] = 51;
        body[index++] = (byte)packageName.length();
        System.arraycopy(nameBytes, 0, body, 2, nameBytes.length);
        index += nameBytes.length;
        body[index++] = killAppByte;
        body[index++] = breakDependencyByte;
        body[index++] = (byte)mimeType;
        System.arraycopy(header, 0, command, 0, header.length);
        System.arraycopy(body, 0, command, header.length, body.length);
        return new HTIMessage(command);
    }
}

