/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI;

import com.nokia.HTI.common.ThreadedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Logger;

public class HTISocket
extends Socket {
    private static HTISocket ref = null;
    private static String myHost = "localhost";
    private static int myPort = 2000;
    private static boolean myInitialized = false;
    private ThreadedOutputStream myOutput = new ThreadedOutputStream(super.getOutputStream());
    private static HashMap mySocketPool = new HashMap();
    private static final Logger log = Logger.getLogger(HTISocket.class.getName());

    private HTISocket(String host, int port) throws IOException {
        super(host, port);
    }

    public static synchronized HTISocket getHTISocket() throws IOException {
        return HTISocket.getHTISocket(myHost, myPort);
    }

    public static synchronized HTISocket getHTISocket(String host, int port) throws IOException {
        String key = String.valueOf(host) + ":" + port;
        boolean createNew = false;
        if (ref == null || ref.isClosed()) {
            if (ref == null) {
                log.info("Current socket is null, checking pool");
            } else {
                log.info("Current socket was closed, creating new reference");
            }
            if (mySocketPool.containsKey(key)) {
                log.info("Returning socket from pool");
                ref = (HTISocket)mySocketPool.get(key);
                if (ref.isClosed()) {
                    log.info("Socket from pool was closed, creating new");
                    createNew = true;
                } else {
                    myHost = ref.getInetAddress().getHostName();
                    myPort = ref.getPort();
                }
            } else {
                createNew = true;
            }
            if (createNew) {
                log.info("Creating new socket and adding it to pool");
                myHost = host;
                myPort = port;
                ref = new HTISocket(host, port);
                HTISocket.ref.myOutput = new ThreadedOutputStream(ref.getOutputStream());
                mySocketPool.put(key, ref);
            }
        } else if (!myHost.equalsIgnoreCase(host) || myPort != port) {
            log.info("Changing socket");
            if (mySocketPool.containsKey(key)) {
                log.info("Returning socket from pool");
                ref = (HTISocket)mySocketPool.get(key);
                myHost = ref.getInetAddress().getHostName();
                myPort = ref.getPort();
            } else {
                log.info("Creating new socket and adding it to pool");
                myHost = host;
                myPort = port;
                ref = new HTISocket(host, port);
                HTISocket.ref.myOutput = new ThreadedOutputStream(ref.getOutputStream());
                mySocketPool.put(key, ref);
            }
        }
        return ref;
    }

    public synchronized void setInitialized(boolean initialized) {
        myInitialized = initialized;
    }

    public synchronized boolean isInitialized() {
        return myInitialized;
    }

    public synchronized void close() throws IOException {
        String key = String.valueOf(myHost) + ":" + myPort;
        if (this.getInetAddress() != null) {
            key = String.valueOf(this.getInetAddress().getHostName()) + ":" + this.getPort();
        }
        log.info("Closing socket: " + myHost + ":" + myPort);
        super.close();
        mySocketPool.remove(key);
        ref = null;
    }

    public synchronized OutputStream getOutputStream() {
        return this.myOutput;
    }

    public synchronized void setWriteTimeout(long timeout) {
        this.myOutput.setTimeout(timeout);
    }
}

