/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.HTI.SysInfoService;

import com.nokia.HTI.BaseService;
import com.nokia.HTI.HTIException;
import com.nokia.HTI.HTIMessage;
import com.nokia.HTI.IService;
import com.nokia.HTI.SysInfoService.MessageFactory;
import com.nokia.HTI.common.Util;
import java.io.IOException;
import java.util.logging.Logger;

public class SysInfoService
extends BaseService
implements IService {
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public HTIMessage setHomeTime(int year, int month, int day, int hour, int minute, int second) throws HTIException, IOException {
        return this.setHomeTime(year, month, day, hour, minute, second, 0L);
    }

    public HTIMessage setHomeTime(int year, int month, int day, int hour, int minute, int second, long timeout) throws HTIException, IOException {
        this.log.info("Setting time " + day + "." + month + "." + year + " " + hour + ":" + minute + ":" + second);
        HTIMessage command = MessageFactory.createSetHomeTimeMessage(year, month, day, hour, minute, second);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getHomeTime() throws HTIException, IOException {
        return this.getHomeTime(0L);
    }

    public HTIMessage getHomeTime(long timeout) throws HTIException, IOException {
        this.log.info("Getting time ");
        HTIMessage command = MessageFactory.createGetHomeTimeMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getFreeRAM() throws HTIException, IOException {
        return this.getFreeRAM(0L);
    }

    public HTIMessage getFreeRAM(long timeout) throws HTIException, IOException {
        this.log.info("Gettting amount of free RAM");
        HTIMessage command = MessageFactory.createGetFreeRAMMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getUsedRAM() throws HTIException, IOException {
        return this.getUsedRAM(0L);
    }

    public HTIMessage getUsedRAM(long timeout) throws HTIException, IOException {
        this.log.info("Gettting amount of used RAM");
        HTIMessage command = MessageFactory.createGetUsedRAMMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getTotalRAM() throws HTIException, IOException {
        return this.getTotalRAM(0L);
    }

    public HTIMessage getTotalRAM(long timeout) throws HTIException, IOException {
        this.log.info("Gettting amount of total RAM");
        HTIMessage command = MessageFactory.createGetTotalRAMMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage eatRAM(int sizeOfMemory) throws HTIException, IOException {
        return this.eatRAM(sizeOfMemory, 0L);
    }

    public HTIMessage eatRAM(int sizeOfMemory, long timeout) throws HTIException, IOException {
        this.log.info("Eating " + sizeOfMemory + " bytes");
        HTIMessage command = MessageFactory.createEatRAMMessage(sizeOfMemory);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage releaseRAM() throws HTIException, IOException {
        return this.releaseRAM(0L);
    }

    public HTIMessage releaseRAM(long timeout) throws HTIException, IOException {
        this.log.info("Releasing reserved RAM");
        HTIMessage command = MessageFactory.createReleaseRAMMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getFreeDiskSpace(char driveLetter) throws HTIException, IOException {
        return this.getFreeDiskSpace(driveLetter, 0L);
    }

    public HTIMessage getFreeDiskSpace(char driveLetter, long timeout) throws HTIException, IOException {
        this.log.info("Getting free disk space from drive " + driveLetter);
        HTIMessage command = MessageFactory.createGetFreeDiskSpaceMessage(driveLetter);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getUsedDiskSpace(char driveLetter) throws HTIException, IOException {
        return this.getUsedDiskSpace(driveLetter, 0L);
    }

    public HTIMessage getUsedDiskSpace(char driveLetter, long timeout) throws HTIException, IOException {
        this.log.info("Getting used disk space from drive " + driveLetter);
        HTIMessage command = MessageFactory.createGetUsedDiskSpaceMessage(driveLetter);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getTotalDiskSpace(char driveLetter) throws HTIException, IOException {
        return this.getTotalDiskSpace(driveLetter, 0L);
    }

    public HTIMessage getTotalDiskSpace(char driveLetter, long timeout) throws HTIException, IOException {
        this.log.info("Getting total disk space from drive " + driveLetter);
        HTIMessage command = MessageFactory.createGetTotalDiskSpaceMessage(driveLetter);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage eatDiskSpace(char driveLetter, long leaveBytes) throws HTIException, IOException {
        return this.eatDiskSpace(driveLetter, leaveBytes, 0L);
    }

    public HTIMessage eatDiskSpace(char driveLetter, long leaveBytes, long timeout) throws HTIException, IOException {
        this.log.info("Eating disk space from drive " + driveLetter + " leaving " + leaveBytes + " bytes free");
        HTIMessage command = MessageFactory.createEatDiskSpaceMessage(driveLetter, leaveBytes);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage releaseDiskSpace(char driveLetter) throws HTIException, IOException {
        return this.releaseDiskSpace(driveLetter, 0L);
    }

    public HTIMessage releaseDiskSpace(char driveLetter, long timeout) throws HTIException, IOException {
        this.log.info("Releasing previously eaten disk space from drive " + driveLetter);
        HTIMessage command = MessageFactory.createReleaseDiskSpaceMessage(driveLetter);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage getLightStatus(byte lightTarget) throws HTIException, IOException {
        return this.getLightStatus(lightTarget, 0L);
    }

    public HTIMessage getLightStatus(byte lightTarget, long timeout) throws HTIException, IOException {
        this.log.info("Getting status of lights");
        HTIMessage command = MessageFactory.createLightStatusMessage(lightTarget);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setLightOn(byte lightTarget, int duration, byte intensity, boolean fadeIn) throws HTIException, IOException {
        return this.setLightOn(lightTarget, duration, intensity, fadeIn, 0L);
    }

    public HTIMessage setLightOn(byte lightTarget, int duration, byte intensity, boolean fadeIn, long timeout) throws HTIException, IOException {
        this.log.info("Setting lights on");
        HTIMessage command = MessageFactory.createLightOnMessage(lightTarget, duration, intensity, fadeIn);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setLightOff(byte lightTarget, int duration, boolean fadeOut) throws HTIException, IOException {
        return this.setLightOff(lightTarget, duration, fadeOut, 0L);
    }

    public HTIMessage setLightOff(byte lightTarget, int duration, boolean fadeOut, long timeout) throws HTIException, IOException {
        this.log.info("Setting lights off");
        HTIMessage command = MessageFactory.createLightOffMessage(lightTarget, duration, fadeOut);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage setLightBlink(byte lightTarget, int duration, int onDuration, int offDuration, byte intensity) throws HTIException, IOException {
        return this.setLightBlink(lightTarget, duration, onDuration, offDuration, intensity, 0L);
    }

    public HTIMessage setLightBlink(byte lightTarget, int duration, int onDuration, int offDuration, byte intensity, long timeout) throws HTIException, IOException {
        this.log.info("Setting lights to blink");
        HTIMessage command = MessageFactory.createLightBlinkMessage(lightTarget, duration, onDuration, offDuration, intensity);
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public HTIMessage releaseLight() throws HTIException, IOException {
        return this.releaseLight(0L);
    }

    public HTIMessage releaseLight(long timeout) throws HTIException, IOException {
        this.log.info("Releasing lights");
        HTIMessage command = MessageFactory.createReleaseLightMessage();
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return response;
    }

    public int setNetworkMode(int mode, boolean reboot) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetNetworkModeMessage(mode, reboot);
        this.log.finest("Sending set network message");
        if (reboot) {
            this.sendHTIAsyncMessage(command, 5000L);
        } else {
            HTIMessage response = this.sendHTIRequest(command, 5000L);
            if (response.isErrorResponse()) {
                return -1;
            }
        }
        return 0;
    }

    public int getNetworkMode() throws HTIException, IOException {
        return this.getNetworkMode(0L);
    }

    public int getNetworkMode(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetNetworkModeMessage();
        this.log.finest("Sending get network message");
        HTIMessage response = this.sendHTIRequest(command, timeout);
        if (response.isErrorResponse()) {
            return -1;
        }
        int mode = Util.littleEndianToInt(response, 1);
        return mode;
    }

    public HTIMessage setBluetoothPower(boolean on, boolean force, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetBluetoothPowerMessage(on, force);
        this.log.finest("Sending bluetooth power message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage setBluetoothSettings(boolean discoverable, boolean enableSAP, String btName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetBluetoothSettingsMessage(discoverable, enableSAP, btName);
        this.log.finest("Sending bluetooth settings message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage deleteBluetoothPairing(boolean deleteActive, String pairingName, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDeleteBluetoothPairingMessage(deleteActive, pairingName);
        this.log.finest("Sending delete bluetooth pairing message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage activateIR(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createActivateIRMessage();
        this.log.finest("Sending activate IR message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage toggleKeyLock(boolean lock, boolean showInfoNote, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createToggleKeyLockMessage(lock, showInfoNote);
        this.log.finest("Sending toggle key lock message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage setAutoKeyGuardTime(int time, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetAutoKeyGuardTimeMessage(time);
        this.log.finest("Sending set auto key guard timemessage");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage disableScreenSaver() throws HTIException, IOException {
        return this.disableScreenSaver(0L);
    }

    public HTIMessage disableScreenSaver(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createDisableScreenSaverMessage();
        this.log.finest("Sending disable screen saver message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage enableScreenSaver() throws HTIException, IOException {
        return this.enableScreenSaver(0L);
    }

    public HTIMessage enableScreenSaver(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createEnableScreenSaverMessage();
        this.log.finest("Sending enable screen saver message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage setScreenSaverTimeout(byte period) throws HTIException, IOException {
        return this.setScreenSaverTimeout(period, 0L);
    }

    public HTIMessage setScreenSaverTimeout(byte period, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetScreenSaverTimeoutMessage(period);
        this.log.finest("Sending set screen saver timeout message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage emptyDrmRightsDb() throws HTIException, IOException {
        return this.emptyDrmRightsDb(0L);
    }

    public HTIMessage emptyDrmRightsDb(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.emptyDRMRightsDatabase();
        this.log.finest("Sending empty DRM rights database message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getIMEI() throws HTIException, IOException {
        return this.getIMEI(0L);
    }

    public HTIMessage getIMEI(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetIMEIMessage();
        this.log.finest("Sending get IMEI message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getHAL() throws HTIException, IOException {
        return this.getHAL(0L);
    }

    public HTIMessage getHAL(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetHALMessage();
        this.log.finest("Sending get HAL message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getSWVersion() throws HTIException, IOException {
        return this.getSWVersion(0L);
    }

    public HTIMessage getSWVersion(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetSWVersionMessage();
        this.log.finest("Sending get SW version message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getLangVersion() throws HTIException, IOException {
        return this.getLangVersion(0L);
    }

    public HTIMessage getLangVersion(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetLangVersionMessage();
        this.log.finest("Sending get Lang version message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getSWLangVersion() throws HTIException, IOException {
        return this.getSWLangVersion(0L);
    }

    public HTIMessage getSWLangVersion(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetSWLangVersionMessage();
        this.log.finest("Sending get SW Lang version message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getUserAgentString() throws HTIException, IOException {
        return this.getLangVersion(0L);
    }

    public HTIMessage getUserAgentString(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetUserAgentStringMessage();
        this.log.finest("Sending get User agent string message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getBatteryStatus() throws HTIException, IOException {
        return this.getBatteryStatus(0L);
    }

    public HTIMessage getBatteryStatus(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetBatteryStatusMessage();
        this.log.finest("Sending get battery status message");
        return this.sendHTIRequest(command, timeout);
    }

    public HTIMessage getSignalStrength() throws HTIException, IOException {
        return this.getSignalStrength(0L);
    }

    public HTIMessage getSignalStrength(long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createGetSignalStrengthMessage();
        this.log.finest("Sending get signal strength message");
        return this.sendHTIRequest(command, timeout);
    }

    public boolean setHSDPA(boolean enabled) throws HTIException, IOException {
        return this.setHSDPA(enabled, 0L);
    }

    public boolean setHSDPA(boolean enabled, long timeout) throws HTIException, IOException {
        HTIMessage command = MessageFactory.createSetHSDPAMessage(enabled);
        this.log.finest("Sending set HSDPA message");
        HTIMessage response = this.sendHTIRequest(command, timeout);
        return !response.isErrorResponse();
    }
}

