/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGModule;
import com.nokia.svg2svgt.log.Logger;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GreyListAnalyzer
implements ConversionConstants {
    private Document myDocument = null;
    private ArrayList myGreyList = null;
    private Logger myLogger = null;

    public GreyListAnalyzer(String fileName, Logger logger) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException, IllegalArgumentException {
        this.myLogger = logger;
        this.myDocument = XMLFileParser.parseFile(fileName, false);
        this.loadGreyListFile();
    }

    public ArrayList getGreyListModules() {
        return this.myGreyList;
    }

    public boolean isGreyListedTag(Node node) {
        SVGAttribute svgAttr;
        String nodeName = node.getNodeName();
        if (1 == node.getNodeType()) {
            SVGElement svgElem = this.fetchElementByTagName(nodeName);
            if (svgElem != null) {
                return svgElem.isWarned();
            }
        } else if (2 == node.getNodeType() && (svgAttr = this.fetchAttributeByTagName(nodeName)) != null) {
            return true;
        }
        return false;
    }

    public int containsElement(String elementName) {
        if (this.myGreyList == null) {
            return -1;
        }
        Iterator iter = this.myGreyList.iterator();
        int indexCount = 0;
        SVGModule svgModule = null;
        while (iter.hasNext()) {
            svgModule = (SVGModule)iter.next();
            if (-1 != svgModule.containsElement(elementName)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public SVGElement fetchElementContainingAttribute(String attrName) {
        if (this.myGreyList == null) {
            return null;
        }
        Iterator iter = this.myGreyList.iterator();
        SVGModule svgModule = null;
        if (iter.hasNext()) {
            svgModule = (SVGModule)iter.next();
            return svgModule.getElementContainingAttribute(attrName);
        }
        return null;
    }

    public SVGElement fetchElementByTagName(String elementName) {
        if (this.myGreyList == null) {
            return null;
        }
        Iterator iter = this.myGreyList.iterator();
        SVGModule svgModule = null;
        if (iter.hasNext()) {
            svgModule = (SVGModule)iter.next();
            return svgModule.getElementByTagName(elementName);
        }
        return null;
    }

    public SVGAttribute fetchAttributeByTagName(String attrName) {
        if (this.myGreyList == null) {
            return null;
        }
        Iterator iter = this.myGreyList.iterator();
        SVGModule svgModule = null;
        boolean elemIndex = false;
        if (iter.hasNext()) {
            svgModule = (SVGModule)iter.next();
            return svgModule.getAttributeByTagName(attrName);
        }
        return null;
    }

    private void loadGreyListFile() {
        Element rootElement = this.myDocument.getDocumentElement();
        String name = rootElement.getTagName();
        if (!rootElement.getTagName().equalsIgnoreCase("greyList")) {
            return;
        }
        NodeList moduleNodes = rootElement.getElementsByTagName("module");
        Element module = null;
        this.myGreyList = new ArrayList();
        SVGModule svgModule = null;
        String moduleName = null;
        int i = 0;
        while (i < moduleNodes.getLength()) {
            ArrayList elementNodes;
            module = (Element)moduleNodes.item(i);
            moduleName = module.getAttribute("name");
            if (moduleName != null && ((elementNodes = this.resolveElementsInModule(module, moduleName)) != null || elementNodes.size() > 0)) {
                svgModule = new SVGModule(moduleName);
                svgModule.addElements(elementNodes);
                this.myGreyList.add(svgModule);
            }
            ++i;
        }
    }

    private ArrayList resolveElementsInModule(Element module, String moduleName) {
        Element element = null;
        String elementName = null;
        String isMarked = null;
        SVGElement svgElement = null;
        ArrayList<SVGElement> elementList = new ArrayList<SVGElement>();
        NodeList elementNodes = module.getElementsByTagName("element");
        int i = 0;
        while (i < elementNodes.getLength()) {
            element = (Element)elementNodes.item(i);
            elementName = element.getAttribute("name");
            isMarked = element.getAttribute("remove");
            if (elementName != null) {
                svgElement = new SVGElement(elementName, moduleName);
                svgElement.setWarn(false);
                ArrayList attrList = this.resolveAttributesInElement(element, moduleName, elementName);
                if (attrList != null || attrList.size() > 0) {
                    svgElement.addAttributes(attrList);
                }
                elementList.add(svgElement);
            }
            ++i;
        }
        return elementList;
    }

    private ArrayList resolveAttributesInElement(Element element, String moduleName, String elementName) {
        Attr attr = null;
        Element attribute = null;
        String attributeName = null;
        String attributeValue = null;
        SVGAttribute svgAttribute = null;
        ArrayList<SVGAttribute> attributesList = new ArrayList<SVGAttribute>();
        NodeList attributeNodes = element.getElementsByTagName("attribute");
        int i = 0;
        while (i < attributeNodes.getLength()) {
            attribute = (Element)attributeNodes.item(i);
            attr = attribute.getAttributeNode("name");
            if (attr != null) {
                attributeName = attr.getValue();
                attr = attribute.getAttributeNode("value");
                if (attr != null) {
                    attributeValue = attr.getValue();
                }
                svgAttribute = new SVGAttribute(attributeName, elementName, moduleName, null, attributeValue);
                attributesList.add(svgAttribute);
            } else {
                NodeList attrSet;
                String attrSetName;
                attr = attribute.getAttributeNode("attrset");
                if (attr != null && (attrSetName = attr.getValue()) != null && (attrSet = this.myDocument.getElementsByTagName(attrSetName)) != null) {
                    int j = 0;
                    while (j < attrSet.getLength()) {
                        Element attrSetElement = (Element)attrSet.item(j);
                        ArrayList attrSetAttrs = this.resolveAttributesInElement(attrSetElement, moduleName, elementName);
                        if (attrSetAttrs != null || attrSetAttrs.size() > 0) {
                            attributesList.addAll(attrSetAttrs);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return attributesList;
    }

    private void raiseWarningForTags() {
    }
}

