/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.log.Logger;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NonReferredIdRemover
implements ConversionConstants {
    private static Hashtable myReferencedIdData = new Hashtable();
    private static Hashtable myAllIdData = new Hashtable();
    private static Hashtable myOrphanReferenceData = new Hashtable();

    public static void processNonReferencedIDs(Document svgtDoc, Logger logger) {
        Element rootElem = svgtDoc.getDocumentElement();
        if (rootElem == null) {
            return;
        }
        myAllIdData.clear();
        myOrphanReferenceData.clear();
        myReferencedIdData.clear();
        NonReferredIdRemover.trackReferredIds(rootElem);
        NonReferredIdRemover.trackOrphanReferences();
        NonReferredIdRemover.removeNonReferencedIDs(rootElem);
    }

    public static Hashtable getReferencedIdentifiers() {
        return myReferencedIdData;
    }

    private static void trackOrphanReferences() {
        Enumeration enum1 = myAllIdData.keys();
        while (enum1.hasMoreElements()) {
            String orphanRef = (String)enum1.nextElement();
            if (myReferencedIdData.containsKey(orphanRef)) continue;
            myOrphanReferenceData.put(orphanRef, myAllIdData.get(orphanRef));
        }
    }

    private static void removeNonReferencedIDs(Node node) {
        NamedNodeMap attrList = null;
        if (node.hasAttributes()) {
            attrList = node.getAttributes();
            NonReferredIdRemover.removeOrphanReferenceNodes(attrList, node);
            Attr idAttr = ((Element)node).getAttributeNode("id");
            if (idAttr != null) {
                NonReferredIdRemover.checkAndRemoveNonReferredId(idAttr, node);
            }
        }
        NodeList nodeList = node.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            childNode = nodeList.item(i);
            if (1 == childNode.getNodeType()) {
                if (childNode.hasAttributes()) {
                    attrList = childNode.getAttributes();
                    NonReferredIdRemover.removeOrphanReferenceNodes(attrList, childNode);
                    Attr idAttr = ((Element)node).getAttributeNode("id");
                    if (idAttr != null) {
                        NonReferredIdRemover.checkAndRemoveNonReferredId(idAttr, childNode);
                    }
                }
                NonReferredIdRemover.removeNonReferencedIDs(childNode);
            }
            ++i;
        }
    }

    private static void removeOrphanReferenceNodes(NamedNodeMap attrList, Node parentNode) {
        if (myOrphanReferenceData.size() == 0) {
            return;
        }
        Enumeration enum1 = null;
        String orphanRef = null;
        int i = 0;
        while (i < attrList.getLength()) {
            enum1 = myOrphanReferenceData.keys();
            Attr attribute = (Attr)attrList.item(i);
            String attrValue = attribute.getNodeValue();
            while (enum1.hasMoreElements()) {
                NamedNodeMap map;
                Node tempNode;
                orphanRef = (String)enum1.nextElement();
                if (!attrValue.equalsIgnoreCase(orphanRef) || (tempNode = (map = parentNode.getAttributes()).getNamedItem(attribute.getName())) == null) continue;
                ((Element)parentNode).removeAttributeNode(attribute);
            }
            ++i;
        }
    }

    private static void checkAndRemoveNonReferredId(Attr attribute, Node parentNode) {
        String attrValue = attribute.getValue();
        if (!myReferencedIdData.containsKey(attrValue)) {
            ((Element)parentNode).removeAttributeNode(attribute);
        }
    }

    private static void trackReferredIds(Node node) {
        Object id = null;
        Node attribute = null;
        if (node.hasAttributes()) {
            NamedNodeMap attrList = node.getAttributes();
            int i = 0;
            while (i < attrList.getLength()) {
                attribute = attrList.item(i);
                NonReferredIdRemover.checkIdReference((Attr)attribute, node);
                ++i;
            }
        }
        NodeList nodeList = node.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            childNode = nodeList.item(i);
            if (1 == childNode.getNodeType()) {
                if (childNode.hasAttributes()) {
                    NamedNodeMap attrList = childNode.getAttributes();
                    int j = 0;
                    while (j < attrList.getLength()) {
                        attribute = attrList.item(j);
                        NonReferredIdRemover.checkIdReference((Attr)attribute, childNode);
                        ++j;
                    }
                }
                NonReferredIdRemover.trackReferredIds(childNode);
            }
            ++i;
        }
    }

    private static void checkIdReference(Attr attribute, Node parentNode) {
        int startIndex;
        String tempStr;
        String attrName = null;
        String attrValue = null;
        attrName = attribute.getNodeName();
        attrValue = attribute.getNodeValue();
        if (attrName.equals("id")) {
            myAllIdData.put(attrValue, parentNode.getNodeName());
        }
        if (-1 != attrValue.indexOf("url(#")) {
            int startIndex2 = attrValue.indexOf("url(#");
            String tempStr2 = attrValue.substring(startIndex2 + "url(#".length());
            if (!myReferencedIdData.containsKey(tempStr2 = tempStr2.substring(0, tempStr2.indexOf(")")))) {
                myReferencedIdData.put(tempStr2, parentNode.getNodeName());
            }
        } else if (-1 != attrValue.indexOf("#xpointer(\"")) {
            int startIndex3 = attrValue.indexOf("#xpointer(\"");
            String tempStr3 = attrValue.substring(startIndex3 + "#xpointer(\"".length());
            if (!myReferencedIdData.containsKey(tempStr3 = tempStr3.substring(0, tempStr3.indexOf("\")")))) {
                myReferencedIdData.put(tempStr3, parentNode.getNodeName());
            }
        } else if (-1 != attrValue.indexOf("#") && !myReferencedIdData.containsKey(tempStr = attrValue.substring((startIndex = attrValue.indexOf("#")) + 1))) {
            myReferencedIdData.put(tempStr, parentNode.getNodeName());
        }
    }

    public static void main(String[] args) {
        try {
            Document svgtDoc = XMLFileParser.parseFile("C:\\SVG\\samples\\Mine.svg", false);
            NonReferredIdRemover.processNonReferencedIDs(svgtDoc, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

