/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.Conversions;
import com.nokia.svg2svgt.log.Logger;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PercentageConverterForHeightAndWidthTag
implements Conversions,
ConversionConstants {
    private Logger myLogger = null;

    public void doConversion(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, Logger logger, String nsURL) {
        this.myLogger = logger;
        Element parentNode = ((Attr)svgNode).getOwnerElement();
        if (!parentNode.getNodeName().equals("svg")) {
            return;
        }
        if (2 != svgNode.getNodeType()) {
            return;
        }
        if (1 != svgtNode.getNodeType()) {
            return;
        }
        Element svgtParentElement = (Element)svgtNode;
        String elemName = svgNode.getNodeName();
        if (elemName.equalsIgnoreCase("width") || elemName.equalsIgnoreCase("height")) {
            ResourceBundle bundle = ResourceBundle.getBundle("SVG2SVGTProperties");
            try {
                String value = bundle.getString("OVERWRITE_DIMENSION");
                if (value.length() > 0) {
                    Attr svgtAttr = svgtDoc.createAttribute(elemName);
                    svgtAttr.setValue(value.trim());
                    svgtParentElement.setAttributeNode(svgtAttr);
                }
            }
            catch (MissingResourceException mre) {
                Attr svgtAttr = svgtDoc.createAttribute(elemName);
                svgtAttr.setValue(((Attr)svgNode).getValue());
                svgtParentElement.setAttributeNode(svgtAttr);
            }
        }
    }

    private void logEvent(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }

    private void logWarning(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }
}

