/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.SVGAttribute;
import java.util.ArrayList;
import java.util.Iterator;

public class SVGElement {
    private String myName = null;
    private String myParentName = null;
    private ArrayList myAttributes = null;
    private boolean isWarned = false;

    public SVGElement(String elementName, String parentName) {
        this.myName = elementName;
        this.myParentName = parentName;
    }

    public void addAttribute(SVGAttribute attribute) {
        if (this.myAttributes == null) {
            this.myAttributes = new ArrayList();
        }
        if (attribute != null) {
            this.myAttributes.add(attribute);
        }
    }

    public void addAttributes(ArrayList attributeList) {
        if (this.myAttributes == null) {
            this.myAttributes = new ArrayList();
        }
        if (attributeList != null || attributeList.size() > 0) {
            this.myAttributes.addAll(attributeList);
        }
    }

    public void removeAttribute(String attributeName) {
        int foundElement = this.containsAttribute(attributeName);
        this.myAttributes.remove(foundElement);
    }

    public void removeAttribute(String attributeName, String value) {
        int foundElement = this.containsAttribute(attributeName, value);
        this.myAttributes.remove(foundElement);
    }

    public int containsAttribute(String attributeName) {
        if (this.myAttributes == null) {
            return -1;
        }
        Iterator iter = this.myAttributes.iterator();
        SVGAttribute attribute = null;
        int indexCount = 0;
        while (iter.hasNext()) {
            attribute = (SVGAttribute)iter.next();
            if (attribute.getAttributeName().equalsIgnoreCase(attributeName)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public int containsAttribute(String attributeName, Object value) {
        if (this.myAttributes == null) {
            return -1;
        }
        Iterator iter = this.myAttributes.iterator();
        SVGAttribute attribute = null;
        int indexCount = 0;
        while (iter.hasNext()) {
            attribute = (SVGAttribute)iter.next();
            if (attribute.getAttributeName().equalsIgnoreCase(attributeName) && attribute.getAttributeValue().equals(value)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public SVGAttribute getAttributeAt(int index) {
        if ((this.myAttributes != null || this.myAttributes.size() > 0) && index < this.myAttributes.size()) {
            return (SVGAttribute)this.myAttributes.get(index);
        }
        return null;
    }

    public SVGAttribute getAttributeByTagName(String attrName) {
        int attrIndex = this.containsAttribute(attrName);
        if (-1 != attrIndex) {
            return (SVGAttribute)this.myAttributes.get(attrIndex);
        }
        return null;
    }

    public ArrayList getElementAttributes() {
        return this.myAttributes;
    }

    public String getElementName() {
        return this.myName;
    }

    public String getParentModuleName() {
        return this.myParentName;
    }

    public boolean isWarned() {
        return this.isWarned;
    }

    public void setWarn(boolean mark) {
        this.isWarned = mark;
    }

    public String toString() {
        return this.myName;
    }

    public static void main(String[] args) {
    }
}

