/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import java.util.ArrayList;
import java.util.Iterator;

public class SVGNameSpace {
    private ArrayList myElements = null;
    private String myName = null;
    private String myUri = "";
    private boolean isURI = false;
    private boolean isWarn = false;
    private boolean isallowed = false;

    public SVGNameSpace(String nameSpaceName) {
        this.myName = nameSpaceName;
    }

    public void addElement(SVGElement element) {
        if (this.myElements == null) {
            this.myElements = new ArrayList();
        }
        if (element != null) {
            this.myElements.add(element);
        }
    }

    public void addElements(ArrayList elementList) {
        if (this.myElements == null) {
            this.myElements = new ArrayList();
        }
        if (elementList != null || elementList.size() > 0) {
            this.myElements.addAll(elementList);
        }
    }

    public void removeElement(String elementName) {
        int elementIndex = this.containsElement(elementName);
        if (-1 != elementIndex) {
            this.myElements.remove(elementIndex);
        }
    }

    public String getnameSpaceName() {
        return this.myName;
    }

    public ArrayList getnameSpaceElements() {
        return this.myElements;
    }

    public int containsElement(String elementName) {
        if (this.myElements == null) {
            return -1;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        int indexCount = 0;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            if (element.getElementName().equalsIgnoreCase(elementName)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public SVGAttribute getAttributeByTagName(String attrName) {
        if (this.myElements == null) {
            return null;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        boolean indexCount = false;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            int attrIndex = element.containsAttribute(attrName);
            if (-1 == attrIndex) continue;
            return element.getAttributeAt(attrIndex);
        }
        return null;
    }

    public SVGElement getElementByTagName(String elemName) {
        int elementIndex = this.containsElement(elemName);
        if (-1 != elementIndex) {
            return (SVGElement)this.myElements.get(elementIndex);
        }
        return null;
    }

    public SVGElement getElementContainingAttribute(String attrName) {
        if (this.myElements == null) {
            return null;
        }
        Iterator iter = this.myElements.iterator();
        SVGElement element = null;
        while (iter.hasNext()) {
            element = (SVGElement)iter.next();
            int attrIndex = element.containsAttribute(attrName);
            if (-1 == attrIndex) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return this.myName;
    }

    public boolean isURI() {
        return this.isURI;
    }

    public boolean isWarn() {
        return this.isWarn;
    }

    public String getMyUri() {
        return this.myUri;
    }

    public void setURI(boolean b) {
        this.isURI = b;
    }

    public void setWarn(boolean b) {
        this.isWarn = b;
    }

    public void setMyUri(String string) {
        this.myUri = string;
    }

    public static void main(String[] args) {
    }

    public boolean isIsallowed() {
        return this.isallowed;
    }

    public void setIsallowed(boolean b) {
        this.isallowed = b;
    }
}

