/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.SVG2SVGTConstants;
import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.gui.ConFigButton;
import com.nokia.svg2svgt.gui.SVG2SVGTMainView;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.gui.SVGTFileChooser;
import com.nokia.svg2svgt.localiser.Localiser;
import com.nokia.svg2svgt.util.WCMatcher;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigPanel
extends JPanel
implements ActionListener,
SVG2SVGTConstants,
ConversionConstants,
CaretListener {
    private SVGTConverterController myController = null;
    private JPanel inputPanel;
    private TitledBorder titledBorder1;
    private JPanel configPanel;
    private TitledBorder titledBorder2;
    private JPanel controlPanel;
    private JLabel selectIFlabel;
    private JList inputSVGFilesList;
    private JScrollPane inputSVGFilesScrollPane;
    private JButton inputSVGFilesButton;
    private JPanel outPanel;
    private JPanel passTPanel;
    private JPanel critcleSPanel;
    private JLabel outputDLabel;
    private JTextField outputDirTextField;
    private JButton outputDirButton;
    private JLabel passThroughLabel;
    private JTextField passThroughTextField;
    private JButton passThroughButton;
    private JLabel criticleFSLabel;
    private JTextField criticleFSTextField;
    private JLabel kBytes;
    private JButton convertButton;
    private JButton resetButton;
    private final String inputdir_key = "inputFilePath";
    private final String critical_key = "criticlesize";
    private Localiser myLocaliser = null;
    private Hashtable mytable = null;
    private boolean modified = false;
    Vector vector = null;
    Vector vector1 = null;
    private Frame frame = null;
    private SVG2SVGTMainView myMainVeiw = null;
    private ConFigButton config = null;
    public ActionEvent ev = null;

    public ConfigPanel(SVGTConverterController parent, Localiser localiser, Frame frame, ConFigButton config, SVG2SVGTMainView mainVeiw) {
        this.config = config;
        this.myLocaliser = localiser;
        this.myMainVeiw = mainVeiw;
        this.myController = parent;
        this.frame = frame;
        try {
            this.createConfigPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createConfigPanel() throws Exception {
        this.selectIFlabel = new JLabel(this.myLocaliser.getText("mainPanel.inputPanel.inputSVGFileslabel"));
        this.selectIFlabel.setPreferredSize(new Dimension(100, 24));
        this.selectIFlabel.setMaximumSize(new Dimension(100, 24));
        this.inputSVGFilesList = new JList();
        this.inputSVGFilesList.setModel(new DefaultListModel());
        this.inputSVGFilesList.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.selectIFTextField"));
        this.inputSVGFilesScrollPane = new JScrollPane(this.inputSVGFilesList);
        this.inputSVGFilesScrollPane.setPreferredSize(new Dimension(180, 60));
        this.inputSVGFilesScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.inputSVGFilesButton = new JButton(this.myLocaliser.getText("mainPanel.Button"));
        this.inputSVGFilesButton.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.selectIFButton"));
        this.inputSVGFilesButton.setPreferredSize(new Dimension(90, 24));
        this.inputSVGFilesButton.setMaximumSize(new Dimension(90, 24));
        this.inputSVGFilesButton.addActionListener(this);
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 0));
        this.inputPanel.setPreferredSize(new Dimension(397, 96));
        this.inputPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), this.myLocaliser.getText("mainPanel.inputPanel.Title"));
        this.inputPanel.setBorder(this.titledBorder1);
        this.inputPanel.add(Box.createHorizontalStrut(12));
        this.inputPanel.add(this.selectIFlabel);
        this.inputPanel.add(Box.createHorizontalStrut(5));
        this.inputPanel.add(this.inputSVGFilesScrollPane);
        this.inputPanel.add(Box.createHorizontalStrut(5));
        this.inputPanel.add(this.inputSVGFilesButton);
        this.inputPanel.add(Box.createHorizontalStrut(12));
        this.outputDLabel = new JLabel(this.myLocaliser.getText("mainPanel.outputDLabel"));
        this.outputDLabel.setPreferredSize(new Dimension(100, 24));
        this.outputDLabel.setMaximumSize(new Dimension(100, 24));
        this.outputDirTextField = new JTextField("");
        this.outputDirTextField.setToolTipText(this.myLocaliser.getToolTipText("mainpanel.outputDTextField"));
        this.outputDirTextField.setPreferredSize(new Dimension(180, 24));
        this.outputDirTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
        this.outputDirTextField.setEditable(false);
        this.outputDirTextField.setBackground(Color.WHITE);
        this.outputDirTextField.addCaretListener(this);
        this.outputDirButton = new JButton(this.myLocaliser.getText("mainPanel.Button"));
        this.outputDirButton.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.outputDButton"));
        this.outputDirButton.setPreferredSize(new Dimension(90, 24));
        this.outputDirButton.setMaximumSize(new Dimension(90, 24));
        this.outputDirButton.addActionListener(this);
        this.outPanel = new JPanel();
        this.outPanel.setLayout(new BoxLayout(this.outPanel, 0));
        this.outPanel.setPreferredSize(new Dimension(397, 36));
        this.outPanel.add(Box.createHorizontalStrut(12));
        this.outPanel.add(this.outputDLabel);
        this.outPanel.add(Box.createHorizontalStrut(5));
        this.outPanel.add(this.outputDirTextField);
        this.outPanel.add(Box.createHorizontalStrut(5));
        this.outPanel.add(this.outputDirButton);
        this.outPanel.add(Box.createHorizontalStrut(12));
        this.passThroughLabel = new JLabel(this.myLocaliser.getText("mainPanel.passThroughLabel"));
        this.passThroughLabel.setMaximumSize(new Dimension(100, 24));
        this.passThroughLabel.setPreferredSize(new Dimension(100, 24));
        this.passThroughTextField = new JTextField("");
        this.passThroughTextField.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.PassThroughTextField"));
        this.passThroughTextField.setPreferredSize(new Dimension(180, 24));
        this.passThroughTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
        this.passThroughTextField.setEditable(false);
        this.passThroughTextField.setBackground(Color.WHITE);
        this.passThroughTextField.addCaretListener(this);
        this.passThroughButton = new JButton(this.myLocaliser.getText("mainPanel.Button"));
        this.passThroughButton.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.PassThroughButton"));
        this.passThroughButton.setPreferredSize(new Dimension(90, 24));
        this.passThroughButton.setMaximumSize(new Dimension(90, 24));
        this.passThroughButton.addActionListener(this);
        this.passTPanel = new JPanel();
        this.passTPanel.setLayout(new BoxLayout(this.passTPanel, 0));
        this.passTPanel.add(Box.createHorizontalStrut(12));
        this.passTPanel.add(this.passThroughLabel);
        this.passTPanel.add(Box.createHorizontalStrut(5));
        this.passTPanel.add(this.passThroughTextField);
        this.passTPanel.add(Box.createHorizontalStrut(5));
        this.passTPanel.add(this.passThroughButton);
        this.passTPanel.add(Box.createHorizontalStrut(12));
        this.criticleFSLabel = new JLabel(this.myLocaliser.getText("mainPanel.criticleFSLabel"));
        this.criticleFSLabel.setPreferredSize(new Dimension(100, 24));
        this.criticleFSLabel.setMaximumSize(new Dimension(100, 24));
        this.criticleFSTextField = new JTextField("");
        this.criticleFSTextField.setToolTipText(this.myLocaliser.getToolTipText("mainPanel.criticleFSTextField"));
        this.criticleFSTextField.setPreferredSize(new Dimension(180, 24));
        this.criticleFSTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
        this.criticleFSTextField.addCaretListener(this);
        this.kBytes = new JLabel(this.myLocaliser.getText("mainPanel.kBytes"));
        this.kBytes.setPreferredSize(new Dimension(90, 24));
        this.kBytes.setMaximumSize(new Dimension(90, 24));
        this.critcleSPanel = new JPanel();
        this.critcleSPanel.setLayout(new BoxLayout(this.critcleSPanel, 0));
        this.critcleSPanel.setPreferredSize(new Dimension(397, 36));
        this.critcleSPanel.add(Box.createHorizontalStrut(12));
        this.critcleSPanel.add(this.criticleFSLabel);
        this.critcleSPanel.add(Box.createHorizontalStrut(5));
        this.critcleSPanel.add(this.criticleFSTextField);
        this.critcleSPanel.add(Box.createHorizontalStrut(5));
        this.critcleSPanel.add(this.kBytes);
        this.critcleSPanel.add(Box.createHorizontalStrut(12));
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.configPanel.setPreferredSize(new Dimension(397, 130));
        this.configPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), this.myLocaliser.getText("mainPanel.configPanel.title"));
        this.configPanel.setBorder(this.titledBorder2);
        this.configPanel.add(Box.createVerticalStrut(5));
        this.configPanel.add(this.outPanel);
        this.configPanel.add(Box.createVerticalStrut(5));
        this.configPanel.add(this.passTPanel);
        this.configPanel.add(Box.createVerticalStrut(5));
        this.configPanel.add(this.critcleSPanel);
        this.configPanel.add(Box.createVerticalStrut(5));
        this.convertButton = new JButton(this.myLocaliser.getText("mainPanel.convertButton"));
        this.convertButton.setPreferredSize(new Dimension(80, 24));
        this.convertButton.setMaximumSize(new Dimension(80, 24));
        this.convertButton.setEnabled(false);
        this.convertButton.addActionListener(this);
        this.resetButton = new JButton(this.myLocaliser.getText("mainPanel.resetButton"));
        this.resetButton.setPreferredSize(new Dimension(80, 24));
        this.resetButton.setMaximumSize(new Dimension(80, 24));
        this.resetButton.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.controlPanel.setPreferredSize(new Dimension(397, 36));
        this.controlPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.controlPanel.add(Box.createHorizontalGlue());
        this.controlPanel.add(this.convertButton);
        this.controlPanel.add(Box.createHorizontalStrut(5));
        this.controlPanel.add(this.resetButton);
        this.controlPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.add(Box.createVerticalStrut(5));
        this.add(this.inputPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.configPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.controlPanel);
        this.add(Box.createVerticalStrut(5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.inputSVGFilesList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int toBeDeletedItem = ConfigPanel.this.inputSVGFilesList.getSelectedIndex();
                    ConfigPanel.this.vector.remove(ConfigPanel.this.inputSVGFilesList.getModel().getElementAt(toBeDeletedItem));
                    ConfigPanel.this.inputSVGFilesList.setListData(ConfigPanel.this.vector);
                }
            }
        });
        this.inputSVGFilesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ConfigPanel.this.inputSVGFilesList != null) {
                    if (ConfigPanel.this.inputSVGFilesList.getSelectedValues() != null) {
                        ConfigPanel.this.convertButton.setEnabled(true);
                    }
                    if (ConfigPanel.this.inputSVGFilesList.getSelectedValue() == null) {
                        ConfigPanel.this.convertButton.setEnabled(false);
                    }
                    if (ConfigPanel.this.inputSVGFilesList.isSelectionEmpty()) {
                        ConfigPanel.this.config.setIfListisEmty(true);
                    } else {
                        ConfigPanel.this.config.setIfListisEmty(false);
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        block21: {
            if (e.getSource().equals(this.inputSVGFilesButton)) {
                String inputFilePath = (String)this.mytable.get("inputFilePath");
                SVGTFileChooser svgChooser = new SVGTFileChooser(this.frame, "Add");
                if (inputFilePath == null) {
                    inputFilePath = this.myLocaliser.getText("CurrentDirectory");
                }
                svgChooser.setMyCurrentDirectory(new File(inputFilePath));
                svgChooser.setLocation(this.frame.getLocation().x + 50, this.frame.getLocation().y + 50);
                svgChooser.showCustomFileChooser();
                ServiceRegistry.registerService(svgChooser);
                File[] file = svgChooser.getSelectedSVGFiles();
                if (file == null) {
                    return;
                }
                int[] filelength = new int[file.length];
                this.vector = new Vector();
                int i = 0;
                while (i < file.length) {
                    this.vector.add(file[i].getAbsolutePath());
                    filelength[i] = i;
                    ++i;
                }
                this.vector1 = new Vector();
                if (!svgChooser.isCanceled()) {
                    if (svgChooser.isAddOrAddWithWildCards()) {
                        this.inputSVGFilesList.setListData(this.vector);
                        this.inputSVGFilesList.setSelectedIndices(filelength);
                    } else {
                        String charseq = svgChooser.getMyCharSeq();
                        this.vector1.add(charseq);
                        this.inputSVGFilesList.setListData(this.vector1);
                        this.inputSVGFilesList.setSelectedIndex(0);
                    }
                }
                inputFilePath = svgChooser.getMyCurrentDirectory().getAbsolutePath();
                this.mytable.put("inputFilePath", inputFilePath);
            } else if (e.getSource().equals(this.outputDirButton)) {
                String outputFilePath = (String)this.mytable.get("OutDir");
                if (outputFilePath == null) {
                    outputFilePath = this.myLocaliser.getText("DefaultOutputDirectory");
                }
                JFileChooser chooser = new JFileChooser(new File(outputFilePath));
                chooser.setFileSelectionMode(2);
                chooser.setFileFilter(new MyFilter(null));
                int approved = chooser.showOpenDialog((Component)e.getSource());
                if (approved == 0) {
                    this.outputDirTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                    this.mytable.put("OutDir", chooser.getSelectedFile().getAbsolutePath());
                }
            } else if (e.getSource().equals(this.passThroughButton)) {
                String passThroughFilePath = (String)this.mytable.get("PassThroughFileName");
                if (passThroughFilePath == null) {
                    passThroughFilePath = this.myLocaliser.getText("DefaultPassThroughFile");
                }
                File fileE = new File(passThroughFilePath);
                System.out.println("file " + fileE.getAbsolutePath());
                try {
                    JFileChooser chooser = new JFileChooser(new File(fileE.getCanonicalPath()));
                    MyFileFilter filter = new MyFileFilter("*.xml");
                    FileFilter fil = chooser.getFileFilter();
                    chooser.setCurrentDirectory(new File(fileE.getCanonicalPath()));
                    chooser.removeChoosableFileFilter(fil);
                    chooser.addChoosableFileFilter(filter);
                    chooser.setFileSelectionMode(0);
                    int approved = chooser.showOpenDialog(this);
                    if (approved != 0) break block21;
                    if (this.checkForValidatePassThrough(chooser.getSelectedFile().getAbsolutePath())) {
                        this.passThroughTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                        passThroughFilePath = chooser.getSelectedFile().getAbsolutePath();
                        this.mytable.put("PassThroughFileName", passThroughFilePath);
                        this.mytable.put("criticlesize", "10");
                        break block21;
                    }
                    JOptionPane.showMessageDialog(this.passThroughButton, "Invalid PassThrough File");
                    this.passThroughTextField.setText(" ");
                }
                catch (Exception ek) {
                    System.out.println("Theeeeeeeeeeee");
                }
            } else if (e.getSource().equals(this.convertButton)) {
                this.myMainVeiw.clearTextArea();
                new PerformLater();
            } else if (e.getSource().equals(this.resetButton)) {
                this.reset();
            }
        }
    }

    public void actionPerformedAfter() {
        this.setCursor(new Cursor(3));
        this.covertion();
        this.setCursor(new Cursor(0));
    }

    public boolean checkForValidatePassThrough(String string) {
        try {
            Document document = XMLFileParser.parseFile(string, true);
            Element element = document.getDocumentElement();
            if (element.getNodeName().equals("passThrough")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void reset() {
        this.outputDirTextField.setText("");
        this.passThroughTextField.setText("");
        this.criticleFSTextField.setText("");
    }

    public void covertion() {
        String passthroughfile;
        boolean valid;
        String outDir;
        String size;
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        ArrayList<String> svgList = new ArrayList<String>();
        Object[] listofSVGs = this.inputSVGFilesList.getSelectedValues();
        if (listofSVGs != null) {
            String checkWhetherValid = null;
            checkWhetherValid = (String)listofSVGs[0];
            if (-1 != checkWhetherValid.indexOf("*") || -1 != checkWhetherValid.indexOf("?")) {
                SVGTFileChooser chooser = (SVGTFileChooser)ServiceRegistry.getService("com.nokia.svg2svgt.gui.SVGTFileChooser");
                chooser.getConvertionFiles();
                File[] files = chooser.getSelectedSVGFiles();
                int i = 0;
                while (i < files.length) {
                    svgList.add(i, files[i].getAbsolutePath());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < listofSVGs.length) {
                    svgList.add(i, (String)listofSVGs[i]);
                    ++i;
                }
            }
        }
        if ((size = this.criticleFSTextField.getText()) == null || size.equals("")) {
            size = "1000";
        }
        if ((outDir = this.outputDirTextField.getText()) == null || outDir.equals("")) {
            outDir = this.myLocaliser.getText("DefaultOutputDirectory");
        }
        if (!(valid = this.checkForValidatePassThrough(passthroughfile = this.passThroughTextField.getText()))) {
            JOptionPane.showMessageDialog(this.frame, "Invalid PassThrough File. Taking the default pass through file. ");
            passthroughfile = this.myLocaliser.getText("DefaultPassThroughFile");
        }
        params.put("-svgfile", svgList);
        params.put("-o", outDir);
        params.put("-p", passthroughfile);
        params.put("CriticalFileSize", size);
        params.put("-convfile", this.myLocaliser.getText("ConversionPropertiesFile"));
        this.myController.doConvert(params);
        int size1 = svgList.size();
        JOptionPane.showMessageDialog(this.convertButton, String.valueOf(size1) + " file(s) converted successfully");
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public void caretUpdate(CaretEvent e) {
        this.setModified(true);
    }

    public Hashtable getConfigHashTable() {
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("OutDir", this.outputDirTextField.getText());
        config.put("PassThroughFileName", this.passThroughTextField.getText());
        config.put("CriticalFileSize", this.criticleFSTextField.getText());
        return config;
    }

    public void setConfigHashTable(Hashtable config) {
        String[] fields = new String[]{"OutDir", "PassThroughFileName"};
        this.outputDirTextField.setText((String)config.get(fields[0]));
        File file = new File((String)config.get(fields[1]));
        this.passThroughTextField.setText(file.getAbsolutePath());
        this.criticleFSTextField.setText((String)config.get("CriticalFileSize"));
    }

    public boolean isFieldsEmpty() {
        return !(!this.outputDirTextField.getText().equals(null) && this.outputDirTextField.getText().trim().length() != 0 || !this.passThroughTextField.getText().equals(null) && this.passThroughTextField.getText().trim().length() != 0 || !this.criticleFSTextField.getText().equals(null) && this.criticleFSTextField.getText().trim().length() != 0);
    }

    public void setTable(Hashtable table) {
        this.mytable = table;
    }

    public Hashtable getTable() {
        return this.mytable;
    }

    class PerformLater
    extends Thread {
        public PerformLater() {
            this.start();
        }

        public void run() {
            ConfigPanel.this.actionPerformedAfter();
        }
    }

    private class MyFilter
    extends FileFilter {
        private String myFilteringCriteria = null;

        public MyFilter(String filter) {
            this.myFilteringCriteria = filter;
        }

        public boolean accept(File fileName) {
            return fileName.isDirectory();
        }

        public String getDescription() {
            return this.myFilteringCriteria;
        }
    }

    private class MyFileFilter
    extends FileFilter {
        private String myFilteringCriteria = null;

        public MyFileFilter(String filter) {
            this.myFilteringCriteria = filter;
        }

        public boolean accept(File fileName) {
            if (fileName.isDirectory()) {
                return true;
            }
            return WCMatcher.match(this.myFilteringCriteria, fileName.getName());
        }

        public String getDescription() {
            return this.myFilteringCriteria;
        }
    }
}

