/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.SVG2SVGTConverterApplication;
import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.converter.NameSpaceAnalyzer;
import com.nokia.svg2svgt.gui.ConFigButton;
import com.nokia.svg2svgt.gui.ConfigPanel;
import com.nokia.svg2svgt.gui.ConvertDialog;
import com.nokia.svg2svgt.gui.PassThroughPanel;
import com.nokia.svg2svgt.gui.SVGPassThroughFileStorer;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.help.HelpMediator;
import com.nokia.svg2svgt.localiser.Localiser;
import com.nokia.svg2svgt.util.WCMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class SVG2SVGTMainView
extends JFrame
implements ActionListener,
WindowListener,
ConFigButton {
    private SVGTConverterController myController = null;
    private JMenuBar menuBar;
    private JMenu file;
    private JMenuItem newOption;
    private JMenuItem openOtion;
    private JMenuItem configOitem;
    private JMenuItem passThroughOpenitem;
    private JMenuItem saveitem;
    private JMenuItem saveasitem;
    private JMenuItem exititem;
    private JMenuItem convertitem;
    private JMenuItem contentitem;
    private JMenuItem aboutitem;
    private JMenuItem item;
    private JMenu tools;
    private JMenu help;
    private JSplitPane pane1;
    private JTable commonList;
    private JList list;
    private JScrollPane left;
    private JPanel panel;
    private JScrollPane right;
    private JTextArea logWindow;
    private JSplitPane top;
    private JScrollPane bottom;
    private final String configState = "CONFIG_PANEL";
    private final String passThroughtState = "PASSTHROUGH_PANEL";
    private String state = "CONFIG_PANEL";
    private Hashtable lastSettingsTable = new Hashtable();
    private String openpathc_key = "configopenpath";
    private String openpathp_key = "passThroughopenpath";
    private String saveas_key = "saveaspath";
    private String path = null;
    private String lastsettingspath = null;
    private Localiser myLocaliser = null;
    private ConfigPanel configpanel;
    private NameSpaceAnalyzer myAnaliser = null;
    private ArrayList myDefaultNameSpaceList = null;
    private boolean empty = false;
    PassThroughPanel passThroughpanel = null;
    String savepath;
    private Vector listVector = null;
    boolean firstTime = true;

    public SVG2SVGTMainView(SVGTConverterController parent, Localiser localiser) {
        super(localiser.getText("ConvertUI.Title"));
        this.myController = parent;
        this.myLocaliser = localiser;
        this.path = this.myLocaliser.getText("CurrentDirectory");
        this.lastsettingspath = this.myLocaliser.getText("FilesettingsPath");
        this.configpanel = new ConfigPanel(this.myController, this.myLocaliser, this, this, this);
        try {
            this.myAnaliser = new NameSpaceAnalyzer(this.myLocaliser.getText("DefaultPassThroughFile"), null);
            ConfigurationManager manager = new ConfigurationManager(this.lastsettingspath);
            Configuration config = manager.getConfiguration();
            this.lastSettingsTable = config.toHash();
            this.configpanel.setTable(config.toHash());
            this.configpanel.setConfigHashTable(config.toHash());
            this.passThroughpanel = new PassThroughPanel(this.myController, this.myLocaliser, this);
            this.passThroughpanel.setMyNameSpaces(this.myAnaliser.getNSInPassThrough());
            this.myDefaultNameSpaceList = this.myAnaliser.getNSInPassThrough();
        }
        catch (Exception manager) {
            // empty catch block
        }
        this.panel = this.configpanel;
        this.addWindowListener(this);
        this.buildUI(this.configpanel);
        HelpMediator mediator = SVG2SVGTConverterApplication.getHelpMediator();
        if (mediator != null) {
            mediator.registerComponent(this.configpanel, "CONFIG_VIEW");
            mediator.registerComponent(this.passThroughpanel, "PSSTHROUGH_VIEW");
        }
    }

    public void buildUI(ConfigPanel configPanel) {
        this.menuBar = new JMenuBar();
        HelpMediator mediator = SVG2SVGTConverterApplication.getHelpMediator();
        this.file = new JMenu(this.myLocaliser.getText("JMenu.File"));
        this.file.setMnemonic(70);
        this.newOption = new JMenuItem(this.myLocaliser.getText("JMenu.File.new"));
        this.file.add(this.newOption);
        this.newOption.setMnemonic(78);
        this.newOption.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newOption.addActionListener(this);
        this.openOtion = new JMenuItem(this.myLocaliser.getText("JMenu.File.open"));
        this.file.add(this.openOtion);
        this.openOtion.setMnemonic(79);
        this.openOtion.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openOtion.addActionListener(this);
        this.file.addSeparator();
        this.configOitem = new JMenuItem(this.myLocaliser.getText("JMenu.File.open.Configuration"));
        this.file.add(this.configOitem);
        this.configOitem.addActionListener(this);
        this.configOitem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.passThroughOpenitem = new JMenuItem(this.myLocaliser.getText("JMenu.File.open.passThrough"));
        this.file.add(this.passThroughOpenitem);
        this.passThroughOpenitem.addActionListener(this);
        this.passThroughOpenitem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.file.addSeparator();
        this.saveitem = new JMenuItem(this.myLocaliser.getText("JMenu.File.save"));
        this.file.add(this.saveitem);
        this.saveitem.setEnabled(false);
        this.saveitem.setMnemonic(83);
        this.saveitem.addActionListener(this);
        this.saveitem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveasitem = new JMenuItem(this.myLocaliser.getText("JMenu.File.saveas"));
        this.file.add(this.saveasitem);
        this.saveasitem.setMnemonic(83);
        this.saveasitem.addActionListener(this);
        this.saveasitem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.file.addSeparator();
        this.exititem = new JMenuItem(this.myLocaliser.getText("JMenu.File.exit"));
        this.file.add(this.exititem);
        this.exititem.setMnemonic(88);
        this.exititem.addActionListener(this);
        this.menuBar.add(this.file);
        this.tools = new JMenu(this.myLocaliser.getText("JMenu.tools"));
        this.convertitem = new JMenuItem(this.myLocaliser.getText("JMenu.tools.converter"));
        this.tools.add(this.convertitem);
        this.tools.setMnemonic(84);
        this.convertitem.setEnabled(false);
        this.convertitem.addActionListener(this);
        this.menuBar.add(this.tools);
        this.help = new JMenu(this.myLocaliser.getText("JMenu.help"));
        this.help.setMnemonic(72);
        this.contentitem = new JMenuItem(this.myLocaliser.getText("JMenu.help.contents"));
        this.help.add(this.contentitem);
        this.contentitem.addActionListener(this);
        this.aboutitem = new JMenuItem(this.myLocaliser.getText("JMenu.help.about"));
        this.help.add(this.aboutitem);
        this.aboutitem.setMnemonic(112);
        this.aboutitem.addActionListener(this);
        this.menuBar.add(this.help);
        this.setJMenuBar(this.menuBar);
        this.list = new JList();
        this.left = new JScrollPane(this.list);
        this.right = new JScrollPane(this.panel);
        this.top = new JSplitPane(1, this.left, this.right);
        this.top.setDividerLocation(140);
        this.logWindow = new JTextArea();
        this.logWindow.setEditable(false);
        this.logWindow.setLineWrap(true);
        this.bottom = new JScrollPane(this.logWindow);
        this.pane1 = new JSplitPane(0, this.top, this.bottom);
        this.pane1.setDividerLocation(310);
        this.getContentPane().add((Component)this.pane1, "Center");
        try {
            File file = new File(this.path);
            String[] fileList = file.list(new ListFileFilter("*.cfg"));
            this.list.setListData(fileList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.list.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204), 5));
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SVG2SVGTMainView.this.saveitem.setEnabled(true);
                    String str = SVG2SVGTMainView.this.path;
                    str = String.valueOf(str) + "\\";
                    str = String.valueOf(str) + (String)SVG2SVGTMainView.this.list.getSelectedValue();
                    SVG2SVGTMainView.this.setTitle(String.valueOf(SVG2SVGTMainView.this.myLocaliser.getText("ConvertUI.Title")) + "-" + (String)SVG2SVGTMainView.this.list.getSelectedValue());
                    SVG2SVGTMainView.this.savepath = str;
                    if (str.endsWith(".cfg")) {
                        Hashtable config = SVG2SVGTMainView.this.getFromfile(str);
                        SVG2SVGTMainView.this.configpanel.setConfigHashTable(config);
                    } else if (str.endsWith(".xml")) {
                        try {
                            NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(str, null);
                            SVG2SVGTMainView.this.passThroughpanel.setMyNameSpaces(analiser.getNSInPassThrough());
                            SVG2SVGTMainView.this.passThroughpanel.populateTable();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    SVG2SVGTMainView.this.saveitem.setEnabled(false);
                }
            }
        });
        this.configOitem.setEnabled(false);
        if (mediator != null) {
            mediator.registerComponent(this.menuBar, "MENU_BAR");
            mediator.registerComponent(this.list, "JLIST");
            mediator.registerComponent(this.logWindow, "MESSAGE_WINDOW");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.newOption)) {
            if (this.state == "CONFIG_PANEL") {
                this.newConfiguration();
            } else {
                this.newpassThroughfile();
            }
        } else if (e.getSource().equals(this.openOtion)) {
            if (this.state == "CONFIG_PANEL") {
                this.openConfiguration();
            } else {
                this.openPassThroughFile();
            }
        } else if (e.getSource().equals(this.configOitem)) {
            int YesNo22;
            this.passThroughOpenitem.setEnabled(true);
            this.configOitem.setEnabled(false);
            if (this.passThroughpanel.isChanged() && (YesNo22 = JOptionPane.showConfirmDialog(this.configpanel, "Save passthrough?", "Save", 0)) == 0) {
                this.saveas();
            }
            try {
                this.populateList("CONFIG_PANEL");
                this.top.remove(this.top.getRightComponent());
                this.right = new JScrollPane(this.panel);
                this.top.setRightComponent(this.right);
                this.top.setDividerLocation(140);
                this.getContentPane().validate();
                this.getContentPane().repaint();
                this.state = "CONFIG_PANEL";
            }
            catch (NullPointerException YesNo22) {}
        } else if (e.getSource().equals(this.passThroughOpenitem)) {
            int YesNo32;
            this.configOitem.setEnabled(true);
            this.passThroughOpenitem.setEnabled(false);
            if (this.configpanel.isModified() && !this.configpanel.isFieldsEmpty() && (YesNo32 = JOptionPane.showConfirmDialog(this.configpanel, "Save configuration?", "Save", 0)) == 0) {
                this.saveas();
            }
            try {
                if (this.firstTime) {
                    this.passThroughpanel.populateTable(this.myDefaultNameSpaceList);
                    this.firstTime = false;
                }
                this.populateList("PASSTHROUGH_PANEL");
                this.top.remove(this.top.getRightComponent());
                this.right = new JScrollPane(this.passThroughpanel);
                this.top.setRightComponent(this.right);
                this.top.setDividerLocation(140);
                this.getContentPane().validate();
                this.getContentPane().repaint();
                this.state = "PASSTHROUGH_PANEL";
            }
            catch (NullPointerException YesNo32) {}
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.File.save"))) {
            this.save();
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.File.saveas"))) {
            this.saveas();
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.File.exit"))) {
            this.settings();
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.tools.converter"))) {
            this.configpanel.covertion();
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.help.contents"))) {
            HelpMediator mediator = SVG2SVGTConverterApplication.getHelpMediator();
            if (mediator != null) {
                mediator.invokeHelp("introduction");
            }
        } else if (e.getActionCommand().equals(this.myLocaliser.getText("JMenu.help.about"))) {
            this.showDialog();
        }
    }

    private void settings() {
        int j = JOptionPane.showConfirmDialog(this, "Exit application?", "Exit", 0);
        if (j == 0) {
            try {
                Hashtable settings = this.configpanel.getTable();
                settings.put(this.openpathc_key, this.lastSettingsTable.get(this.openpathc_key));
                settings.put(this.openpathp_key, this.lastSettingsTable.get(this.openpathp_key));
                settings.put(this.saveas_key, this.lastSettingsTable.get(this.saveas_key));
                Configuration configClass = new Configuration(settings);
                ConfigurationManager configManager = new ConfigurationManager(this.lastsettingspath);
                configManager.setConfiguration(configClass);
            }
            catch (NullPointerException ne) {
                System.out.println("Unable to open the file");
            }
            this.dispose();
        }
    }

    public void newConfiguration() {
        this.saveitem.setEnabled(false);
        this.configpanel.reset();
        this.populateList("CONFIG_PANEL");
        this.setTitle(String.valueOf(this.myLocaliser.getText("ConvertUI.Title")) + "-" + "New Configuration");
    }

    public void newpassThroughfile() {
        this.saveitem.setEnabled(false);
        try {
            NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(this.myLocaliser.getText("DefaultPassThroughFile"), null);
            this.passThroughpanel.setMyNameSpaces(analiser.getNSInPassThrough());
            this.passThroughpanel.populateTable();
            this.populateList("PASSTHROUGH_PANEL");
            this.setTitle(String.valueOf(this.myLocaliser.getText("ConvertUI.Title")) + "-" + "Default PassThrough File");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openConfiguration() {
        JFileChooser chooser = new JFileChooser();
        if ((String)this.lastSettingsTable.get(this.openpathc_key) == null) {
            chooser.setCurrentDirectory(new File(this.myLocaliser.getText("CurrentDirectory")));
        } else {
            chooser.setCurrentDirectory(new File((String)this.lastSettingsTable.get(this.openpathc_key)));
        }
        MyFileFilter filter = new MyFileFilter("*.cfg");
        FileFilter fil = chooser.getFileFilter();
        chooser.removeChoosableFileFilter(fil);
        chooser.addChoosableFileFilter(filter);
        int approved = chooser.showDialog(this.item, "Open");
        if (approved == 0) {
            try {
                String f = chooser.getSelectedFile().getAbsolutePath();
                Hashtable config = this.getFromfile(f);
                this.configpanel.setConfigHashTable(config);
                this.saveitem.setEnabled(true);
                this.populateList("CONFIG_PANEL");
                this.setTitle(String.valueOf(this.myLocaliser.getText("ConvertUI.Title")) + "-" + chooser.getSelectedFile().getName());
                String openPath = chooser.getCurrentDirectory().getAbsolutePath();
                this.savepath = chooser.getSelectedFile().getAbsolutePath();
                this.lastSettingsTable.put(this.openpathc_key, openPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void openPassThroughFile() {
        JFileChooser chooser = new JFileChooser();
        if ((String)this.lastSettingsTable.get(this.openpathp_key) == null) {
            chooser.setCurrentDirectory(new File(this.myLocaliser.getText("CurrentDirectory")));
        } else {
            chooser.setCurrentDirectory(new File((String)this.lastSettingsTable.get(this.openpathp_key)));
        }
        MyFileFilter filter = new MyFileFilter("*.xml");
        FileFilter fil = chooser.getFileFilter();
        chooser.removeChoosableFileFilter(fil);
        chooser.addChoosableFileFilter(filter);
        int approved = chooser.showDialog(this.item, "Open");
        if (approved == 0) {
            try {
                File f = chooser.getSelectedFile();
                if (f != null) {
                    this.saveitem.setEnabled(true);
                    this.populateList("PASSTHROUGH_PANEL");
                    if (!this.configpanel.checkForValidatePassThrough(chooser.getSelectedFile().getAbsolutePath())) {
                        JOptionPane.showMessageDialog(this, "Invalid passthrough file.");
                    } else {
                        this.setTitle(String.valueOf(this.myLocaliser.getText("ConvertUI.Title")) + "-" + chooser.getSelectedFile().getName());
                        NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(f.getAbsolutePath(), null);
                        this.passThroughpanel.setMyNameSpaces(analiser.getNSInPassThrough());
                        this.passThroughpanel.populateTable();
                    }
                    String openPath = chooser.getCurrentDirectory().getAbsolutePath();
                    this.savepath = chooser.getSelectedFile().getAbsolutePath();
                    this.lastSettingsTable.put(this.openpathp_key, openPath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        if (this.state.equals("CONFIG_PANEL")) {
            Hashtable config = this.configpanel.getConfigHashTable();
            this.putTofile(this.savepath, config);
        } else {
            System.out.println(" savePath " + this.savepath);
            SVGPassThroughFileStorer sVGPassThroughFileStorer = new SVGPassThroughFileStorer(this.passThroughpanel.addDialog.getMyNameSpaces(), this.savepath, this.myLocaliser, true, this);
        }
    }

    public void saveas() {
        this.saveitem.setEnabled(false);
        JFileChooser chooser = new JFileChooser();
        if ((String)this.lastSettingsTable.get(this.saveas_key) == null) {
            chooser.setCurrentDirectory(new File(this.myLocaliser.getText("CurrentDirectory")));
        } else {
            chooser.setCurrentDirectory(new File((String)this.lastSettingsTable.get(this.saveas_key)));
        }
        if (this.state.equals("PASSTHROUGH_PANEL")) {
            MyFileFilter filter = new MyFileFilter("*.xml");
            FileFilter fil = chooser.getFileFilter();
            chooser.removeChoosableFileFilter(fil);
            chooser.addChoosableFileFilter(filter);
            int approved = chooser.showSaveDialog(this.item);
            if (approved == 0) {
                File f = chooser.getSelectedFile();
                SVGPassThroughFileStorer savetoXML = new SVGPassThroughFileStorer(this.passThroughpanel.getMyNameSpaces(), f.getAbsolutePath(), this.myLocaliser, false, this);
                this.passThroughpanel.setChanged(false);
            }
            this.lastSettingsTable.put(this.saveas_key, chooser.getCurrentDirectory().getAbsolutePath());
            chooser.removeChoosableFileFilter(filter);
            chooser.addChoosableFileFilter(fil);
            this.populateList("PASSTHROUGH_PANEL");
        } else {
            MyFileFilter filter = new MyFileFilter("*.cfg");
            FileFilter fil = chooser.getFileFilter();
            chooser.removeChoosableFileFilter(fil);
            chooser.addChoosableFileFilter(filter);
            int approved = chooser.showSaveDialog(this.item);
            if (approved == 0) {
                String f = chooser.getSelectedFile().getAbsolutePath();
                System.out.println(f);
                if (-1 == f.indexOf(".cfg")) {
                    f = String.valueOf(f) + ".cfg";
                }
                System.out.println(f);
                ConfigurationManager manager = new ConfigurationManager(f);
                Hashtable config = this.configpanel.getConfigHashTable();
                Configuration config1 = new Configuration(config);
                manager.setConfiguration(config1);
                this.lastSettingsTable.put(this.saveas_key, chooser.getCurrentDirectory().getAbsolutePath());
                this.configpanel.setModified(false);
            }
            chooser.removeChoosableFileFilter(filter);
            chooser.addChoosableFileFilter(fil);
            this.populateList("CONFIG_PANEL");
        }
    }

    private void populateList(String state1) {
        if (state1 != "PASSTHROUGH_PANEL") {
            try {
                File file = new File(this.path);
                String[] fileList = file.list(new ListFileFilter("*.cfg"));
                this.list.setListData(fileList);
            }
            catch (Exception file) {}
        } else {
            try {
                File file = new File(this.path);
                File[] fileList = file.listFiles(new ListFileFilter("*.xml"));
                Vector<String> listVec = new Vector<String>();
                int i = 0;
                while (i < fileList.length) {
                    boolean validOrInvalid = this.configpanel.checkForValidatePassThrough(fileList[i].getAbsolutePath());
                    if (validOrInvalid) {
                        listVec.add(fileList[i].getName());
                    }
                    ++i;
                }
                this.list.setListData(listVec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showDialog() {
        ConvertDialog dialog = new ConvertDialog((Frame)this, this.myLocaliser);
        dialog.setTitle(this.myLocaliser.getText("JMenu.help.about"));
        dialog.setSize(357, 207);
        dialog.setVisible(true);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setLocation(this.getLocation().x + 150, this.getLocation().y + 150);
    }

    private void putTofile(String savepath, Hashtable config) {
        Configuration configClass = new Configuration(config);
        ConfigurationManager configManager = new ConfigurationManager(savepath);
        configManager.setConfiguration(configClass);
    }

    public void clearTextArea() {
        this.logWindow.setText("");
    }

    private Hashtable getFromfile(String openpath) {
        ConfigurationManager manager = new ConfigurationManager(openpath);
        Configuration config = manager.getConfiguration();
        return config.toHash();
    }

    public void log(String desc) {
        if (this.logWindow != null) {
            this.logWindow.append(desc);
            this.logWindow.append(" \n ");
        }
    }

    public void setIfListisEmty(boolean empty) {
        this.empty = empty;
        if (empty) {
            this.convertitem.setEnabled(false);
        } else {
            this.convertitem.setEnabled(true);
        }
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.settings();
        this.setDefaultCloseOperation(0);
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    private static class ListFileFilter
    implements FilenameFilter {
        private String myFilteringCriteria = null;

        public ListFileFilter(String filter) {
            this.myFilteringCriteria = filter;
        }

        public boolean accept(File dir, String name) {
            File temp = new File(name);
            return WCMatcher.match(this.myFilteringCriteria, name);
        }
    }

    private class MyFileFilter
    extends FileFilter {
        private String myFilteringCriteria = null;

        public MyFileFilter(String filter) {
            this.myFilteringCriteria = filter;
        }

        public boolean accept(File fileName) {
            if (fileName.isDirectory()) {
                return true;
            }
            return WCMatcher.match(this.myFilteringCriteria, fileName.getName());
        }

        public String getDescription() {
            return this.myFilteringCriteria;
        }
    }
}

