/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.SVG2SVGTConstants;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.converter.SVG2SVGTConverter;
import com.nokia.svg2svgt.gui.SVGTConverterModel;
import com.nokia.svg2svgt.gui.SVGTConverterView;
import com.nokia.svg2svgt.localiser.Localiser;
import com.nokia.svg2svgt.log.LogListener;
import com.nokia.svg2svgt.log.LogWriter;
import java.util.Hashtable;

public class SVGTConverterController
implements LogListener {
    private SVGTConverterView myView;
    private SVGTConverterModel myModel;
    private ConfigurationManager myConfigMgr;
    private Hashtable myCmdLineParams;
    private LogWriter myLogWriter;
    private SVG2SVGTConverter myConverter;
    private String myModeOfOperation;

    public SVGTConverterController(String modeOfOperation, LogWriter logger) {
        this(null, modeOfOperation, logger);
    }

    public SVGTConverterController(Hashtable cmdLineParams, String modeOfOperation, LogWriter logger) {
        this.myLogWriter = logger;
        this.myModeOfOperation = modeOfOperation;
        this.myCmdLineParams = cmdLineParams;
        if (modeOfOperation.equalsIgnoreCase("GUI")) {
            String region = "GB";
            Localiser localiser = null;
            if (region != null) {
                try {
                    localiser = !this.isRegionSupported(region) ? new Localiser("GB") : new Localiser(region);
                }
                catch (Exception ex) {
                    localiser = null;
                }
            }
            this.myView = new SVGTConverterView(this, localiser);
            this.myModel = new SVGTConverterModel();
            this.myView.setModel(this.myModel);
        } else {
            this.doConvert(this.myCmdLineParams);
        }
    }

    private boolean isRegionSupported(String region) {
        boolean isSupported = false;
        int i = 0;
        while (i < SVG2SVGTConstants.SUPPORTED_REGIONS.length) {
            if (region.equalsIgnoreCase(SVG2SVGTConstants.SUPPORTED_REGIONS[i])) {
                isSupported = true;
                break;
            }
            ++i;
        }
        return isSupported;
    }

    public void doConvert(Hashtable confParams) {
        this.myConverter = new SVG2SVGTConverter(confParams);
        this.myConverter.registerLogListener(this);
        this.myConverter.convert();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.myConfigMgr;
    }

    public void log(String desc) {
        this.myLogWriter.log(this.myModeOfOperation, desc);
        if ("GUI".equals(this.myModeOfOperation)) {
            this.myView.log(desc);
        }
    }

    public void logWarning(String desc) {
        this.myLogWriter.log(this.myModeOfOperation, desc);
    }
}

