/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui.ext;

import com.nokia.svg2svgt.gui.ext.MultiSelectionPopup;
import com.nokia.svg2svgt.gui.ext.event.SelectionEvent;
import com.nokia.svg2svgt.gui.ext.event.SelectionListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;

public class JMultiSelectionComboBox
extends JComponent {
    private String delimiter = ":";
    private JTextField textField;
    private BasicArrowButton arrowButton;
    private MultiSelectionPopup popup;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public JMultiSelectionComboBox() {
        this.installUI();
    }

    public JMultiSelectionComboBox(Object[] data) {
        this.installUI();
        this.popup.setData(data);
    }

    public JMultiSelectionComboBox(Vector v) {
        this.installUI();
        this.popup.setData(v);
    }

    private void installUI() {
        this.setLayout(new BoxLayout(this, 0){

            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (parent instanceof JMultiSelectionComboBox) {
                    JMultiSelectionComboBox cb = (JMultiSelectionComboBox)parent;
                    int width = cb.getWidth();
                    int height = cb.getHeight();
                    Insets insets = JMultiSelectionComboBox.this.getInsets();
                    int buttonSize = height - (insets.top + insets.bottom);
                    if (JMultiSelectionComboBox.this.arrowButton != null) {
                        JMultiSelectionComboBox.this.arrowButton.setBounds(width - buttonSize - insets.right, insets.top, buttonSize, buttonSize);
                    }
                    if (JMultiSelectionComboBox.this.textField != null) {
                        JMultiSelectionComboBox.this.textField.setBounds(insets.left, insets.top, width - buttonSize - insets.right - insets.left, buttonSize);
                    }
                }
            }
        });
        this.createTextBox();
        this.createArrowButton();
        this.createPopup();
        this.add(this.textField);
        this.add(this.arrowButton);
        this.configureArrowButton();
        this.configureTextBox();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setRequestFocusEnabled(true);
    }

    private void createTextBox() {
        this.textField = new JTextField(500);
        this.textField.setEditable(true);
        this.textField.setBackground(Color.white);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (JMultiSelectionComboBox.this.popup != null && JMultiSelectionComboBox.this.textField.isEditable()) {
                    JMultiSelectionComboBox.this.popup.clearSelection();
                }
            }
        });
    }

    private void createArrowButton() {
        this.arrowButton = new BasicArrowButton(5);
    }

    private void createPopup() {
        this.popup = new MultiSelectionPopup(this);
    }

    private void configureArrowButton() {
        this.arrowButton.addMouseListener(this.popup.getMouseListener());
    }

    private void configureTextBox() {
        this.textField.addMouseListener(this.popup.getMouseListener());
    }

    protected void firePopupWillBecomeInvisible() {
        Object[] listeners = this.listenerList.getListeners(SelectionListener.class);
        SelectionEvent eventObj = null;
        int i = listeners.length - 1;
        while (i >= 0) {
            if (eventObj == null) {
                eventObj = new SelectionEvent(this);
            }
            ((SelectionListener)listeners[i]).selectionOver(eventObj);
            --i;
        }
    }

    protected void firePopupWillBecomeVisible() {
    }

    protected void firePopupSelectionChanging() {
        Object[] listeners = this.listenerList.getListeners(SelectionListener.class);
        SelectionEvent eventObj = null;
        int i = listeners.length - 1;
        while (i >= 0) {
            if (eventObj == null) {
                eventObj = new SelectionEvent(this);
            }
            ((SelectionListener)listeners[i]).selectionChanged(eventObj);
            --i;
        }
    }

    void setText(String text) {
        this.textField.setEditable(false);
        this.textField.setText(text);
        this.textField.setCaretPosition(0);
        this.textField.setEditable(true);
    }

    public void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void addItem(Object data) {
        this.popup.addItem(data);
    }

    public int getSelectedIndex() {
        return this.popup.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.popup.getSelectedIndices();
    }

    public Object getSelectedValue() {
        String newText;
        Object obj = this.popup.getSelectedValue();
        if (obj == null && (newText = this.textField.getText()) != null && newText.trim().length() > 0) {
            obj = newText;
        }
        return obj;
    }

    public Object[] getSelectedValues() {
        return this.popup.getSelectedValues();
    }

    public void removeAll() {
        this.textField.setText("");
        this.popup.removeAllElements();
    }

    public void setSelectedIndex(int index) {
        this.popup.selectIndex(index);
    }

    public void setSelectedItem(Object toBeSelected) {
        this.popup.selectItem(toBeSelected);
    }
}

