/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.log;

import com.nokia.svg2svgt.log.LogMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;

public class LogWriter {
    public boolean doLogging = true;
    private File mylogFile = null;

    public LogWriter(String region) {
        try {
            LogMessages.init(ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_LOG_FILE"), region);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            this.doLogging = false;
        }
        this.mylogFile = new File(ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_REPORT_FILE"));
    }

    public void disableLogging() {
        this.doLogging = false;
    }

    public void log(String mode, String desc) {
        if (mode.equalsIgnoreCase("BatchMode")) {
            this.writeToScreen(desc);
        }
        this.writeToFile(desc);
    }

    public void writeToScreen(String desc) {
        if (this.doLogging) {
            System.out.println(desc);
        }
    }

    public void writeToFile(String desc) {
        if (this.doLogging) {
            try {
                FileWriter writer = new FileWriter(this.mylogFile, true);
                writer.write(desc);
                writer.write("\n");
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

