/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLFileParser {
    private static DocumentBuilderFactory myDocBuilderF = null;
    private static DocumentBuilder myDocBuilder = null;
    private static boolean isInitialised = false;

    private static void init(boolean isValidating) throws FactoryConfigurationError, ParserConfigurationException {
        if (!isInitialised) {
            myDocBuilderF = DocumentBuilderFactory.newInstance();
            myDocBuilderF.setValidating(isValidating);
            myDocBuilderF.setIgnoringElementContentWhitespace(true);
            myDocBuilderF.setCoalescing(true);
            myDocBuilderF.setNamespaceAware(true);
            myDocBuilderF.setIgnoringComments(true);
            myDocBuilderF.setExpandEntityReferences(true);
            myDocBuilder = myDocBuilderF.newDocumentBuilder();
            myDocBuilder.setEntityResolver(new MyEntityResolver());
            isInitialised = true;
        }
    }

    public static Document parseFile(String fileName, boolean isValidating) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException, IllegalArgumentException {
        XMLFileParser.init(isValidating);
        if (fileName.indexOf("%") != -1) {
            fileName = fileName.replaceAll("%", "%25");
        }
        File inFile = new File(fileName);
        Document parsedDoc = myDocBuilder.parse(inFile);
        return parsedDoc;
    }

    public static Document getEmptyDocument() throws FactoryConfigurationError, ParserConfigurationException {
        XMLFileParser.init(false);
        return myDocBuilder.newDocument();
    }

    private static class MyEntityResolver
    implements EntityResolver {
        MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.toLowerCase().endsWith(".dtd")) {
                String fpath = ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_DTD_ENTITYRESOLVER");
                File f = new File(fpath);
                System.out.println(systemId);
                return new InputSource(new InputStreamReader((InputStream)new FileInputStream(fpath), "windows-1252"));
            }
            return null;
        }
    }
}

