/*
* Copyright (c) 2006-2010 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
/*
 * File Name ColourPalette.java Description File contains the definition for the
 * colour palette used in the phone.
 
 */

package com.nokia.tools.theme.s60.effects.imaging;

import java.awt.image.IndexColorModel;

public class ColourPalette {

	public static final IndexColorModel WEB_SAFE_PALETTE = createWebSafePalette();
	public static final IndexColorModel BITMAP_PALETTE = createBitmapPalette();

	/**
	 * Creates the web safe colour palette
	 */
	private static IndexColorModel createWebSafePalette() {

		byte red[] = new byte[256];
		byte green[] = new byte[256];
		byte blue[] = new byte[256];

		red[0] = (byte) 255;
		green[0] = (byte) 255;
		blue[0] = (byte) 255;
		red[1] = (byte) 255;
		green[1] = (byte) 255;
		blue[1] = (byte) 204;
		red[2] = (byte) 255;
		green[2] = (byte) 255;
		blue[2] = (byte) 153;
		red[3] = (byte) 255;
		green[3] = (byte) 255;
		blue[3] = (byte) 102;
		red[4] = (byte) 255;
		green[4] = (byte) 255;
		blue[4] = (byte) 51;
		red[5] = (byte) 255;
		green[5] = (byte) 255;
		blue[5] = (byte) 0;
		red[6] = (byte) 255;
		green[6] = (byte) 204;
		blue[6] = (byte) 255;
		red[7] = (byte) 255;
		green[7] = (byte) 204;
		blue[7] = (byte) 204;
		red[8] = (byte) 255;
		green[8] = (byte) 204;
		blue[8] = (byte) 153;
		red[9] = (byte) 255;
		green[9] = (byte) 204;
		blue[9] = (byte) 102;
		red[10] = (byte) 255;
		green[10] = (byte) 204;
		blue[10] = (byte) 51;
		red[11] = (byte) 255;
		green[11] = (byte) 204;
		blue[11] = (byte) 0;
		red[12] = (byte) 255;
		green[12] = (byte) 153;
		blue[12] = (byte) 255;
		red[13] = (byte) 255;
		green[13] = (byte) 153;
		blue[13] = (byte) 204;
		red[14] = (byte) 255;
		green[14] = (byte) 153;
		blue[14] = (byte) 153;
		red[15] = (byte) 255;
		green[15] = (byte) 153;
		blue[15] = (byte) 102;
		red[16] = (byte) 255;
		green[16] = (byte) 153;
		blue[16] = (byte) 51;
		red[17] = (byte) 255;
		green[17] = (byte) 153;
		blue[17] = (byte) 0;
		red[18] = (byte) 255;
		green[18] = (byte) 102;
		blue[18] = (byte) 255;
		red[19] = (byte) 255;
		green[19] = (byte) 102;
		blue[19] = (byte) 204;
		red[20] = (byte) 255;
		green[20] = (byte) 102;
		blue[20] = (byte) 153;
		red[21] = (byte) 255;
		green[21] = (byte) 102;
		blue[21] = (byte) 102;
		red[22] = (byte) 255;
		green[22] = (byte) 102;
		blue[22] = (byte) 51;
		red[23] = (byte) 255;
		green[23] = (byte) 102;
		blue[23] = (byte) 0;
		red[24] = (byte) 255;
		green[24] = (byte) 51;
		blue[24] = (byte) 255;
		red[25] = (byte) 255;
		green[25] = (byte) 51;
		blue[25] = (byte) 204;
		red[26] = (byte) 255;
		green[26] = (byte) 51;
		blue[26] = (byte) 153;
		red[27] = (byte) 255;
		green[27] = (byte) 51;
		blue[27] = (byte) 102;
		red[28] = (byte) 255;
		green[28] = (byte) 51;
		blue[28] = (byte) 51;
		red[29] = (byte) 255;
		green[29] = (byte) 51;
		blue[29] = (byte) 0;
		red[30] = (byte) 255;
		green[30] = (byte) 0;
		blue[30] = (byte) 255;
		red[31] = (byte) 255;
		green[31] = (byte) 0;
		blue[31] = (byte) 204;
		red[32] = (byte) 255;
		green[32] = (byte) 0;
		blue[32] = (byte) 153;
		red[33] = (byte) 255;
		green[33] = (byte) 0;
		blue[33] = (byte) 102;
		red[34] = (byte) 255;
		green[34] = (byte) 0;
		blue[34] = (byte) 51;
		red[35] = (byte) 255;
		green[35] = (byte) 0;
		blue[35] = (byte) 0;
		red[36] = (byte) 204;
		green[36] = (byte) 255;
		blue[36] = (byte) 255;
		red[37] = (byte) 204;
		green[37] = (byte) 255;
		blue[37] = (byte) 204;
		red[38] = (byte) 204;
		green[38] = (byte) 255;
		blue[38] = (byte) 153;
		red[39] = (byte) 204;
		green[39] = (byte) 255;
		blue[39] = (byte) 102;
		red[40] = (byte) 204;
		green[40] = (byte) 255;
		blue[40] = (byte) 51;
		red[41] = (byte) 204;
		green[41] = (byte) 255;
		blue[41] = (byte) 0;
		red[42] = (byte) 204;
		green[42] = (byte) 204;
		blue[42] = (byte) 255;
		red[43] = (byte) 204;
		green[43] = (byte) 204;
		blue[43] = (byte) 204;
		red[44] = (byte) 204;
		green[44] = (byte) 204;
		blue[44] = (byte) 153;
		red[45] = (byte) 204;
		green[45] = (byte) 204;
		blue[45] = (byte) 102;
		red[46] = (byte) 204;
		green[46] = (byte) 204;
		blue[46] = (byte) 51;
		red[47] = (byte) 204;
		green[47] = (byte) 204;
		blue[47] = (byte) 0;
		red[48] = (byte) 204;
		green[48] = (byte) 153;
		blue[48] = (byte) 255;
		red[49] = (byte) 204;
		green[49] = (byte) 153;
		blue[49] = (byte) 204;
		red[50] = (byte) 204;
		green[50] = (byte) 153;
		blue[50] = (byte) 153;
		red[51] = (byte) 204;
		green[51] = (byte) 153;
		blue[51] = (byte) 102;
		red[52] = (byte) 204;
		green[52] = (byte) 153;
		blue[52] = (byte) 51;
		red[53] = (byte) 204;
		green[53] = (byte) 153;
		blue[53] = (byte) 0;
		red[54] = (byte) 204;
		green[54] = (byte) 102;
		blue[54] = (byte) 255;
		red[55] = (byte) 204;
		green[55] = (byte) 102;
		blue[55] = (byte) 204;
		red[56] = (byte) 204;
		green[56] = (byte) 102;
		blue[56] = (byte) 153;
		red[57] = (byte) 204;
		green[57] = (byte) 102;
		blue[57] = (byte) 102;
		red[58] = (byte) 204;
		green[58] = (byte) 102;
		blue[58] = (byte) 51;
		red[59] = (byte) 204;
		green[59] = (byte) 102;
		blue[59] = (byte) 0;
		red[60] = (byte) 204;
		green[60] = (byte) 51;
		blue[60] = (byte) 255;
		red[61] = (byte) 204;
		green[61] = (byte) 51;
		blue[61] = (byte) 204;
		red[62] = (byte) 204;
		green[62] = (byte) 51;
		blue[62] = (byte) 153;
		red[63] = (byte) 204;
		green[63] = (byte) 51;
		blue[63] = (byte) 102;
		red[64] = (byte) 204;
		green[64] = (byte) 51;
		blue[64] = (byte) 51;
		red[65] = (byte) 204;
		green[65] = (byte) 51;
		blue[65] = (byte) 0;
		red[66] = (byte) 204;
		green[66] = (byte) 0;
		blue[66] = (byte) 255;
		red[67] = (byte) 204;
		green[67] = (byte) 0;
		blue[67] = (byte) 204;
		red[68] = (byte) 204;
		green[68] = (byte) 0;
		blue[68] = (byte) 153;
		red[69] = (byte) 204;
		green[69] = (byte) 0;
		blue[69] = (byte) 102;
		red[70] = (byte) 204;
		green[70] = (byte) 0;
		blue[70] = (byte) 51;
		red[71] = (byte) 204;
		green[71] = (byte) 0;
		blue[71] = (byte) 0;
		red[72] = (byte) 153;
		green[72] = (byte) 255;
		blue[72] = (byte) 255;
		red[73] = (byte) 153;
		green[73] = (byte) 255;
		blue[73] = (byte) 204;
		red[74] = (byte) 153;
		green[74] = (byte) 255;
		blue[74] = (byte) 153;
		red[75] = (byte) 153;
		green[75] = (byte) 255;
		blue[75] = (byte) 102;
		red[76] = (byte) 153;
		green[76] = (byte) 255;
		blue[76] = (byte) 51;
		red[77] = (byte) 153;
		green[77] = (byte) 255;
		blue[77] = (byte) 0;
		red[78] = (byte) 153;
		green[78] = (byte) 204;
		blue[78] = (byte) 255;
		red[79] = (byte) 153;
		green[79] = (byte) 204;
		blue[79] = (byte) 204;
		red[80] = (byte) 153;
		green[80] = (byte) 204;
		blue[80] = (byte) 153;
		red[81] = (byte) 153;
		green[81] = (byte) 204;
		blue[81] = (byte) 102;
		red[82] = (byte) 153;
		green[82] = (byte) 204;
		blue[82] = (byte) 51;
		red[83] = (byte) 153;
		green[83] = (byte) 204;
		blue[83] = (byte) 0;
		red[84] = (byte) 153;
		green[84] = (byte) 153;
		blue[84] = (byte) 255;
		red[85] = (byte) 153;
		green[85] = (byte) 153;
		blue[85] = (byte) 204;
		red[86] = (byte) 153;
		green[86] = (byte) 153;
		blue[86] = (byte) 153;
		red[87] = (byte) 153;
		green[87] = (byte) 153;
		blue[87] = (byte) 102;
		red[88] = (byte) 153;
		green[88] = (byte) 153;
		blue[88] = (byte) 51;
		red[89] = (byte) 153;
		green[89] = (byte) 153;
		blue[89] = (byte) 0;
		red[90] = (byte) 153;
		green[90] = (byte) 102;
		blue[90] = (byte) 255;
		red[91] = (byte) 153;
		green[91] = (byte) 102;
		blue[91] = (byte) 204;
		red[92] = (byte) 153;
		green[92] = (byte) 102;
		blue[92] = (byte) 153;
		red[93] = (byte) 153;
		green[93] = (byte) 102;
		blue[93] = (byte) 102;
		red[94] = (byte) 153;
		green[94] = (byte) 102;
		blue[94] = (byte) 51;
		red[95] = (byte) 153;
		green[95] = (byte) 102;
		blue[95] = (byte) 0;
		red[96] = (byte) 153;
		green[96] = (byte) 51;
		blue[96] = (byte) 255;
		red[97] = (byte) 153;
		green[97] = (byte) 51;
		blue[97] = (byte) 204;
		red[98] = (byte) 153;
		green[98] = (byte) 51;
		blue[98] = (byte) 153;
		red[99] = (byte) 153;
		green[99] = (byte) 51;
		blue[99] = (byte) 102;
		red[100] = (byte) 153;
		green[100] = (byte) 51;
		blue[100] = (byte) 51;
		red[101] = (byte) 153;
		green[101] = (byte) 51;
		blue[101] = (byte) 0;
		red[102] = (byte) 153;
		green[102] = (byte) 0;
		blue[102] = (byte) 255;
		red[103] = (byte) 153;
		green[103] = (byte) 0;
		blue[103] = (byte) 204;
		red[104] = (byte) 153;
		green[104] = (byte) 0;
		blue[104] = (byte) 153;
		red[105] = (byte) 153;
		green[105] = (byte) 0;
		blue[105] = (byte) 102;
		red[106] = (byte) 153;
		green[106] = (byte) 0;
		blue[106] = (byte) 51;
		red[107] = (byte) 153;
		green[107] = (byte) 0;
		blue[107] = (byte) 0;
		red[108] = (byte) 102;
		green[108] = (byte) 255;
		blue[108] = (byte) 255;
		red[109] = (byte) 102;
		green[109] = (byte) 255;
		blue[109] = (byte) 204;
		red[110] = (byte) 102;
		green[110] = (byte) 255;
		blue[110] = (byte) 153;
		red[111] = (byte) 102;
		green[111] = (byte) 255;
		blue[111] = (byte) 102;
		red[112] = (byte) 102;
		green[112] = (byte) 255;
		blue[112] = (byte) 53;
		red[113] = (byte) 102;
		green[113] = (byte) 255;
		blue[113] = (byte) 0;
		red[114] = (byte) 102;
		green[114] = (byte) 204;
		blue[114] = (byte) 255;
		red[115] = (byte) 102;
		green[115] = (byte) 204;
		blue[115] = (byte) 204;
		red[116] = (byte) 102;
		green[116] = (byte) 204;
		blue[116] = (byte) 153;
		red[117] = (byte) 102;
		green[117] = (byte) 204;
		blue[117] = (byte) 102;
		red[118] = (byte) 102;
		green[118] = (byte) 204;
		blue[118] = (byte) 51;
		red[119] = (byte) 102;
		green[119] = (byte) 204;
		blue[119] = (byte) 0;
		red[120] = (byte) 102;
		green[120] = (byte) 153;
		blue[120] = (byte) 255;
		red[121] = (byte) 102;
		green[121] = (byte) 153;
		blue[121] = (byte) 204;
		red[122] = (byte) 102;
		green[122] = (byte) 153;
		blue[122] = (byte) 153;
		red[123] = (byte) 102;
		green[123] = (byte) 153;
		blue[123] = (byte) 102;
		red[124] = (byte) 102;
		green[124] = (byte) 153;
		blue[124] = (byte) 51;
		red[125] = (byte) 102;
		green[125] = (byte) 153;
		blue[125] = (byte) 0;
		red[126] = (byte) 102;
		green[126] = (byte) 102;
		blue[126] = (byte) 255;
		red[127] = (byte) 102;
		green[127] = (byte) 102;
		blue[127] = (byte) 204;
		red[128] = (byte) 102;
		green[128] = (byte) 102;
		blue[128] = (byte) 153;
		red[129] = (byte) 102;
		green[129] = (byte) 102;
		blue[129] = (byte) 102;
		red[130] = (byte) 102;
		green[130] = (byte) 102;
		blue[130] = (byte) 51;
		red[131] = (byte) 102;
		green[131] = (byte) 102;
		blue[131] = (byte) 0;
		red[132] = (byte) 102;
		green[132] = (byte) 51;
		blue[132] = (byte) 255;
		red[133] = (byte) 102;
		green[133] = (byte) 51;
		blue[133] = (byte) 204;
		red[134] = (byte) 102;
		green[134] = (byte) 51;
		blue[134] = (byte) 153;
		red[135] = (byte) 102;
		green[135] = (byte) 51;
		blue[135] = (byte) 102;
		red[136] = (byte) 102;
		green[136] = (byte) 51;
		blue[136] = (byte) 51;
		red[137] = (byte) 102;
		green[137] = (byte) 51;
		blue[137] = (byte) 0;
		red[138] = (byte) 102;
		green[138] = (byte) 0;
		blue[138] = (byte) 255;
		red[139] = (byte) 102;
		green[139] = (byte) 0;
		blue[139] = (byte) 204;
		red[140] = (byte) 102;
		green[140] = (byte) 0;
		blue[140] = (byte) 153;
		red[141] = (byte) 102;
		green[141] = (byte) 0;
		blue[141] = (byte) 102;
		red[142] = (byte) 102;
		green[142] = (byte) 0;
		blue[142] = (byte) 51;
		red[143] = (byte) 102;
		green[143] = (byte) 0;
		blue[143] = (byte) 0;
		red[144] = (byte) 51;
		green[144] = (byte) 255;
		blue[144] = (byte) 255;
		red[145] = (byte) 51;
		green[145] = (byte) 255;
		blue[145] = (byte) 204;
		red[146] = (byte) 51;
		green[146] = (byte) 255;
		blue[146] = (byte) 153;
		red[147] = (byte) 51;
		green[147] = (byte) 255;
		blue[147] = (byte) 102;
		red[148] = (byte) 51;
		green[148] = (byte) 255;
		blue[148] = (byte) 51;
		red[149] = (byte) 51;
		green[149] = (byte) 255;
		blue[149] = (byte) 0;
		red[150] = (byte) 51;
		green[150] = (byte) 204;
		blue[150] = (byte) 255;
		red[151] = (byte) 51;
		green[151] = (byte) 204;
		blue[151] = (byte) 204;
		red[152] = (byte) 51;
		green[152] = (byte) 204;
		blue[152] = (byte) 153;
		red[153] = (byte) 51;
		green[153] = (byte) 204;
		blue[153] = (byte) 102;
		red[154] = (byte) 51;
		green[154] = (byte) 204;
		blue[154] = (byte) 51;
		red[155] = (byte) 51;
		green[155] = (byte) 204;
		blue[155] = (byte) 0;
		red[156] = (byte) 51;
		green[156] = (byte) 153;
		blue[156] = (byte) 255;
		red[157] = (byte) 51;
		green[157] = (byte) 153;
		blue[157] = (byte) 204;
		red[158] = (byte) 51;
		green[158] = (byte) 153;
		blue[158] = (byte) 153;
		red[159] = (byte) 51;
		green[159] = (byte) 153;
		blue[159] = (byte) 102;
		red[160] = (byte) 51;
		green[160] = (byte) 153;
		blue[160] = (byte) 51;
		red[161] = (byte) 51;
		green[161] = (byte) 153;
		blue[161] = (byte) 0;
		red[162] = (byte) 51;
		green[162] = (byte) 102;
		blue[162] = (byte) 255;
		red[163] = (byte) 51;
		green[163] = (byte) 102;
		blue[163] = (byte) 204;
		red[164] = (byte) 51;
		green[164] = (byte) 102;
		blue[164] = (byte) 153;
		red[165] = (byte) 51;
		green[165] = (byte) 102;
		blue[165] = (byte) 102;
		red[166] = (byte) 51;
		green[166] = (byte) 102;
		blue[166] = (byte) 51;
		red[167] = (byte) 51;
		green[167] = (byte) 102;
		blue[167] = (byte) 0;
		red[168] = (byte) 51;
		green[168] = (byte) 51;
		blue[168] = (byte) 255;
		red[169] = (byte) 51;
		green[169] = (byte) 51;
		blue[169] = (byte) 204;
		red[170] = (byte) 51;
		green[170] = (byte) 51;
		blue[170] = (byte) 153;
		red[171] = (byte) 51;
		green[171] = (byte) 51;
		blue[171] = (byte) 102;
		red[172] = (byte) 51;
		green[172] = (byte) 51;
		blue[172] = (byte) 51;
		red[173] = (byte) 51;
		green[173] = (byte) 51;
		blue[173] = (byte) 0;
		red[174] = (byte) 51;
		green[174] = (byte) 0;
		blue[174] = (byte) 255;
		red[175] = (byte) 51;
		green[175] = (byte) 0;
		blue[175] = (byte) 204;
		red[176] = (byte) 51;
		green[176] = (byte) 0;
		blue[176] = (byte) 153;
		red[177] = (byte) 51;
		green[177] = (byte) 0;
		blue[177] = (byte) 102;
		red[178] = (byte) 51;
		green[178] = (byte) 0;
		blue[178] = (byte) 51;
		red[179] = (byte) 51;
		green[179] = (byte) 0;
		blue[179] = (byte) 0;
		red[180] = (byte) 0;
		green[180] = (byte) 255;
		blue[180] = (byte) 255;
		red[181] = (byte) 0;
		green[181] = (byte) 255;
		blue[181] = (byte) 204;
		red[182] = (byte) 0;
		green[182] = (byte) 255;
		blue[182] = (byte) 153;
		red[183] = (byte) 0;
		green[183] = (byte) 255;
		blue[183] = (byte) 102;
		red[184] = (byte) 0;
		green[184] = (byte) 255;
		blue[184] = (byte) 51;
		red[185] = (byte) 0;
		green[185] = (byte) 255;
		blue[185] = (byte) 0;
		red[186] = (byte) 0;
		green[186] = (byte) 204;
		blue[186] = (byte) 255;
		red[187] = (byte) 0;
		green[187] = (byte) 204;
		blue[187] = (byte) 204;
		red[188] = (byte) 0;
		green[188] = (byte) 204;
		blue[188] = (byte) 153;
		red[189] = (byte) 0;
		green[189] = (byte) 204;
		blue[189] = (byte) 102;
		red[190] = (byte) 0;
		green[190] = (byte) 204;
		blue[190] = (byte) 51;
		red[191] = (byte) 0;
		green[191] = (byte) 204;
		blue[191] = (byte) 0;
		red[192] = (byte) 0;
		green[192] = (byte) 153;
		blue[192] = (byte) 255;
		red[193] = (byte) 0;
		green[193] = (byte) 153;
		blue[193] = (byte) 204;
		red[194] = (byte) 0;
		green[194] = (byte) 153;
		blue[194] = (byte) 153;
		red[195] = (byte) 0;
		green[195] = (byte) 153;
		blue[195] = (byte) 102;
		red[196] = (byte) 0;
		green[196] = (byte) 153;
		blue[196] = (byte) 51;
		red[197] = (byte) 0;
		green[197] = (byte) 153;
		blue[197] = (byte) 0;
		red[198] = (byte) 0;
		green[198] = (byte) 102;
		blue[198] = (byte) 255;
		red[199] = (byte) 0;
		green[199] = (byte) 102;
		blue[199] = (byte) 204;
		red[200] = (byte) 0;
		green[200] = (byte) 102;
		blue[200] = (byte) 153;
		red[201] = (byte) 0;
		green[201] = (byte) 102;
		blue[201] = (byte) 102;
		red[202] = (byte) 0;
		green[202] = (byte) 102;
		blue[202] = (byte) 51;
		red[203] = (byte) 0;
		green[203] = (byte) 102;
		blue[203] = (byte) 0;
		red[204] = (byte) 0;
		green[204] = (byte) 51;
		blue[204] = (byte) 255;
		red[205] = (byte) 0;
		green[205] = (byte) 51;
		blue[205] = (byte) 204;
		red[206] = (byte) 0;
		green[206] = (byte) 51;
		blue[206] = (byte) 153;
		red[207] = (byte) 0;
		green[207] = (byte) 51;
		blue[207] = (byte) 102;
		red[208] = (byte) 0;
		green[208] = (byte) 51;
		blue[208] = (byte) 51;
		red[209] = (byte) 0;
		green[209] = (byte) 51;
		blue[209] = (byte) 0;
		red[210] = (byte) 0;
		green[210] = (byte) 0;
		blue[210] = (byte) 255;
		red[211] = (byte) 0;
		green[211] = (byte) 0;
		blue[211] = (byte) 204;
		red[212] = (byte) 0;
		green[212] = (byte) 0;
		blue[212] = (byte) 153;
		red[213] = (byte) 0;
		green[213] = (byte) 0;
		blue[213] = (byte) 102;
		red[214] = (byte) 0;
		green[214] = (byte) 0;
		blue[214] = (byte) 51;
		red[215] = (byte) 82;
		green[215] = (byte) 97;
		blue[215] = (byte) 132;
		red[216] = (byte) 238;
		green[216] = (byte) 238;
		blue[216] = (byte) 238;
		red[217] = (byte) 221;
		green[217] = (byte) 221;
		blue[217] = (byte) 221;
		red[218] = (byte) 187;
		green[218] = (byte) 187;
		blue[218] = (byte) 187;
		red[219] = (byte) 170;
		green[219] = (byte) 170;
		blue[219] = (byte) 170;
		red[220] = (byte) 136;
		green[220] = (byte) 136;
		blue[220] = (byte) 136;
		red[221] = (byte) 119;
		green[221] = (byte) 119;
		blue[221] = (byte) 119;
		red[222] = (byte) 85;
		green[222] = (byte) 85;
		blue[222] = (byte) 85;
		red[223] = (byte) 68;
		green[223] = (byte) 68;
		blue[223] = (byte) 68;
		red[224] = (byte) 34;
		green[224] = (byte) 34;
		blue[224] = (byte) 34;
		red[225] = (byte) 17;
		green[225] = (byte) 17;
		blue[225] = (byte) 17;

		// Create the index colour model
		IndexColorModel palette = new IndexColorModel(8, red.length, red,
				green, blue);
		return palette;
	}

	/**
	 * Creates the bitmap palette
	 */
	private static IndexColorModel createBitmapPalette() {

		byte red[] = new byte[256];
		byte green[] = new byte[256];
		byte blue[] = new byte[256];

		red[0] = green[0] = blue[0] = (byte) 255;

		red[226] = green[226] = blue[226] = (byte) 245; // 255 will make it look
														// white
		red[227] = green[227] = blue[227] = (byte) 238;
		red[228] = green[228] = blue[228] = (byte) 221;
		red[229] = green[229] = blue[229] = (byte) 204;
		red[230] = green[230] = blue[230] = (byte) 204;
		red[231] = green[231] = blue[231] = (byte) 187;
		red[232] = green[232] = blue[232] = (byte) 187;
		red[233] = green[233] = blue[233] = (byte) 170;
		red[234] = green[234] = blue[234] = (byte) 153;
		red[235] = green[235] = blue[235] = (byte) 153;
		red[236] = green[236] = blue[236] = (byte) 153;
		red[237] = green[237] = blue[237] = (byte) 102;
		red[238] = green[238] = blue[238] = (byte) 119;
		red[239] = green[239] = blue[239] = (byte) 85;
		red[240] = green[240] = blue[240] = (byte) 68;
		red[241] = green[241] = blue[241] = (byte) 68;

		red[255] = green[255] = blue[255] = (byte) 255;

		red[253] = (byte) 0;
		green[253] = (byte) 153;
		blue[253] = (byte) 51;

		red[254] = (byte) 0;
		green[254] = (byte) 51;
		blue[254] = (byte) 204;
		
		red[35] = (byte) 189;
		green[35] = (byte) 8;
		blue[35] = (byte) 24;
		

		IndexColorModel palette = new IndexColorModel(8, red.length, red,
				green, blue);

		return palette;
	}

}