/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.configuration;

import java.io.Serializable;

/**
 * This class provides a wrapper class for encapsulating the parameter name
 * and value for one configuration parameter in the current configuration
 * file being used by the <code>ConfigurationStorage</code>.
 *
 */
public class Parameter implements Serializable
{

    /**
     * Specifies the key for this <code>Parameter</code> in the
     * configuration file.
     */
    private String myKey   = "";

    /**
     * Specifies the value for this <code>Parameter</code> in the
     * configuration file.
     */
    private String myValue = "";



   /**
    * Specifies a new parameter in the configuration file with name "paramName"
    * and value "paramValue".
    *
    * @param paramName  Parameter name.
    * @param paramValue Parameter value.
    * @param paramType  Parameter type Int, String or Boolean
    */
   public Parameter( String paramName, String paramValue )
   {
       myKey = paramName;
       myValue = paramValue;
   }


   /**
    * Fetches the value for the configuration parameter.
    *
    * @return String    Parameter value.
    */
   public String getValue( )
   {
       return myValue;
   }



   /**
    * Sets the value for the configuration parameter to "paramValue"
    *
    * @param paramValue New value for the configuration parameter.
    */
   public void setValue( String paramValue )
   {
       myValue = paramValue;
   }



   /**
    * Fetches the key for the configuration parameter.
    *
    * @return String    Parameter's key.
    */
   public String getKey( )
   {
       return myKey;
   }



   /**
    * Sets the key for the configuration parameter to "paramKey"
    *
    * @param paramKey   New key for the configuration parameter.
    */
   public void setKey( String paramKey )
   {
       myKey = paramKey;
   }


   /**
    * Overwritten toString() method for debugging purpose.
    * @return Contents of this parameter.
    */
   public String toString()
   {
       StringBuffer to = new StringBuffer();
       to.append( myKey );
       to.append("=");
       to.append( myValue );
       return to.toString();
   }


}
