/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.converter;

/**
 * This interface defines the constants used in the conversion process.
 */
public interface ConversionConstants
{
	/**
	 * The root element for the black list file.
	 */
	public static final String TAG_SVG_ROOT = "svg";

	/**
	 * The root element for the black list file.
	 */
	public static final String TAG_BLACKLIST_ROOT = "blackList";

	/**
	 * The root element for the passThrough file.
	 */
	public static final String TAG_PASSTHROUGH_ROOT = "passThrough";

	/**
	 * The root element for the grey list file.
	 */
	public static final String TAG_GREYLIST_ROOT = "greyList";

	/**
	 * The tag identifying a module in a black/grey list file.
	 */
	public static final String TAG_MODULE       = "module";


	/**
	 * The tag identifying a nameSpace in a passThrough file.
	 */
	public static final String TAG_NAMESPACE       = "namespace";


	/**
	 * The tag identifying an element in a black/grey list file.
	 */
	public static final String TAG_ELEMENT      = "element";

	/**
	 * Tag specifying the name of the element/attribute.
	 */
	public static final String TAG_NAME         = "name";

	/**
	 * Tag specifying if an element or its attribute is to be 
	 * removed or a warning has to be raised.
	 */
	public static final String TAG_REMOVE       = "remove";

	/**
	 * Specifies that element has to be removed or warning is to be
	 * raised.
	 */
	public static final String TAG_TRUE   = "true";

	/**
	 * Specifies that the attribute has to be removed or warning has to 
	 * be raised.
	 */
	public static final String TAG_FALSE = "false";


	/**
	 * Specifies if all the elements/attributes for this namespace are allowed.
	 */
	public static final String TAG_ALLOWALL = "allowAll";
	
	/**
	 * Specifies if nameSpace is a URL or not 
	 */
	public static final String TAG_URL      =     "url";

	/**
	 * Specifies if all the elements/attributes for this namespace are allowed.
	 */
	public static final String TAG_URLCONTAINS = "urlcontains";

	/**
	 * The tag identifying an attribute in a black/grey list file.
	 */
	public static final String TAG_ATTRIBUTE    = "attribute";

	/**
	 * Tag identifying an attribute set in a black/grey list file.
	 */
	public static final String TAG_ATTRSET      = "attrset";

	/**
	 * Tag identifying the value for the attribute in the black/grey list.
	 */
	public static final String TAG_VALUE        = "value";

	/**
	 * Tag identifying if warning is to be raised or not.
	 */
	public static final String TAG_WARN         = "warn";

	/**
	 * The tag-name for the "fill-opacity" attribute.
	 */
	public static final String FILL_OPACITY_ATTRIBUTE = "fill-opacity";

	/**
	 * The tag-name for the "stroke-opacity" attribute.
	 */   
	public static final String STROKE_OPACITY_ATTRIBUTE = "stroke-opacity";
	
	/**
	 * Tag name for the base profile attribute.
	 */
	public static final String BASE_PROFILE_ATTRIBUTE = "baseProfile";
	
	/**
	 * Attribute value for the baseProfile attribute in SVGT file.
	 */
	public static final String BASE_PROFILE_TINY = "tiny";

    /**
     * Attribute name for the id attribute.
     */
    public static final String ID_ATTRIBUTE      = "id";

    /**
     * Identifies a local reference to another identifier in the document.
     */
    public static final String ID_REFERENCE_IDENTIFIER = "url(#";

    /**
     * Identifies a local XPointer reference to another identifier in the
     * document.
     */    
    public static final String ID_XPOINTER_REFERENCE_IDENTIFIER = "#xpointer(\"";
	
	/**
	 * Identifies a local # reference to another identifier in the
	 * document.
	 */    
	public static final String HASH_REFERENCE_IDENTIFIER = "#";
    /**
     * Tag identifying a linear gradient element.
     */    
    public static final String TAG_LINEAR_GRADIENT = "linearGradient";
    
    /**
     * Tag identifying a radial gradient element.
     */
	public static final String TAG_RADIAL_GRADIENT = "raidalGradient";
	
	/**
	 * Tag identifying a defs element.
	 */
	public static final String TAG_DEFS            = "defs";
	
	/**
	 * Public identifier for SVGT.
	 */
	public static final String SVGT_DOCUMENT_PUBLIC_ID = "-//W3C//DTD SVG 1.1 Tiny//EN";

    /**
     * System indentifier for SVGT.
     */
	public static final String SVGT_DOCUMENT_SYSTEM_ID = "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd";

    /**
     * URL containing the SVG namespace.
     */
	public static final String SVG_NAMESPACE_ID        = "http://www.w3.org/2000/svg";

    /**
     * Tag name for declaring XML namespaces.
     */
	public static final String XML_NAMESPACE_ID        = "xmlns"; 
	/**
	 * Tag name for declaring XML xlink.
	 */
	public static final String XML_TAG_XLINK        = "xlink";  
	/**
	 * Tag name for declaring XML x1.
	 */
	public static final String XML_TAG_X1        = "x1";  
	/**
	 * Tag name for declaring XML y1.
	 */
	public static final String XML_TAG_Y1        = "y1";  
	/**
	 * Tag name for declaring XML x2.
	 */
	public static final String XML_TAG_X2        = "x2";  
	/**
	 * Tag name for declaring XML y2.
	 */
	public static final String XML_TAG_Y2        = "y2";  
	/**
	 * Tag name for declaring XML cx.
	 */
	public static final String XML_TAG_CX        = "cx";  
	/**
	 * Tag name for declaring XML fx.
	 */
	public static final String XML_TAG_FX        = "fx";  
	/**
	 * Tag name for declaring XML cy.
	 */
	public static final String XML_TAG_CY        = "cy";  
	/**
	 * Tag name for declaring XML cx.
	 */
	public static final String XML_TAG_R        = "r";  
	/**
	 * Tag name for declaring XML fy.
	 */
	public static final String XML_TAG_FY        = "fy";  
	/**
	 * Tag name for declaring XML stop.
	 */
	public static final String XML_TAG_STOP        = "stop";  
	/**
	 * Tag name for declaring XML offset.
	 */
	public static final String XML_TAG_OFFSET        = "offset";  	
	/**
	 * Tag name for declaring %.
	 */
	public static final String TAG_PERCENTAGE        = "%";  
	/**
	 * Tag name for declaring 0.
	 */
	public static final String TAG_ONE        = "1"; 
	/**
	 * Tag name for declaring 1.
	 */
	public static final String TAG_ZERO        = "0"; 	
	
	/**
	 * Tag name for declaring width.
	 */
	public static final String TAG_WIDTH        = "width"; 	

	/**
	 * Tag name for declaring height.
	 */
	public static final String TAG_HEIGHT        = "height";
	
	/**
	 * Tag name for declaring overwrite dimension.
	 */
	public static final String TAG_OVERWRITE_DIMENSION   = "OVERWRITE_DIMENSION";
}
