/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.converter;

/**
 * <code>SVGAttribute</code> forms a wrapper class for wrapping a attribute
 * defined in a black list or grey list file.
 * 
 */
public class SVGAttribute {
	/**
	 * Specifies the name for this attribute.
	 */
	private String myName = null;

	/**
	 * Specifies the name of the parent <code>SVGElement</code> to which this
	 * attribute belongs
	 */
	private String myParentElement = null;

	/**
	 * Specifies the name of the parent <code>SVGModule</code> to which this
	 * attribute belongs.
	 */
	private String myParentModule = null;

	/**
	 * Specifies the attribute set to which this attribute belongs.
	 */
	private String myAttributeSet = null;

	/**
	 * Specifies the value for this attribute.
	 */
	private Object myValue = null;

	/**
	 * Specifies the attribute is a warned type or not
	 */
	private boolean isWarned = false;

	/**
	 * Creates the new <code>SVGAttribute</code>.
	 * 
	 * @param attrName
	 *            Name of this attribute.
	 * @param parentElement
	 *            Parent element to which this attribute belongs.
	 * @param parentModule
	 *            Parent module name containing this attribute.
	 * @param attrSet
	 *            Attribute set to which this attribute belongs.
	 * @param value
	 *            Value for this attribute.
	 */
	public SVGAttribute(String attrName, String parentElement,
			String parentModule, String attrSet, Object value) {
		myName = attrName;
		myParentElement = parentElement;
		myParentModule = parentModule;
		myAttributeSet = attrSet;
		myValue = value;
	}

	/**
	 * Returns the attribute name.
	 * 
	 * @return Name of the attribute.
	 */
	public String getAttributeName() {
		return myName;
	}

	/**
	 * Returns the name of the parent <code>SVGElement</code> to which this
	 * attribute belongs.
	 * 
	 * @return Element name to which this attribute belongs.
	 */
	public String getParentElementName() {
		return myParentElement;
	}

	/**
	 * Returns the parent module name to which this attribute belongs.
	 * 
	 * @return Parent module name.
	 */
	public String getParentModuleName() {
		return myParentModule;
	}

	/**
	 * Obtains the value for this attribute.
	 * 
	 * @return Value for this attribute.
	 */
	public Object getAttributeValue() {
		return myValue;
	}

	/**
	 * Sets the new value for this attribute.
	 * 
	 * @param newValue
	 *            New value for the attribute.
	 */
	private void setValue(Object newValue) {
		myValue = newValue;
	}

	public String toString() {
		// //System.out.println("Attribute Name = " + myName );
		// System.out.println("Attribute Name = " + myName );
		// System.out.println("Attribute Value = " + myValue );
		// //System.out.println("Parent Element Name = " + myParentElement );
		// //System.out.println("Parent Module Name = " + myParentModule );
		return myName;
	}

	/**
	 * Main method for testing.
	 * 
	 * @param args
	 *            Command line arguments.
	 */
	public static void main(String[] args) {
	}

	/**
	 * @return
	 */
	public boolean isWarned() {
		return isWarned;
	}

	/**
	 * @param b
	 */
	public void setWarned(boolean b) {
		isWarned = b;
	}

	/**
	 * @param object
	 */
	public void setMyValue(Object object) {
		myValue = object;
	}

}
