/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

/**
 *This is the class written for the creation of the Grey list panel
 *which contains one constructors and one method which is been called 
 *by the constructor for building a panel which in turn is added to 
 *the split pane of the application.
 * 
 */

import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

import javax.swing.border.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

import com.nokia.svg2svgt.localiser.Localiser;

/*
 * 
 * This is the starting the main class for creating the panel
 */
public class GreyListPanel extends JPanel implements ActionListener {

	private SVGTConverterController myController = null;

	private JPanel grayListpanel;
	private JPanel tablePanel;

	private DefaultTableModel dtm;
	private JTable grayListTable;
	private JScrollPane scroll;
	private TitledBorder titledBorder2;

	private JButton addButton;
	private JButton removeButton;
	private JButton editButton;
	private JPanel buttonPanel;

	private Vector rowData;
	private Vector columns;
	private Vector rows;

	Localiser localiser;
	TableColumn myColumn;
	JCheckBox checkBox;
	DefaultTableCellRenderer renderer;
	JCheckBox checkBox1;
	TableColumn myColumn1;
	DefaultTableCellRenderer renderer1;

	/*
	 * constructor declaration
	 */
	public GreyListPanel(SVGTConverterController parent, Localiser localiser) {
		myController = parent;
		try {
			this.localiser = localiser;
			createPanel();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	 * This is the method which is responsible for creating the table and the
	 * panel containing the gray list and black list tables and control buttons.
	 */
	public void createPanel() throws Exception {
		titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(148, 145, 140)), "Pass-Through List");// localiser
																				// .
																				// getText
																				// (
																				// "GreyList.Title"
																				// )
																				// )
																				// ;

		grayListpanel = new JPanel();
		grayListpanel.setLayout(new BorderLayout());

		tablePanel = new JPanel();
		tablePanel.setBorder(titledBorder2);
		tablePanel.setLayout(new BorderLayout());

		columns = new Vector();
		columns.add("Namespace");
		columns.add(localiser.getText("GreyList.table.column1"));
		columns.add(localiser.getText("GreyList.table.column2"));
		columns.add(localiser.getText("GreyList.table.column3"));

		rowData = new Vector();
		rowData.add("");
		rowData.add("");
		rowData.add("");

		rows = new Vector();
		rows.addElement(rowData);

		dtm = new DefaultTableModel();
		dtm.setDataVector(rows, columns);
		grayListTable = new JTable(dtm);
		(grayListTable.getTableHeader()).setReorderingAllowed(false);
		grayListTable.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent arg0) {
			}

			public void keyReleased(KeyEvent e) {
			}

			public void keyTyped(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_DELETE) {
					dtm.removeRow(grayListTable.getSelectedRow());
				}
				if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					Vector rowdata = new Vector();
					rowdata.add("");
					rowdata.add("");
					rowdata.add("");
					dtm.addRow(rowdata);
				}
			}
		});

		scroll = new JScrollPane();
		scroll.getViewport().add(grayListTable);
		tablePanel.add(scroll);

		buttonPanel = new JPanel();
		addButton = new JButton(localiser.getText("GreyList.Addbutton"));
		addButton.addActionListener(this);

		removeButton = new JButton(localiser.getText("GreyList.Removebutton"));
		removeButton.addActionListener(this);

		editButton = new JButton("Edit");
		editButton.addActionListener(this);

		buttonPanel.add(addButton);
		buttonPanel.add(removeButton);

		grayListpanel.add(tablePanel, BorderLayout.CENTER);
		grayListpanel.add(buttonPanel, BorderLayout.SOUTH);
		grayListpanel.setPreferredSize(new Dimension(414, 327));
		add(grayListpanel);
	}

	/*
	 * Action performed class for the Gerylist panel
	 */
	public void actionPerformed(ActionEvent ae) {
		if (ae.getActionCommand().equals(
				localiser.getText("GreyList.Addbutton"))) {
			Vector newRow = new Vector();
			newRow.add("");
			newRow.add("");
			newRow.add("");
			newRow.add("");
			dtm.addRow(newRow);
		} else if (ae.getActionCommand().equals(
				localiser.getText("GreyList.Removebutton"))) {
			int i[] = grayListTable.getSelectedRows();
			for (int j = 0; j < i.length; j++) {
				dtm.removeRow(j + 1);
			}
		}
	}
}