/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.log;

/**
 * This interface provides the methods for receiving the log events/warnings
 * raised during the conversion process. <code>SVGTConverterController</code>
 * implements this listener interface and registers itself as listener with
 * <code>SVGConverter</code> for receiving the log events.
 * 
 */
public interface LogListener {

	/**
	 * Forwards the log event to the <code>SVGTConverterView</code> and
	 * <code>FileLogger</code>.
	 * 
	 * @param desc
	 *            Log event description
	 */
	public void log(String desc);

	/**
	 * Forwards the warning event to the <code>SVGTConverterView</code> and
	 * <code>FileLogger</code>.
	 * 
	 * @param desc
	 *            Warning event description.
	 */
	public void logWarning(String desc);
}
