/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import com.nokia.svg2svgt.SVG2SVGTConstants;
import java.util.ResourceBundle;

/**
 * <code>LogWriter</code> provides the functionality of writing the log
 * events/warnings to the file.
 * 
 */
public class LogWriter {

	public boolean doLogging = true;

	private File mylogFile = null;

	/**
	 * Creates the file logger with the specific region coding.
	 * 
	 * @param region
	 *            Region to which this logger belongs
	 */
	public LogWriter(String region) {
		try {
			LogMessages.init(ResourceBundle.getBundle("SVG2SVGTProperties")
					.getString("SVGT_LOG_FILE"), region);
		} catch (Exception ex) {
			System.out.println(ex.toString());
			doLogging = false;
		}
		mylogFile = new File(ResourceBundle.getBundle("SVG2SVGTProperties")
				.getString("SVGT_REPORT_FILE"));
	}

	/**
	 * Disables logging of events.
	 */
	public void disableLogging() {
		doLogging = false;
	}

	/**
	 * Logs the event.
	 * 
	 * @param mode
	 *            Mode of operation for the tool - GUI or BATCH
	 * @param desc
	 *            Description of the event to be logged.
	 */
	public void log(String mode, String desc) {
		if (mode.equalsIgnoreCase(SVG2SVGTConstants.BATCH_MODE)) {
			writeToScreen(desc);
		}
		// else
		// {
		// send the log to the view
		writeToFile(desc);

		// }
	}

	/**
	 * Writes the events to the standard output.
	 * 
	 * @param desc
	 *            Description of the event to be logged.
	 */
	public void writeToScreen(String desc) {
		if (true == doLogging) {
			System.out.println(desc);
		}
	}

	/**
	 * Writes this log to the log file.
	 * 
	 * @param desc
	 *            Log description.
	 */
	public void writeToFile(String desc) {
		if (true == doLogging) {
			// write the logs into a file...
			// File logFile = new File( ".\\logFile.txt");
			try {
				FileWriter writer = new FileWriter(mylogFile, true);
				writer.write(desc);
				writer.write("\n");
				writer.close();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
}
