/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt;

import com.nokia.svg2svgt.SVG2SVGTConstants;
import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.log.LogMessages;
import com.nokia.svg2svgt.log.LogWriter;
import com.nokia.svg2svgt.util.WCMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class CommandLineParser
implements SVG2SVGTConstants {
    private static LogWriter myLogWriter = null;

    public static Hashtable parseCommandLineArguments(String[] args) throws Exception {
        myLogWriter = (LogWriter)ServiceRegistry.getService("com.nokia.svg2svgt.log.Logger");
        if (myLogWriter == null) {
            myLogWriter = new LogWriter("GB");
            ServiceRegistry.registerService(myLogWriter);
        }
        int argsCount = args.length;
        Hashtable<String, Object> parsedCmdLineParams = new Hashtable<String, Object>();
        parsedCmdLineParams.put("-convfile", ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_CONVERSION_FILEPATH"));
        if (argsCount < 0) {
            return parsedCmdLineParams;
        }
        String argsValue = null;
        ArrayList<String> cmdLineParams = new ArrayList<String>(argsCount);
        int i = 0;
        while (i < argsCount) {
            cmdLineParams.add(args[i]);
            ++i;
        }
        Iterator iter = cmdLineParams.iterator();
        String optionValue = null;
        while (iter.hasNext()) {
            int i2;
            argsValue = (String)iter.next();
            if ("-svglist".equalsIgnoreCase(argsValue)) {
                if (iter.hasNext()) {
                    optionValue = (String)iter.next();
                    CommandLineParser.raiseEvent(3200L, new String[]{argsValue, optionValue});
                    if (CommandLineParser.isAnOption(optionValue)) {
                        CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                    }
                    CommandLineParser.resolveSVGFileListOption(parsedCmdLineParams, optionValue);
                    continue;
                }
                CommandLineParser.raiseException(2100L, new String[]{argsValue});
                continue;
            }
            if ("-o".equalsIgnoreCase(argsValue)) {
                if (iter.hasNext()) {
                    optionValue = (String)iter.next();
                    CommandLineParser.raiseEvent(3200L, new String[]{argsValue, optionValue});
                    if (CommandLineParser.isAnOption(optionValue)) {
                        CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                    }
                    parsedCmdLineParams.put("-o", optionValue);
                    continue;
                }
                CommandLineParser.raiseException(2100L, new String[]{argsValue});
                continue;
            }
            if ("-p".equalsIgnoreCase(argsValue)) {
                if (iter.hasNext()) {
                    optionValue = (String)iter.next();
                    CommandLineParser.raiseEvent(3200L, new String[]{argsValue, optionValue});
                    if (CommandLineParser.isAnOption(optionValue)) {
                        CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                    }
                    parsedCmdLineParams.put("-p", optionValue);
                    continue;
                }
                CommandLineParser.raiseException(2100L, new String[]{argsValue});
                continue;
            }
            if ("-file".equalsIgnoreCase(argsValue)) {
                if (iter.hasNext()) {
                    optionValue = (String)iter.next();
                    CommandLineParser.raiseEvent(3200L, new String[]{argsValue, optionValue});
                    if (CommandLineParser.isAnOption(optionValue)) {
                        CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                    }
                    CommandLineParser.resolveFileOption(parsedCmdLineParams, optionValue);
                    continue;
                }
                CommandLineParser.raiseException(2100L, new String[]{argsValue});
                continue;
            }
            if ("-help".equalsIgnoreCase(argsValue)) {
                CommandLineParser.displayCommandLineUsage();
                continue;
            }
            if ("-d".equalsIgnoreCase(argsValue)) {
                if (iter.hasNext()) {
                    boolean success;
                    optionValue = (String)iter.next();
                    CommandLineParser.raiseEvent(3200L, new String[]{argsValue, optionValue});
                    if (CommandLineParser.isAnOption(optionValue)) {
                        CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                    }
                    if (success = CommandLineParser.resolveDimensionOption(parsedCmdLineParams, optionValue)) continue;
                    CommandLineParser.raiseException(2000L, new String[]{optionValue});
                    continue;
                }
                CommandLineParser.raiseException(2100L, new String[]{argsValue});
                continue;
            }
            String[] fileArray = null;
            ArrayList<String> fileList = new ArrayList<String>();
            fileArray = CommandLineParser.checkWildCharacters(argsValue);
            if (fileArray != null) {
                i2 = 0;
                while (i2 < fileArray.length) {
                    fileList.add(fileArray[i2]);
                    ++i2;
                }
            }
            while (iter.hasNext()) {
                optionValue = (String)iter.next();
                if (CommandLineParser.isAnOption(optionValue)) {
                    CommandLineParser.raiseException(2000L, new String[]{optionValue, argsValue});
                }
                if ((fileArray = CommandLineParser.checkWildCharacters(optionValue)) == null) continue;
                i2 = 0;
                while (i2 < fileArray.length) {
                    fileList.add(fileArray[i2]);
                    ++i2;
                }
            }
            parsedCmdLineParams.put("-svgfile", fileList);
        }
        CommandLineParser.validateCommandLineArguments(parsedCmdLineParams);
        return parsedCmdLineParams;
    }

    private static void validateCommandLineArguments(Hashtable parsedCmdLineParams) throws Exception {
        if (parsedCmdLineParams.get("-convfile") == null) {
            parsedCmdLineParams.put("-convfile", ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_CONVERSION_FILEPATH"));
        }
        if (parsedCmdLineParams.get("-p") == null) {
            parsedCmdLineParams.put("-p", ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_DEFAULT_PASSTHROUGH"));
        }
        if (parsedCmdLineParams.get("-o") == null) {
            parsedCmdLineParams.put("-o", ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_DEFAULT_OUTPUTDIR"));
        }
        if (parsedCmdLineParams.get("-svgfile") == null) {
            CommandLineParser.raiseException(3900L, null);
        }
    }

    private static String[] checkWildCharacters(String argsValue) throws Exception {
        String fileSeparator = System.getProperty("file.separator");
        int fileSeparatorIndex = argsValue.lastIndexOf(fileSeparator);
        String directoryName = null;
        String fileName = null;
        directoryName = -1 != fileSeparatorIndex ? argsValue.substring(0, fileSeparatorIndex) : ".";
        fileName = argsValue.substring(fileSeparatorIndex + 1, argsValue.length());
        if (fileName == null || fileName.length() <= 0) {
            CommandLineParser.raiseException(2500L, null);
        }
        File parent = new File(directoryName);
        parent.isDirectory();
        String[] fileList = new String[]{String.valueOf(directoryName) + System.getProperty("file.separator") + fileName};
        return fileList;
    }

    private static void resolveSVGFileListOption(Hashtable parsedCmdLineParams, String paramValue) throws Exception {
        BufferedReader reader = null;
        String fileName = null;
        try {
            ArrayList<String> fileList = new ArrayList<String>();
            reader = new BufferedReader(new FileReader(paramValue));
            while ((fileName = reader.readLine()) != null) {
                String[] files = CommandLineParser.checkWildCharacters(fileName);
                if (files == null) continue;
                int i = 0;
                while (i < files.length) {
                    fileList.add(files[i]);
                    ++i;
                }
            }
            reader.close();
            if (fileList.size() > 0) {
                parsedCmdLineParams.put("-svgfile", fileList);
            }
        }
        catch (FileNotFoundException fnfex) {
            CommandLineParser.raiseException(2200L, new String[]{fileName, fnfex.getMessage()});
        }
        catch (IOException iex) {
            CommandLineParser.raiseException(2200L, new String[]{fileName, iex.getMessage()});
        }
    }

    private static void resolveFileOption(Hashtable parsedCmdLineParams, String fileName) throws Exception {
        ConfigurationManager configMgr = new ConfigurationManager(fileName);
        Configuration config = configMgr.getConfiguration();
        Hashtable params = config.toHash();
        if (params != null) {
            parsedCmdLineParams.putAll(params);
            if (parsedCmdLineParams.containsKey("-file")) {
                CommandLineParser.raiseException(2300L, null);
            } else if (parsedCmdLineParams.containsKey("-svglist")) {
                fileName = (String)parsedCmdLineParams.get("-svglist");
                CommandLineParser.resolveSVGFileListOption(parsedCmdLineParams, fileName);
            } else if (parsedCmdLineParams.containsKey("-svgfile")) {
                fileName = (String)parsedCmdLineParams.get("-svgfile");
                StringTokenizer tokenizer = new StringTokenizer(fileName, " ");
                ArrayList<String> fileList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    fileName = tokenizer.nextToken();
                    String[] nameList = CommandLineParser.checkWildCharacters(fileName);
                    if (nameList == null) continue;
                    int i = 0;
                    while (i < nameList.length) {
                        fileList.add(nameList[i]);
                        ++i;
                    }
                }
                if (fileList.size() > 0) {
                    parsedCmdLineParams.put("-svgfile", fileList);
                } else {
                    CommandLineParser.raiseException(2400L, new String[]{fileName});
                }
            }
        }
    }

    private static boolean isAnOption(String value) {
        return value.equalsIgnoreCase("-p") || value.equalsIgnoreCase("-file") || value.equalsIgnoreCase("-help") || value.equalsIgnoreCase("-o") || value.equalsIgnoreCase("-svgfile") || value.equalsIgnoreCase("-convfile") || value.equalsIgnoreCase("-svglist") || value.equalsIgnoreCase("-d");
    }

    private static boolean resolveDimensionOption(Hashtable cmdParams, String option) {
        String tempString = null;
        if (option.equalsIgnoreCase("normal")) {
            tempString = "normal";
        } else {
            if (-1 == option.indexOf("%")) {
                try {
                    Integer.parseInt(option.trim());
                    tempString = String.valueOf(option) + "%";
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            String temp = null;
            try {
                temp = -1 != option.indexOf("%") ? option.substring(0, option.indexOf("%")) : option;
                Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                return false;
            }
            tempString = option;
        }
        cmdParams.put("-d", tempString);
        return true;
    }

    private static void displayCommandLineUsage() {
        System.out.println("===============================================================");
        System.out.println("=============== Usage of command line tool ====================");
        System.out.println("===============================================================");
        System.out.println("The available options are:");
        System.out.println("-svglist :  Specifies the file name containing the list of ");
        System.out.println("            the input SVG file(s)");
        System.out.println("-o       :  Specifies the ouptput directory where SVGT files");
        System.out.println("            are saved.");
        System.out.println("-p       :  Specifies the passthrough file name.");
        System.out.println("-help    :  Displays the help on command line usage.");
        System.out.println("-file    :  Specifies the file containing the commandline args.");
        System.out.println("-d       :  Specifies to what percentage the widht and height of");
        System.out.println("            SVG has to be changed (Values range from 1% to 100%).");
        System.out.println("===============================================================");
        System.out.println("\n\n");
    }

    private static void raiseException(long code, Object[] params) throws Exception {
        if (myLogWriter != null) {
            String desc = LogMessages.getLogMessage(code, params);
            throw new Exception(desc);
        }
    }

    private static void raiseEvent(long code, Object[] params) {
        if (myLogWriter != null) {
            String desc = LogMessages.getLogMessage(code, params);
            myLogWriter.log("BatchMode", desc);
        }
    }

    public static void main(String[] args) {
        try {
            Hashtable ht = CommandLineParser.parseCommandLineArguments(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class SVGFilenameFilter
    implements FilenameFilter {
        private String myFilteringCriteria = null;

        public SVGFilenameFilter(String filter) {
            this.myFilteringCriteria = filter;
        }

        public boolean accept(File dir, String name) {
            File temp = new File(name);
            if (temp.isDirectory()) {
                return false;
            }
            return WCMatcher.match(this.myFilteringCriteria, name);
        }
    }
}

