/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt;

import com.nokia.svg2svgt.CommandLineParser;
import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.SVG2SVGTConverter;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.help.HelpMediator;
import com.nokia.svg2svgt.log.LogWriter;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class SVG2SVGTConverterApplication {
    private static String modeOfOperation = "GUI";
    private static SVGTConverterController myApplication = null;
    private static LogWriter myLogWriter = null;
    private static boolean instantiateHelp = false;

    public static void launchApplication(String[] args, boolean showThemeOptionPane) {
        Hashtable cmdLineArgs = null;
        if (args == null || args.length <= 0) {
            SVG2SVGTConverterApplication.launchApplicationInGUIMode();
        } else {
            try {
                cmdLineArgs = CommandLineParser.parseCommandLineArguments(args);
                if (cmdLineArgs.isEmpty()) {
                    SVG2SVGTConverterApplication.launchApplicationInGUIMode();
                } else {
                    modeOfOperation = "BatchMode";
                    myLogWriter = (LogWriter)ServiceRegistry.getService("com.nokia.svg2svgt.log.LogWriter");
                    myApplication = new SVGTConverterController(cmdLineArgs, modeOfOperation, myLogWriter);
                    if (showThemeOptionPane) {
                        String[] exceptions = SVG2SVGTConverter.exceptionMessage;
                        int i = 0;
                        while (i < exceptions.length) {
                            String exp = exceptions[i];
                            if (exp != null) {
                                JOptionPane.showMessageDialog(null, exp);
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Unable to launch the application. Reason: " + ex.getMessage());
            }
        }
    }

    public static void launchApplicationInGUIMode() {
        modeOfOperation = "GUI";
        myLogWriter = (LogWriter)ServiceRegistry.getService("com.nokia.svg2svgt.log.Logger");
        if (myLogWriter == null) {
            myLogWriter = new LogWriter("GB");
            ServiceRegistry.registerService(myLogWriter);
        }
        myApplication = new SVGTConverterController(modeOfOperation, myLogWriter);
    }

    public static HelpMediator getHelpMediator() {
        if (!instantiateHelp) {
            return null;
        }
        HelpMediator help = null;
        if (help == null) {
            help = new HelpMediator();
        }
        return help;
    }

    public static void main(String[] args) {
        instantiateHelp = true;
        SVG2SVGTConverterApplication.launchApplication(args, true);
    }

    public static String[] getErrorMessages() {
        return SVG2SVGTConverter.exceptionMessage;
    }
}

