/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.configuration;

import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class ConfigurationStorage {
    private String myCurrentConfigFileName = null;
    private String myPreviousConfigFileName = null;
    public final String PREVIOUS_SUFFIX = ".previous";

    public ConfigurationStorage(String fileName) {
        this.myPreviousConfigFileName = String.valueOf(fileName) + ".previous";
        this.myCurrentConfigFileName = fileName;
    }

    public Configuration readConfiguration() {
        return this.readFile(this.myCurrentConfigFileName);
    }

    public boolean saveConfiguration(Configuration newConfig) {
        String newConfFileName = String.valueOf(this.myCurrentConfigFileName) + ".new";
        String tempCurrFileName = String.valueOf(this.myCurrentConfigFileName) + ".temp";
        String tempPrevFileName = String.valueOf(this.myPreviousConfigFileName) + ".temp";
        File currentF = new File(this.myCurrentConfigFileName);
        File previousF = new File(this.myPreviousConfigFileName);
        File newF = new File(newConfFileName);
        File tempCurrentF = new File(tempCurrFileName);
        File tempPreviousF = new File(tempPrevFileName);
        try {
            if (!currentF.exists()) {
                FileOutputStream currentFOut = new FileOutputStream(this.myCurrentConfigFileName);
                currentFOut.write(0);
                currentFOut.close();
            }
            if (!previousF.exists()) {
                FileOutputStream previousFOut = new FileOutputStream(this.myPreviousConfigFileName);
                previousFOut.write(0);
                previousFOut.close();
            }
        }
        catch (IOException e) {
            System.out.println("Configuration Storage " + e);
            return false;
        }
        try {
            FileOutputStream temporaryNewPropFile = new FileOutputStream(newConfFileName);
            Properties newProp = this.confToProp(newConfig);
            newProp.save(temporaryNewPropFile, newConfFileName);
            temporaryNewPropFile.close();
        }
        catch (IOException e) {
            File f = new File(newConfFileName);
            f.delete();
            return false;
        }
        boolean renameOk = false;
        renameOk = currentF.renameTo(tempCurrentF);
        if (!renameOk) {
            newF.delete();
            return false;
        }
        renameOk = previousF.renameTo(tempPreviousF);
        if (!renameOk) {
            tempCurrentF.renameTo(currentF);
            newF.delete();
            return false;
        }
        renameOk = newF.renameTo(currentF);
        if (!renameOk) {
            tempPreviousF.renameTo(previousF);
            tempCurrentF.renameTo(currentF);
            newF.delete();
            return false;
        }
        renameOk = tempCurrentF.renameTo(previousF);
        if (!renameOk) {
            tempPreviousF.renameTo(previousF);
            tempCurrentF.renameTo(currentF);
            newF.delete();
            return false;
        }
        tempPreviousF.delete();
        return true;
    }

    private Configuration readFile(String fileName) {
        Configuration conf = new Configuration();
        Properties prop = new Properties();
        FileInputStream file = null;
        try {
            file = new FileInputStream(fileName);
            prop.load(file);
            file.close();
        }
        catch (FileNotFoundException e) {
            return conf;
        }
        catch (IOException e) {
            return conf;
        }
        this.propToConf(conf, prop);
        return conf;
    }

    private void propToConf(Configuration conf, Properties prop) {
        Enumeration<?> propNames = prop.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            String value = prop.getProperty(key);
            Parameter par = null;
            par = new Parameter(key, value);
            conf.put(par);
        }
    }

    private Properties confToProp(Configuration conf) {
        Properties prop = new Properties();
        Enumeration params = conf.elements();
        while (params.hasMoreElements()) {
            Parameter par = (Parameter)params.nextElement();
            String key = par.getKey();
            String value = par.getValue();
            prop.put(par.getKey(), par.getValue());
        }
        return prop;
    }
}

