/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.NonReferredIdRemover;
import com.nokia.svg2svgt.log.Logger;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GradientDefinitionMerger
implements ConversionConstants {
    public static void mergeGradientDefinitions(Document svgtDoc, Logger logger) {
        NodeList nodeList = svgtDoc.getElementsByTagName("linearGradient");
        GradientDefinitionMerger.mergeSimilarGradientDefinitions(nodeList, svgtDoc, logger);
        nodeList = svgtDoc.getElementsByTagName("raidalGradient");
        GradientDefinitionMerger.mergeSimilarGradientDefinitions(nodeList, svgtDoc, logger);
    }

    private static void mergeSimilarGradientDefinitions(NodeList nodeList, Document svgtDoc, Logger logger) {
        ArrayList<Node> nodes = null;
        if (nodeList != null) {
            nodes = new ArrayList<Node>(nodeList.getLength());
            int i = 0;
            while (i < nodeList.getLength()) {
                nodes.add(nodeList.item(i));
                ++i;
            }
            if (1 == nodes.size()) {
                Node node = (Node)nodes.get(0);
                GradientDefinitionMerger.createDefsParentElement(node, svgtDoc);
            }
            int currentIndex = 0;
            int maximumIndex = nodes.size();
            int tempIndex = currentIndex + 1;
            while (currentIndex != maximumIndex) {
                if (currentIndex == tempIndex) {
                    ++tempIndex;
                    continue;
                }
                Node node1 = (Node)nodes.get(currentIndex);
                if (currentIndex < maximumIndex && tempIndex <= nodes.size() - 1) {
                    Node node2 = (Node)nodes.get(tempIndex);
                    boolean areEqual = GradientDefinitionMerger.compareNodes(node1, node2);
                    if (!areEqual) {
                        ++tempIndex;
                    } else {
                        Node parentNode;
                        Attr attr1 = ((Element)node1).getAttributeNode("id");
                        Attr attr2 = ((Element)node2).getAttributeNode("id");
                        if (attr1 == null && attr2 == null) {
                            parentNode = node2.getParentNode();
                            parentNode.removeChild(node2);
                            nodes.remove(node2);
                            GradientDefinitionMerger.createDefsParentElement(node1, svgtDoc);
                            if (--maximumIndex > tempIndex) {
                                ++tempIndex;
                            }
                        } else if (attr1 == null || attr2 == null) {
                            if (attr1 == null) {
                                parentNode = node1.getParentNode();
                                parentNode.removeChild(node1);
                                nodes.remove(node1);
                                GradientDefinitionMerger.createDefsParentElement(node2, svgtDoc);
                                ++currentIndex;
                            } else {
                                parentNode = node2.getParentNode();
                                parentNode.removeChild(node2);
                                nodes.remove(node2);
                                GradientDefinitionMerger.createDefsParentElement(node1, svgtDoc);
                            }
                            if (--maximumIndex > tempIndex) {
                                ++tempIndex;
                            }
                        } else {
                            GradientDefinitionMerger.updateIdReferences(node2, attr1.getNodeValue(), svgtDoc);
                            parentNode = node2.getParentNode();
                            parentNode.removeChild(node2);
                            GradientDefinitionMerger.createDefsParentElement(node1, svgtDoc);
                            nodes.remove(node2);
                            if (--maximumIndex > tempIndex) {
                                ++tempIndex;
                            }
                        }
                    }
                }
                if (tempIndex < maximumIndex || tempIndex != maximumIndex) continue;
                tempIndex = ++currentIndex + 1;
            }
        }
    }

    private static void createDefsParentElement(Node node, Document svgtDoc) {
        Node parentNode = node.getParentNode();
        if (parentNode != null && !parentNode.getNodeName().equals("defs")) {
            Element defsElem = svgtDoc.createElement("defs");
            defsElem.appendChild(node);
            parentNode.appendChild(defsElem);
        }
    }

    private static void updateIdReferences(Node node, String newIdRef, Document svgtDoc) {
        Hashtable referredIdData = NonReferredIdRemover.getReferencedIdentifiers();
        Element elementNode = (Element)node;
        Attr attr = elementNode.getAttributeNode("id");
        String idValue = attr.getNodeValue();
        String nodeName = null;
        if (referredIdData != null) {
            nodeName = (String)referredIdData.get(idValue);
            NodeList nodeList = null;
            if (nodeName != null) {
                nodeList = svgtDoc.getElementsByTagName(nodeName);
            }
            if (nodeList != null) {
                Node tempNode = null;
                Attr attrNode = null;
                NamedNodeMap attrList = null;
                String attrValue = null;
                int i = 0;
                while (i < nodeList.getLength()) {
                    tempNode = nodeList.item(i);
                    if (1 == tempNode.getNodeType() && tempNode.hasAttributes()) {
                        attrList = tempNode.getAttributes();
                        int j = 0;
                        while (j < attrList.getLength()) {
                            StringBuffer tempStr;
                            int startIndex;
                            attrNode = (Attr)attrList.item(j);
                            attrValue = attrNode.getValue();
                            if (-1 != attrValue.indexOf("url(#") && -1 != attrValue.indexOf(idValue)) {
                                startIndex = attrValue.indexOf(idValue);
                                tempStr = new StringBuffer();
                                tempStr.append(attrValue.substring(0, startIndex));
                                tempStr.append(newIdRef);
                                tempStr.append(attrValue.substring(startIndex + idValue.length(), attrValue.length()));
                                attrNode.setNodeValue(tempStr.toString());
                            } else if (-1 != attrValue.indexOf("#xpointer(\"") && -1 != attrValue.indexOf(idValue)) {
                                startIndex = attrValue.indexOf(idValue);
                                tempStr = new StringBuffer();
                                tempStr.append(attrValue.substring(0, startIndex));
                                tempStr.append(newIdRef);
                                tempStr.append(attrValue.substring(startIndex + idValue.length(), attrValue.length()));
                                attrNode.setNodeValue(tempStr.toString());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static boolean compareNodes(Node node1, Node node2) {
        if (!node1.getNodeName().equalsIgnoreCase(node2.getNodeName())) {
            return false;
        }
        boolean haveSameAttr = GradientDefinitionMerger.compareAttributes(node1, node2);
        if (!haveSameAttr) {
            return false;
        }
        NodeList nodeList1 = node1.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        ArrayList<Node> childNodes1 = new ArrayList<Node>();
        ArrayList<Node> childNodes2 = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList1.getLength()) {
            if (1 == nodeList1.item(i).getNodeType()) {
                childNodes1.add(nodeList1.item(i));
            }
            ++i;
        }
        i = 0;
        while (i < nodeList2.getLength()) {
            if (1 == nodeList2.item(i).getNodeType()) {
                childNodes2.add(nodeList2.item(i));
            }
            ++i;
        }
        if (childNodes1.size() != childNodes2.size()) {
            return false;
        }
        i = 0;
        while (i < childNodes1.size()) {
            boolean areEqual = GradientDefinitionMerger.compareNodes((Node)childNodes1.get(i), (Node)childNodes2.get(i));
            if (!areEqual) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareAttributes(Node node1, Node node2) {
        NamedNodeMap attr1 = null;
        NamedNodeMap attr2 = null;
        if (node1.hasAttributes() && node2.hasAttributes()) {
            attr1 = node1.getAttributes();
            attr2 = node2.getAttributes();
            int attrCount1 = attr1.getLength();
            String id = ((Element)node1).getAttribute("id");
            if (id != null && id.trim().length() > 0) {
                --attrCount1;
            }
            int attrCount2 = attr2.getLength();
            id = ((Element)node2).getAttribute("id");
            if (id != null && id.trim().length() > 0) {
                --attrCount2;
            }
            Attr attribute = null;
            String attributeName = null;
            String attributeValue = null;
            if (attrCount1 != attrCount2) {
                return false;
            }
            int i = 0;
            while (i < attr1.getLength()) {
                attribute = (Attr)attr1.item(i);
                attributeName = attribute.getName();
                attributeValue = attribute.getValue();
                attribute = ((Element)node2).getAttributeNode(attributeName);
                if (attribute == null) {
                    return false;
                }
                if (!attributeName.equalsIgnoreCase("id") && !attributeValue.equalsIgnoreCase(attribute.getValue())) {
                    return false;
                }
                ++i;
            }
        }
        if (!node1.hasAttributes() && !node2.hasAttributes()) {
            return true;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            Document svgtDoc = XMLFileParser.parseFile("C:\\SVG\\samples\\Mine.svg", false);
            NonReferredIdRemover.processNonReferencedIDs(svgtDoc, null);
            GradientDefinitionMerger.mergeGradientDefinitions(svgtDoc, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

