/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.SVG2SVGTConstants;
import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.Conversions;
import com.nokia.svg2svgt.converter.NameSpaceAnalyzer;
import com.nokia.svg2svgt.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinearGradientPercentageConverter
implements Conversions,
ConversionConstants,
SVG2SVGTConstants {
    private Logger myLogger = null;
    static /* synthetic */ Class class$0;

    public void doConversion(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, Logger logger, String nsURL) throws DOMException {
        this.myLogger = logger;
        if (2 == svgNode.getNodeType()) {
            return;
        }
        if (1 == svgNode.getNodeType()) {
            NamedNodeMap svgNodesAttr;
            Element svgtParentElement = (Element)svgtNode;
            String elemName = svgNode.getNodeName();
            String nsName = null;
            int index = elemName.indexOf(":");
            if (-1 != index) {
                nsName = elemName.substring(0, index - 1);
                elemName = elemName.substring(index + 1, elemName.length());
            }
            if ((svgNodesAttr = svgNode.getAttributes()) != null) {
                int i = 0;
                while (i < svgNodesAttr.getLength()) {
                    String value;
                    Attr attr = (Attr)svgNodesAttr.item(i);
                    String attrName = attr.getName();
                    if ((attr.getName().endsWith("x1") || attr.getName().endsWith("x2") || attr.getName().endsWith("y1") || attr.getName().endsWith("y2") || attr.getName().endsWith("offset")) && -1 != (value = attr.getValue()).indexOf("%")) {
                        value = value.substring(0, value.indexOf("%"));
                        float intValue = Float.parseFloat(value);
                        attr.setValue(Float.toString(intValue /= 100.0f));
                    }
                    int indexForColon = attrName.indexOf(":");
                    String nsNameForAttr = null;
                    if (indexForColon != -1) {
                        nsNameForAttr = attrName.substring(0, indexForColon);
                        String nameForAttr = attrName.substring(indexForColon + 1, attrName.length());
                        if (!(nsNameForAttr.equalsIgnoreCase("xlink") && nsNameForAttr.equalsIgnoreCase("xmlns") && nsNameForAttr.equalsIgnoreCase("xlink"))) {
                            nsNameForAttr = null;
                        }
                    }
                    if (!this.retainNode(nsNameForAttr, nsURL, attrName, (short)2)) {
                        ((Element)svgNode).removeAttribute(attrName);
                    }
                    ++i;
                }
            }
            NodeList childNodes = svgNode.getChildNodes();
            LinkedHashMap stopTable = new LinkedHashMap();
            int length = childNodes.getLength();
            if (length > 0) {
                Attr attr;
                NamedNodeMap attrs;
                Element node1;
                Element node;
                int i;
                int i2 = 0;
                while (i2 < length) {
                    Node childNode = childNodes.item(i2);
                    if (!Element.class.isInstance(childNode)) {
                        ++i2;
                        continue;
                    }
                    if (childNode.getNodeName().equalsIgnoreCase("stop")) {
                        List<Node> list;
                        Attr attr2 = ((Element)childNode).getAttributeNode("offset");
                        String value = attr2.getNodeValue();
                        if (-1 != value.indexOf("%")) {
                            value = value.substring(0, value.indexOf("%"));
                            float floatValue = (float)((double)Integer.parseInt(value) * 1.0 / 100.0);
                            value = Float.toString(floatValue);
                            attr2.setValue(value);
                        }
                        if (stopTable.containsKey(value)) {
                            list = (List)stopTable.get(value);
                            list.add(childNode);
                        } else {
                            list = new ArrayList<Node>();
                            ((ArrayList)list).add(childNode);
                            stopTable.put(value, list);
                        }
                        svgNode.removeChild(childNode);
                        --length;
                        continue;
                    }
                    if (-1 == childNode.getNodeName().indexOf(":")) continue;
                    svgNode.removeChild(childNode);
                    --length;
                }
                Set keys = stopTable.keySet();
                Iterator enum1 = keys.iterator();
                float min = 1.0f;
                float max = 0.0f;
                while (enum1.hasNext()) {
                    float recent = Float.parseFloat((String)enum1.next());
                    if (recent < min) {
                        min = recent;
                    }
                    if (!(recent > max)) continue;
                    max = recent;
                }
                enum1 = keys.iterator();
                if (min != 0.0f) {
                    List list = (List)stopTable.get(Float.toString(min));
                    i = 0;
                    while (i < list.size()) {
                        node = (Element)list.get(i);
                        node1 = (Element)node.cloneNode(false);
                        attrs = node1.getAttributes();
                        int h = 0;
                        while (h < attrs.getLength()) {
                            attr = (Attr)attrs.item(h);
                            if (attr.getName().equalsIgnoreCase("offset")) {
                                attr.setValue("0");
                            }
                            ++h;
                        }
                        svgNode.appendChild(node1);
                        ++i;
                    }
                }
                while (enum1.hasNext()) {
                    List list = (List)stopTable.get(enum1.next());
                    i = 0;
                    while (i < list.size()) {
                        Element elem = (Element)list.get(i);
                        NamedNodeMap attrsOfelem = elem.getAttributes();
                        int k = 0;
                        while (k < attrsOfelem.getLength()) {
                            Attr h = (Attr)attrsOfelem.item(k);
                            ++k;
                        }
                        svgNode.appendChild(elem);
                        ++i;
                    }
                }
                if (max != 1.0f) {
                    List list = (List)stopTable.get(Float.toString(max));
                    i = 0;
                    while (i < list.size()) {
                        node = (Element)list.get(i);
                        node1 = (Element)node.cloneNode(false);
                        attrs = node1.getAttributes();
                        int h = 0;
                        while (h < attrs.getLength()) {
                            attr = (Attr)attrs.item(h);
                            if (attr.getName().equalsIgnoreCase("offset")) {
                                attr.setValue("1");
                            }
                            ++h;
                        }
                        svgNode.appendChild(node1);
                        ++i;
                    }
                }
            } else {
                this.logWarning(4000L, null);
            }
            if (this.retainNode(nsName, nsURL, svgNode.getNodeName(), (short)1)) {
                Node sampleNode = svgtDoc.importNode(svgNode, true);
                svgtParentElement.appendChild(sampleNode);
            }
        }
    }

    private boolean retainNode(String nsName, String nsURL, String nodeName, short nodetype) {
        if (this.isTagAllowed(nsName, nsURL, nodeName, nodetype)) {
            this.isWarningRequired(nsName, nsURL, nodeName);
            return true;
        }
        return false;
    }

    private boolean isTagAllowed(String nsName, String nsURL, String nodeName, short nodeType) {
        NameSpaceAnalyzer nameSpaceA = (NameSpaceAnalyzer)ServiceRegistry.getService("com.nokia.svg2svgt.converter.NameSpaceAnalyzer");
        if (nameSpaceA == null) {
            return false;
        }
        return nameSpaceA.isNodeAllowed(nsName, nsURL, nodeName, nodeType);
    }

    private boolean isWarningRequired(String nsName, String nsURL, String nodeName) {
        NameSpaceAnalyzer nameSpaceA = (NameSpaceAnalyzer)ServiceRegistry.getService("com.nokia.svg2svgt.converter.NameSpaceAnalyzer");
        if (nameSpaceA == null) {
            return false;
        }
        if (nameSpaceA.isWarningTag(nsName, nsURL, nodeName, (short)2)) {
            this.logWarning(2800L, new String[]{nodeName});
        }
        return true;
    }

    private void logEvent(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }

    private void logWarning(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }
}

