/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVG2SVGTConverter;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.log.Logger;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NameSpaceAnalyzer
implements ConversionConstants {
    private Document myDocument = null;
    private ArrayList myNameSpaceList = null;
    private Logger myLogger = null;

    public NameSpaceAnalyzer(String fileName, Logger logger) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException, IllegalArgumentException {
        this.myLogger = logger;
        this.logEvents(3100L, new String[]{fileName});
        this.myDocument = XMLFileParser.parseFile(fileName, false);
        this.loadPassThroughFile();
        this.printPassThroughFile(this.myNameSpaceList);
    }

    /*
     * Unable to fully structure code
     */
    private SVGNameSpace getSVGNameSpacesByURL(String url) {
        iter = this.myNameSpaceList.iterator();
        nameSpace = null;
        if (url != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            nameSpace = (SVGNameSpace)iter.next();
            if (!(nameSpace.isURI() != false ? nameSpace.getMyUri().equals(url) != false : nameSpace.getMyUri() != null && -1 != url.indexOf(nameSpace.getMyUri()))) continue;
            return nameSpace;
lbl8:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl9:
        // 1 sources

        return null;
    }

    public boolean isNodeAllowed(String nsName, String nsURL, String nodeName, short nodeType) {
        SVGAttribute svgAttr;
        SVGElement svgElem;
        if (nsName == null && nsURL == null) {
            return true;
        }
        Hashtable ht = SVG2SVGTConverter.getNSInCurrentDoc();
        Enumeration enum1 = ht.keys();
        String reqdUrl = null;
        if (nsName != null) {
            block0: while (enum1.hasMoreElements()) {
                String url = (String)enum1.nextElement();
                ArrayList variables = (ArrayList)ht.get(url);
                Iterator iter = variables.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next()).equalsIgnoreCase(nsName)) continue;
                    reqdUrl = url;
                    continue block0;
                }
            }
        } else {
            reqdUrl = nsURL;
        }
        SVGNameSpace nameSpace = null;
        nameSpace = this.getSVGNameSpacesByURL(reqdUrl);
        if (nameSpace == null) {
            return false;
        }
        if (nameSpace.isIsallowed()) {
            return true;
        }
        return 1 == nodeType ? (svgElem = nameSpace.getElementByTagName(nodeName)) != null : 2 == nodeType && (svgAttr = nameSpace.getAttributeByTagName(nodeName)) != null;
    }

    public int containsElement(String elementName) {
        if (this.myNameSpaceList == null) {
            return -1;
        }
        Iterator iter = this.myNameSpaceList.iterator();
        int indexCount = 0;
        SVGNameSpace svgNameSpace = null;
        while (iter.hasNext()) {
            svgNameSpace = (SVGNameSpace)iter.next();
            if (-1 != svgNameSpace.containsElement(elementName)) {
                return indexCount;
            }
            ++indexCount;
        }
        return -1;
    }

    public SVGElement fetchElementContainingAttribute(String attrName) {
        if (this.myNameSpaceList == null) {
            return null;
        }
        Iterator iter = this.myNameSpaceList.iterator();
        SVGNameSpace svgNameSpace = null;
        SVGElement svgElement = null;
        while (iter.hasNext()) {
            svgNameSpace = (SVGNameSpace)iter.next();
            svgElement = svgNameSpace.getElementContainingAttribute(attrName);
            if (svgElement == null) continue;
            return svgElement;
        }
        return null;
    }

    public SVGElement fetchElementByTagName(String elementName) {
        if (this.myNameSpaceList == null) {
            return null;
        }
        Iterator iter = this.myNameSpaceList.iterator();
        SVGNameSpace svgNameSpace = null;
        SVGElement svgElement = null;
        while (iter.hasNext()) {
            svgNameSpace = (SVGNameSpace)iter.next();
            svgElement = svgNameSpace.getElementByTagName(elementName);
            if (svgElement == null) continue;
            return svgElement;
        }
        return null;
    }

    public SVGAttribute fetchAttributeByTagName(String attrName) {
        if (this.myNameSpaceList == null) {
            return null;
        }
        Iterator iter = this.myNameSpaceList.iterator();
        SVGNameSpace svgNameSpace = null;
        SVGAttribute svgAttribute = null;
        boolean elemIndex = false;
        while (iter.hasNext()) {
            svgNameSpace = (SVGNameSpace)iter.next();
            svgAttribute = svgNameSpace.getAttributeByTagName(attrName);
            if (svgAttribute == null) continue;
            return svgAttribute;
        }
        return null;
    }

    public ArrayList getNSInPassThrough() {
        return (ArrayList)this.myNameSpaceList.clone();
    }

    private void loadPassThroughFile() {
        Element rootElement = this.myDocument.getDocumentElement();
        if (!rootElement.getTagName().equalsIgnoreCase("passThrough")) {
            return;
        }
        NodeList nameSpaceNodes = rootElement.getElementsByTagName("namespace");
        Element nameSpace = null;
        this.myNameSpaceList = new ArrayList();
        SVGNameSpace svgNameSpace = null;
        String nameSpaceName = null;
        Object url = null;
        Object urlContains = null;
        boolean isCompleteURI = false;
        String isWarningReqd = null;
        int i = 0;
        while (i < nameSpaceNodes.getLength()) {
            nameSpace = (Element)nameSpaceNodes.item(i);
            nameSpaceName = nameSpace.getAttribute("name");
            isWarningReqd = nameSpace.getAttribute("warn");
            NodeList childNodes = null;
            Node node = null;
            String isAllAllowed = null;
            if (nameSpaceName != null) {
                childNodes = rootElement.getElementsByTagName(nameSpaceName);
                node = childNodes.item(0);
                isAllAllowed = ((Element)node).getAttribute("allowAll");
                svgNameSpace = new SVGNameSpace(nameSpaceName);
                if (isWarningReqd != null && isWarningReqd.equalsIgnoreCase("true")) {
                    svgNameSpace.setWarn(true);
                }
                if (nameSpace.getAttribute("url") != null && nameSpace.getAttribute("url").length() > 0) {
                    svgNameSpace.setURI(true);
                    svgNameSpace.setMyUri(nameSpace.getAttribute("url"));
                } else if (nameSpace.getAttribute("urlcontains") != null && nameSpace.getAttribute("urlcontains").length() > 0) {
                    svgNameSpace.setMyUri(nameSpace.getAttribute("urlcontains"));
                }
                if (isAllAllowed != null && isAllAllowed.equals("true")) {
                    this.myNameSpaceList.add(svgNameSpace);
                    svgNameSpace.setIsallowed(true);
                } else {
                    ArrayList elementNodes = this.resolveElementsInNameSpaces((Element)node, nameSpaceName);
                    svgNameSpace.addElements(elementNodes);
                    this.myNameSpaceList.add(svgNameSpace);
                }
            }
            ++i;
        }
    }

    private ArrayList resolveElementsInNameSpaces(Element module, String moduleName) {
        Element element = null;
        String elementName = null;
        String isWarn = null;
        SVGElement svgElement = null;
        ArrayList<SVGElement> elementList = new ArrayList<SVGElement>();
        NodeList elementNodes = module.getElementsByTagName("element");
        int i = 0;
        while (i < elementNodes.getLength()) {
            ArrayList attrList;
            element = (Element)elementNodes.item(i);
            elementName = element.getAttribute("name");
            isWarn = element.getAttribute("warn");
            if (isWarn.equalsIgnoreCase("true")) {
                svgElement = new SVGElement(elementName, moduleName);
                svgElement.setWarn(true);
                attrList = this.resolveAttributesInElement(element, moduleName, elementName);
                if (attrList != null || attrList.size() > 0) {
                    svgElement.addAttributes(attrList);
                }
                elementList.add(svgElement);
            } else if (elementName != null) {
                svgElement = new SVGElement(elementName, moduleName);
                svgElement.setWarn(false);
                attrList = this.resolveAttributesInElement(element, moduleName, elementName);
                if (attrList != null || attrList.size() > 0) {
                    svgElement.addAttributes(attrList);
                }
                elementList.add(svgElement);
            }
            ++i;
        }
        return elementList;
    }

    private ArrayList resolveAttributesInElement(Element element, String moduleName, String elementName) {
        Attr attr = null;
        Element attribute = null;
        String attributeName = null;
        String attributeValue = null;
        SVGAttribute svgAttribute = null;
        ArrayList<SVGAttribute> attributesList = new ArrayList<SVGAttribute>();
        NodeList attributeNodes = element.getElementsByTagName("attribute");
        NamedNodeMap attrList = null;
        int i = 0;
        while (i < attributeNodes.getLength()) {
            attribute = (Element)attributeNodes.item(i);
            attrList = attribute.getAttributes();
            if (attrList != null) {
                SVGAttribute svgNameTag = null;
                SVGAttribute svgValueTag = null;
                ArrayList<SVGAttribute> tempList = new ArrayList<SVGAttribute>();
                int j = 0;
                while (j < attrList.getLength()) {
                    attr = (Attr)attrList.item(j);
                    attributeName = attr.getName();
                    attributeValue = attr.getValue();
                    svgAttribute = new SVGAttribute(attributeName, elementName, moduleName, null, attributeValue);
                    if (attributeName.equals("name")) {
                        svgNameTag = svgAttribute;
                    } else if (attributeName.equalsIgnoreCase("value")) {
                        svgValueTag = svgAttribute;
                    }
                    if (attributeName.equalsIgnoreCase("warn") && attributeValue.equalsIgnoreCase("true")) {
                        svgAttribute.setWarned(true);
                    }
                    tempList.add(svgAttribute);
                    ++j;
                }
                if (svgNameTag != null) {
                    String name = null;
                    String value = null;
                    boolean warn = false;
                    int k = 0;
                    while (k < tempList.size()) {
                        SVGAttribute temp = (SVGAttribute)tempList.get(k);
                        if (temp.getAttributeName().equalsIgnoreCase("name")) {
                            name = (String)temp.getAttributeValue();
                        }
                        if (temp.getAttributeName().equalsIgnoreCase("value")) {
                            value = (String)temp.getAttributeValue();
                        }
                        if (temp.getAttributeName().equalsIgnoreCase("warn")) {
                            warn = temp.isWarned();
                        }
                        ++k;
                    }
                    svgAttribute = new SVGAttribute(name, elementName, moduleName, null, value);
                    if (warn) {
                        svgAttribute.setWarned(warn);
                    }
                    attributesList.add(svgAttribute);
                }
            }
            ++i;
        }
        return attributesList;
    }

    private void printPassThroughFile(ArrayList nameSpaceNode) {
        int i = 0;
        while (i < nameSpaceNode.size()) {
            SVGNameSpace sVGNameSpace = (SVGNameSpace)nameSpaceNode.get(i);
            ++i;
        }
    }

    private void logEvents(long code, String[] desc) {
    }

    public static void main(String[] args) {
        try {
            NameSpaceAnalyzer bla = new NameSpaceAnalyzer(".\\config\\passThrough.xml", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isNameSpacePresent(String nsName) {
        SVGNameSpace svgNS = null;
        int i = 0;
        while (i < this.myNameSpaceList.size()) {
            svgNS = (SVGNameSpace)this.myNameSpaceList.get(i);
            if (svgNS.getnameSpaceName().equalsIgnoreCase(nsName) && svgNS.getMyUri() == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isWarningTag(String nsName, String nsURL, String nodeName, short nodeType) {
        SVGAttribute svgAttr;
        SVGElement svgElem;
        if (nsName == null && nsURL == null) {
            return false;
        }
        Hashtable ht = SVG2SVGTConverter.getNSInCurrentDoc();
        Enumeration enum1 = ht.keys();
        String reqdUrl = null;
        if (nsName != null) {
            block0: while (enum1.hasMoreElements()) {
                String url = (String)enum1.nextElement();
                ArrayList variables = (ArrayList)ht.get(url);
                Iterator iter = variables.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next()).equalsIgnoreCase(nsName)) continue;
                    reqdUrl = url;
                    continue block0;
                }
            }
        } else {
            reqdUrl = nsURL;
        }
        SVGNameSpace nameSpace = null;
        nameSpace = this.getSVGNameSpacesByURL(reqdUrl);
        if (nameSpace == null) {
            return false;
        }
        if (nameSpace.isWarn()) {
            return true;
        }
        return 1 == nodeType ? (svgElem = nameSpace.getElementByTagName(nodeName)) != null && svgElem.isWarned() : 2 == nodeType && (svgAttr = nameSpace.getAttributeByTagName(nodeName)) != null && svgAttr.isWarned();
    }
}

