/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.util.XMLFileParser;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NameSpaceRemover
implements ConversionConstants {
    private static ArrayList mySVGNameSpaces = new ArrayList();

    public static Document removeSVGNameSpaces(Document svgDoc) {
        if (svgDoc.getDocumentElement() == null) {
            return svgDoc;
        }
        mySVGNameSpaces.clear();
        NameSpaceRemover.readSVGNameSpaceDefs(svgDoc);
        Document svgDocNoNS = null;
        try {
            svgDocNoNS = XMLFileParser.getEmptyDocument();
        }
        catch (FactoryConfigurationError fcerror) {
            fcerror.printStackTrace();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        Element rootElem = svgDoc.getDocumentElement();
        String nodeName = NameSpaceRemover.getNSFreeName(rootElem.getNodeName());
        Element newElem = svgDocNoNS.createElement(nodeName);
        svgDocNoNS.appendChild(newElem);
        NameSpaceRemover.removeNSInDOMTree(rootElem, svgDoc, newElem, svgDocNoNS);
        return svgDocNoNS;
    }

    private static void readSVGNameSpaceDefs(Document svgDoc) {
        Element rootElem = svgDoc.getDocumentElement();
        NameSpaceRemover.readSVGNameSpacesUsed(rootElem);
    }

    private static void readSVGNameSpacesUsed(Node node) {
        NamedNodeMap attrList = null;
        String attrName = null;
        String attrValue = null;
        if (node.hasAttributes()) {
            attrList = node.getAttributes();
            int i = 0;
            while (i < attrList.getLength()) {
                Attr attr = (Attr)attrList.item(i);
                attrName = attr.getNodeName();
                attrValue = attr.getNodeValue();
                if (-1 != attrName.indexOf("xmlns") && attrValue.equalsIgnoreCase("http://www.w3.org/2000/svg")) {
                    int index = attrName.indexOf(":");
                    String svgNameSpace = null;
                    if (-1 != index) {
                        svgNameSpace = attrName.substring(index + 1, attrName.length());
                        mySVGNameSpaces.add(svgNameSpace);
                    }
                }
                ++i;
            }
        }
        if (node.hasChildNodes()) {
            NodeList childNodeList = node.getChildNodes();
            Node childNode = null;
            int i = 0;
            while (i < childNodeList.getLength()) {
                childNode = childNodeList.item(i);
                if (1 == childNode.getNodeType()) {
                    NameSpaceRemover.readSVGNameSpacesUsed(childNode);
                }
                ++i;
            }
        }
    }

    private static ArrayList getSVGNameSpaceDefs() {
        return mySVGNameSpaces;
    }

    private static void removeNSInDOMTree(Node node, Document svgDoc, Node noNSNode, Document svgDocNoNS) {
        NamedNodeMap attrList = null;
        if (node.hasAttributes()) {
            attrList = node.getAttributes();
            String attrName = null;
            String attrValue = null;
            Node attrNode = null;
            Attr newAttr = null;
            int i = 0;
            while (i < attrList.getLength()) {
                attrNode = attrList.item(i);
                attrName = NameSpaceRemover.getNSFreeName(attrNode.getNodeName());
                attrValue = attrNode.getNodeValue();
                newAttr = svgDocNoNS.createAttribute(attrName);
                newAttr.setNodeValue(attrValue);
                ((Element)noNSNode).setAttributeNode(newAttr);
                ++i;
            }
        }
        NodeList childNodeList = null;
        Node childNode = null;
        if (node.hasChildNodes()) {
            childNodeList = node.getChildNodes();
            int i = 0;
            while (i < childNodeList.getLength()) {
                childNode = childNodeList.item(i);
                if (1 != childNode.getNodeType()) {
                    String textValue;
                    if (3 == childNode.getNodeType() && (textValue = childNode.getNodeValue()) != null && textValue.trim().length() > 0) {
                        Text textNode = svgDocNoNS.createTextNode(textValue);
                        noNSNode.appendChild(textNode);
                    }
                } else {
                    String nodeName = NameSpaceRemover.getNSFreeName(childNode.getNodeName());
                    Element newElem = svgDocNoNS.createElement(nodeName);
                    noNSNode.appendChild(newElem);
                    NameSpaceRemover.removeNSInDOMTree(childNode, svgDoc, newElem, svgDocNoNS);
                }
                ++i;
            }
        }
    }

    private static String getNSFreeName(String nodeName) {
        for (String nsName : mySVGNameSpaces) {
            if (!nodeName.startsWith(String.valueOf(nsName) + ":")) continue;
            return nodeName.substring(nsName.length() + 1, nodeName.length());
        }
        return nodeName;
    }

    public static void main(String[] args) {
        try {
            Document svgtDoc = XMLFileParser.parseFile("C:\\SVG\\samples\\Mine.svg", false);
            NameSpaceRemover.readSVGNameSpaceDefs(svgtDoc);
            NameSpaceRemover.removeSVGNameSpaces(svgtDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

