/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGModule;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.gui.SVGDTDAnalyzer;
import com.nokia.svg2svgt.gui.ext.JMultiSelectionComboBox;
import com.nokia.svg2svgt.gui.ext.event.SelectionEvent;
import com.nokia.svg2svgt.gui.ext.event.SelectionListener;
import com.nokia.svg2svgt.localiser.Localiser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AddDialog
extends JDialog
implements ActionListener,
ConversionConstants {
    private JPanel nameSpacePanel = new JPanel();
    private TitledBorder titledBorder2;
    private JLabel nameSpaceNameLabel = new JLabel();
    private JComboBox nameSpaceCombo = new JComboBox();
    private JLabel urlLabel = new JLabel();
    private JComboBox urlCombo = new JComboBox();
    private JRadioButton equalsRadioButton = new JRadioButton();
    private JRadioButton containsRadioButton = new JRadioButton();
    private ButtonGroup group = new ButtonGroup();
    private JCheckBox allowAll = new JCheckBox();
    private JPanel elementPanel = new JPanel();
    private TitledBorder titledBorder4;
    private JLabel moduleNameLabel = new JLabel();
    private JComboBox moduleCombo = new JComboBox();
    private JLabel elementnameLabel = new JLabel();
    private JPanel attributePanel = new JPanel();
    private TitledBorder titledBorder6;
    private JLabel attributNameLabel = new JLabel();
    private JLabel attributeValueLabel = new JLabel();
    private JTextField valueTextField = new JTextField();
    private JCheckBox warnCheckBox = new JCheckBox();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton resetButton = new JButton();
    private JMultiSelectionComboBox elementCombo = null;
    private JMultiSelectionComboBox attributeCombo = null;
    private SVGDTDAnalyzer myAnaliser = null;
    private ArrayList myModules = null;
    private ArrayList myNameSpaces = null;
    private Vector myTableInfo = null;
    private Frame frame = null;
    private SVGNameSpace desiredNameSpace = null;
    Vector attr = null;
    Localiser myLocaliser = null;

    public AddDialog(Frame frame, Localiser localiser, String title) {
        super(frame, title, true);
        this.frame = frame;
        this.myLocaliser = localiser;
        try {
            this.myAnaliser = new SVGDTDAnalyzer(this.myLocaliser.getText("SVG_XML"), null);
            this.myModules = this.myAnaliser.getSVGModules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.createDialog();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createDialog() throws Exception {
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.myLocaliser.getText("Add.NameSpacePanel.title"));
        this.titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.myLocaliser.getText("Add.Element.title"));
        this.titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.myLocaliser.getText("Add.Attribute.title"));
        this.getContentPane().setLayout(null);
        this.nameSpacePanel.setLayout(null);
        this.nameSpacePanel.setBorder(this.titledBorder2);
        this.nameSpacePanel.setBounds(new Rectangle(10, 10, 300, 144));
        this.nameSpaceNameLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.NameLabel"));
        this.nameSpaceNameLabel.setBounds(22, 24, 50, 24);
        this.nameSpaceCombo.setEditable(true);
        this.nameSpaceCombo.addActionListener(this);
        this.nameSpaceCombo.setBounds(78, 24, 200, 24);
        this.nameSpaceCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String svg = null;
                if (AddDialog.this.nameSpaceCombo.getSelectedItem() instanceof String) {
                    svg = (String)AddDialog.this.nameSpaceCombo.getSelectedItem();
                } else if (AddDialog.this.nameSpaceCombo.getSelectedItem() instanceof SVGNameSpace) {
                    SVGNameSpace svg1 = (SVGNameSpace)AddDialog.this.nameSpaceCombo.getSelectedItem();
                    svg = svg1.getnameSpaceName();
                }
                if (svg == null) {
                    return;
                }
                if (svg.equals("svg")) {
                    AddDialog.this.moduleCombo.setEnabled(true);
                } else {
                    AddDialog.this.moduleCombo.setEnabled(false);
                }
            }
        });
        this.urlLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.UrlLabel"));
        this.urlLabel.setBounds(new Rectangle(22, 60, 50, 24));
        this.urlCombo.setEditable(true);
        this.urlCombo.setBounds(new Rectangle(78, 60, 200, 24));
        this.equalsRadioButton.setText(this.myLocaliser.getText("Add.nameSpaceName.equalsRadioButton"));
        this.equalsRadioButton.setBounds(new Rectangle(76, 84, 80, 24));
        this.containsRadioButton.setText(this.myLocaliser.getText("Add.nameSpaceName.ContainsRadioButton"));
        this.containsRadioButton.setBounds(new Rectangle(156, 84, 80, 24));
        this.group.add(this.equalsRadioButton);
        this.group.add(this.containsRadioButton);
        this.allowAll.setText(this.myLocaliser.getText("Add.nameSpaceName.AllowAll"));
        this.allowAll.setBounds(20, 108, 80, 24);
        this.allowAll.setSelected(true);
        this.elementPanel.setBorder(this.titledBorder4);
        this.elementPanel.setBounds(new Rectangle(10, 160, 300, 192));
        this.elementPanel.setLayout(null);
        this.moduleNameLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.ModuleNameLabel"));
        this.moduleNameLabel.setBounds(22, 12, 50, 24);
        this.moduleCombo.setEditable(true);
        this.moduleCombo.setBounds(78, 12, 200, 24);
        this.moduleCombo.addActionListener(this);
        this.elementnameLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.ElementNameLabel"));
        this.elementnameLabel.setBounds(new Rectangle(22, 48, 50, 24));
        this.elementCombo = new JMultiSelectionComboBox();
        this.elementCombo.setDelimiter(",");
        this.elementCombo.setBounds(78, 48, 200, 24);
        this.elementPanel.add((Component)this.elementCombo, null);
        this.attributePanel.setBorder(this.titledBorder6);
        this.attributePanel.setBounds(new Rectangle(10, 84, 280, 96));
        this.attributePanel.setLayout(null);
        this.attributNameLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.AttributeNameLabel"));
        this.attributNameLabel.setBounds(new Rectangle(12, 24, 50, 24));
        this.attributeCombo = new JMultiSelectionComboBox();
        this.attributeCombo.setBounds(new Rectangle(68, 24, 200, 24));
        this.attributePanel.add(this.attributeCombo);
        this.attributeValueLabel.setText(this.myLocaliser.getText("Add.nameSpaceName.AttributeValueLabel"));
        this.attributeValueLabel.setBounds(new Rectangle(12, 60, 50, 24));
        this.valueTextField.setText("");
        this.valueTextField.setBounds(new Rectangle(68, 60, 200, 24));
        this.warnCheckBox.setText(this.myLocaliser.getText("Add.nameSpaceName.warnCheckBox"));
        this.warnCheckBox.setBounds(10, 352, 80, 24);
        this.okButton.setBounds(new Rectangle(120, 380, 70, 24));
        this.okButton.setText(this.myLocaliser.getText("Add.nameSpaceName.oKButton"));
        this.okButton.addActionListener(this);
        this.cancelButton.setBounds(new Rectangle(195, 380, 70, 24));
        this.cancelButton.setText(this.myLocaliser.getText("Add.nameSpaceName.CancelButton"));
        this.cancelButton.addActionListener(this);
        this.resetButton.setBounds(new Rectangle(45, 380, 70, 24));
        this.resetButton.setText(this.myLocaliser.getText("Add.nameSpaceName.resetButton"));
        this.resetButton.addActionListener(this);
        this.nameSpacePanel.add((Component)this.nameSpaceNameLabel, null);
        this.nameSpacePanel.add((Component)this.nameSpaceCombo, null);
        this.nameSpacePanel.add((Component)this.urlLabel, null);
        this.nameSpacePanel.add((Component)this.urlCombo, null);
        this.nameSpacePanel.add((Component)this.containsRadioButton, null);
        this.nameSpacePanel.add((Component)this.equalsRadioButton, null);
        this.nameSpacePanel.add((Component)this.allowAll, null);
        this.attributePanel.add((Component)this.attributeValueLabel, null);
        this.attributePanel.add((Component)this.valueTextField, null);
        this.attributePanel.add((Component)this.attributNameLabel, null);
        this.elementPanel.add((Component)this.moduleNameLabel, null);
        this.elementPanel.add((Component)this.moduleCombo, null);
        this.elementPanel.add((Component)this.elementnameLabel, null);
        this.elementPanel.add((Component)this.attributePanel, null);
        this.getContentPane().add((Component)this.nameSpacePanel, null);
        this.getContentPane().add((Component)this.elementPanel, null);
        this.getContentPane().add((Component)this.resetButton, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.warnCheckBox, null);
        this.allowAll.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AddDialog.this.allowAll.isSelected()) {
                    AddDialog.this.moduleCombo.setEnabled(false);
                    AddDialog.this.elementCombo.setEnabled(false);
                    AddDialog.this.attributeCombo.setEnabled(false);
                    AddDialog.this.valueTextField.setEnabled(false);
                } else {
                    AddDialog.this.moduleCombo.setEnabled(true);
                    AddDialog.this.elementCombo.setEnabled(true);
                    AddDialog.this.attributeCombo.setEnabled(true);
                    AddDialog.this.valueTextField.setEnabled(true);
                }
            }
        });
        this.elementCombo.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                if (e.getSource() instanceof JMultiSelectionComboBox) {
                    JMultiSelectionComboBox combo = (JMultiSelectionComboBox)e.getSource();
                    if (combo.getSelectedIndices().length > 1) {
                        AddDialog.this.attributeCombo.setEnabled(false);
                        AddDialog.this.valueTextField.setEditable(false);
                    } else {
                        AddDialog.this.attributeCombo.setEnabled(true);
                        AddDialog.this.valueTextField.setBackground(Color.WHITE);
                        AddDialog.this.valueTextField.setEditable(true);
                        if (combo.getSelectedValue() != null && combo.getSelectedValue() instanceof SVGElement) {
                            SVGElement element = (SVGElement)combo.getSelectedValue();
                            AddDialog.this.attributeCombo.removeAll();
                            ArrayList attributes = element.getElementAttributes();
                            int i = 0;
                            while (i < attributes.size()) {
                                SVGAttribute attribute = (SVGAttribute)element.getElementAttributes().get(i);
                                AddDialog.this.attributeCombo.addItem(attribute);
                                ++i;
                            }
                            AddDialog.this.attributeCombo.setSelectedIndex(0);
                        }
                    }
                }
            }

            public void selectionOver(SelectionEvent e) {
            }
        });
        this.attributeCombo.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                if (e.getSource() instanceof JMultiSelectionComboBox) {
                    JMultiSelectionComboBox combo = (JMultiSelectionComboBox)e.getSource();
                    if (AddDialog.this.attributeCombo.getSelectedIndices().length > 1) {
                        AddDialog.this.valueTextField.setEnabled(false);
                    } else {
                        AddDialog.this.valueTextField.setEnabled(true);
                    }
                    if (AddDialog.this.attributeCombo.getSelectedValue() != null && AddDialog.this.attributeCombo.getSelectedValue() instanceof SVGAttribute) {
                        SVGAttribute attribute = (SVGAttribute)AddDialog.this.attributeCombo.getSelectedValue();
                        if (attribute.isWarned()) {
                            AddDialog.this.warnCheckBox.setSelected(true);
                        }
                        AddDialog.this.valueTextField.setText((String)attribute.getAttributeValue());
                    }
                }
            }

            public void selectionOver(SelectionEvent e) {
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        block18: {
            block21: {
                block22: {
                    block20: {
                        block19: {
                            block17: {
                                if (!e.getSource().equals(this.okButton)) break block17;
                                if (this.nameSpaceCombo.getSelectedItem() instanceof String && ((String)this.nameSpaceCombo.getSelectedItem()).trim().length() == 0) {
                                    JOptionPane.showMessageDialog(this.frame, "Select a Namespace name ");
                                } else if (this.urlCombo.getSelectedItem() instanceof String && ((String)this.urlCombo.getSelectedItem()).trim().length() == 0) {
                                    JOptionPane.showMessageDialog(this.frame, "Select a Namespace url ");
                                } else {
                                    this.checkBeforeOk();
                                    this.dispose();
                                }
                                break block18;
                            }
                            if (!e.getSource().equals(this.cancelButton)) break block19;
                            this.dispose();
                            break block18;
                        }
                        if (!e.getSource().equals(this.resetButton)) break block20;
                        this.reset();
                        break block18;
                    }
                    if (!e.getSource().equals(this.moduleCombo)) break block21;
                    if (this.moduleCombo.getSelectedIndex() == 0) break block22;
                    SVGModule selectedModule = (SVGModule)this.moduleCombo.getSelectedItem();
                    if (selectedModule == null) {
                        return;
                    }
                    int i = 0;
                    while (i < this.myModules.size()) {
                        SVGModule module = (SVGModule)this.myModules.get(i);
                        if (module.getModuleName().equalsIgnoreCase(selectedModule.toString()) && this.moduleCombo.getSelectedIndex() > 0) {
                            ArrayList allElements = module.getModuleElements();
                            this.elementCombo.removeAll();
                            int j = 0;
                            while (j < allElements.size()) {
                                SVGElement element = (SVGElement)allElements.get(j);
                                this.elementCombo.addItem(element);
                                ++j;
                            }
                            this.elementCombo.setSelectedIndex(0);
                        }
                        ++i;
                    }
                    break block18;
                }
                if (this.moduleCombo.getSelectedIndex() != 0) break block18;
                this.elementCombo.removeAll();
                int i = 0;
                while (i < this.myModules.size()) {
                    SVGModule module = (SVGModule)this.myModules.get(i);
                    ArrayList listOfEle = module.getModuleElements();
                    int j = 0;
                    while (j < listOfEle.size()) {
                        this.elementCombo.addItem((SVGElement)listOfEle.get(j));
                        ++j;
                    }
                    this.elementCombo.setSelectedIndex(0);
                    ++i;
                }
                break block18;
            }
            if (e.getSource().equals(this.nameSpaceCombo)) {
                int i = 0;
                while (i < this.myNameSpaces.size()) {
                    SVGNameSpace nameSpaces = (SVGNameSpace)this.myNameSpaces.get(i);
                    if (nameSpaces.isURI()) {
                        this.equalsRadioButton.setSelected(true);
                    }
                    if (nameSpaces.isWarn()) {
                        this.warnCheckBox.setSelected(true);
                    } else {
                        this.warnCheckBox.setSelected(false);
                    }
                    if (nameSpaces.isIsallowed()) {
                        this.allowAll.setSelected(true);
                    } else {
                        this.allowAll.setSelected(false);
                    }
                    ++i;
                }
            }
        }
    }

    private void checkBeforeOk() {
        SVGNameSpace nameSpace = null;
        nameSpace = this.nameSpaceCombo.getSelectedItem() instanceof String ? new SVGNameSpace((String)this.nameSpaceCombo.getSelectedItem()) : new SVGNameSpace(this.nameSpaceCombo.getSelectedItem().toString());
        nameSpace.setMyUri((String)this.urlCombo.getSelectedItem());
        if (this.equalsRadioButton.isSelected()) {
            nameSpace.setURI(true);
        }
        if (this.allowAll.isSelected()) {
            nameSpace.setIsallowed(true);
            if (this.warnCheckBox.isSelected()) {
                nameSpace.setWarn(true);
            } else {
                nameSpace.setWarn(false);
            }
        } else if (this.elementCombo.getSelectedIndices().length > 1) {
            Object[] elements = this.elementCombo.getSelectedValues();
            int i = 0;
            while (i < elements.length) {
                SVGElement elem = (SVGElement)elements[i];
                SVGElement element = new SVGElement(elem.getElementName(), nameSpace.getnameSpaceName());
                ArrayList attrs = (ArrayList)elem.getElementAttributes().clone();
                int k = 0;
                while (k < attrs.size()) {
                    element.addAttribute((SVGAttribute)attrs.get(k));
                    ++k;
                }
                if (this.warnCheckBox.isSelected()) {
                    element.setWarn(true);
                } else {
                    element.setWarn(false);
                }
                nameSpace.addElement(element);
                ++i;
            }
        } else if (this.attributeCombo.getSelectedIndices().length > 1) {
            SVGElement element = new SVGElement(this.elementCombo.getSelectedValue().toString(), this.nameSpaceCombo.getSelectedItem().toString());
            Object[] attributes = this.attributeCombo.getSelectedValues();
            int k = 0;
            while (k < this.attributeCombo.getSelectedIndices().length) {
                SVGAttribute attribute = new SVGAttribute(attributes[k].toString(), this.elementCombo.getSelectedValue().toString(), null, null, this.valueTextField.getText());
                if (this.warnCheckBox.isSelected()) {
                    attribute.setWarned(true);
                }
                element.addAttribute(attribute);
                ++k;
            }
            nameSpace.addElement(element);
        } else if (-1 != this.elementCombo.getSelectedIndex() && -1 != this.attributeCombo.getSelectedIndex()) {
            SVGElement element = new SVGElement(this.elementCombo.getSelectedValue().toString(), this.nameSpaceCombo.getSelectedItem().toString());
            if (this.attributeCombo.getSelectedValue() != null) {
                SVGAttribute attribute = new SVGAttribute(this.attributeCombo.getSelectedValue().toString(), this.elementCombo.getSelectedValue().toString(), null, null, this.valueTextField.getText());
                if (this.warnCheckBox.isSelected()) {
                    attribute.setWarned(true);
                } else {
                    attribute.setWarned(false);
                }
                element.addAttribute(attribute);
            } else if (this.warnCheckBox.isSelected()) {
                element.setWarn(true);
            }
            nameSpace.addElement(element);
        } else if (this.elementCombo.getSelectedValue() instanceof String || this.attributeCombo.getSelectedValue() instanceof String) {
            SVGElement element = new SVGElement((String)this.elementCombo.getSelectedValue(), this.nameSpaceCombo.getSelectedItem().toString());
            if (this.attributeCombo.getSelectedValue() != null) {
                SVGAttribute attribute = new SVGAttribute((String)this.attributeCombo.getSelectedValue(), (String)this.elementCombo.getSelectedValue(), null, null, this.valueTextField.getText());
                if (this.warnCheckBox.isSelected()) {
                    attribute.setWarned(true);
                }
                element.addAttribute(attribute);
            } else if (this.warnCheckBox.isSelected()) {
                element.setWarn(true);
            }
            nameSpace.addElement(element);
        }
        this.setDesiredNameSpace(nameSpace);
        this.updateNSList(nameSpace);
    }

    public void populateDialog() {
        if (this.myNameSpaces == null) {
            return;
        }
        try {
            this.nameSpaceCombo.removeAllItems();
            this.urlCombo.removeAllItems();
        }
        catch (Exception e) {
            System.out.println("Error  " + e.getStackTrace());
        }
        int i = 0;
        while (i < this.myNameSpaces.size()) {
            SVGNameSpace nameSpace = (SVGNameSpace)this.myNameSpaces.get(i);
            this.nameSpaceCombo.addItem(nameSpace);
            this.urlCombo.addItem(nameSpace.getMyUri());
            if (nameSpace.isURI()) {
                this.containsRadioButton.setSelected(false);
                this.equalsRadioButton.setSelected(true);
            } else {
                this.equalsRadioButton.setSelected(false);
                this.containsRadioButton.setSelected(true);
            }
            if (nameSpace.isIsallowed()) {
                this.allowAll.setSelected(true);
            } else {
                this.allowAll.setSelected(false);
            }
            if (nameSpace.isWarn()) {
                this.warnCheckBox.setSelected(true);
            } else {
                this.warnCheckBox.setSelected(false);
            }
            ++i;
        }
        this.moduleCombo.removeAllItems();
        SVGModule module1 = new SVGModule("--All--");
        this.moduleCombo.addItem(module1);
        int i2 = 0;
        while (i2 < this.myModules.size()) {
            SVGModule module = (SVGModule)this.myModules.get(i2);
            this.moduleCombo.addItem(module);
            ++i2;
        }
    }

    public void reset() {
        this.moduleCombo.setSelectedIndex(0);
        this.allowAll.setSelected(false);
        this.warnCheckBox.setSelected(false);
        this.valueTextField.setText(" ");
    }

    public void updateNSList(SVGNameSpace nameSpace) {
        if (this.myNameSpaces != null) {
            if (this.myNameSpaces.size() == 0) {
                this.myNameSpaces.add(nameSpace);
            }
            boolean flag = false;
            int i = 0;
            while (i < this.myNameSpaces.size()) {
                SVGNameSpace name = (SVGNameSpace)this.myNameSpaces.get(i);
                if (name.getnameSpaceName().equalsIgnoreCase(nameSpace.getnameSpaceName())) {
                    flag = true;
                    break;
                }
                ++i;
            }
            if (!flag) {
                this.myNameSpaces.add(nameSpace);
            }
        }
        if (this.myNameSpaces != null) {
            int i = 0;
            while (i < this.myNameSpaces.size()) {
                ArrayList elements;
                SVGNameSpace name = (SVGNameSpace)this.myNameSpaces.get(i);
                if (name.getnameSpaceName().equalsIgnoreCase(nameSpace.getnameSpaceName()) && (elements = nameSpace.getnameSpaceElements()) != null) {
                    SVGElement element = null;
                    i = 0;
                    while (i < elements.size()) {
                        element = (SVGElement)elements.get(i);
                        if (element != null) {
                            if (name.getElementByTagName(element.getElementName()) != null) {
                                SVGElement elem = name.getElementByTagName(element.getElementName());
                                ArrayList attributes = element.getElementAttributes();
                                if (attributes != null) {
                                    int k = 0;
                                    while (k < attributes.size()) {
                                        SVGAttribute attribute = (SVGAttribute)attributes.get(k);
                                        if (elem.getAttributeByTagName(attribute.getAttributeName()) != null) {
                                            SVGAttribute tempAttr = elem.getAttributeByTagName(attribute.getAttributeName());
                                            tempAttr.setWarned(attribute.isWarned());
                                            tempAttr.setMyValue(this.valueTextField.getText());
                                        } else {
                                            SVGElement ele = name.getElementByTagName(element.getElementName());
                                            ele.addAttribute(attribute);
                                        }
                                        ++k;
                                    }
                                }
                            } else {
                                name.addElement(element);
                            }
                        }
                        ++i;
                    }
                }
                ++i;
            }
        }
    }

    public void populateTableInfo(Vector tableInfo) {
        SVGNameSpace nameSpace = (SVGNameSpace)tableInfo.get(0);
        this.nameSpaceCombo.setSelectedItem(nameSpace);
        if (nameSpace.isURI()) {
            this.equalsRadioButton.setSelected(true);
        } else {
            this.equalsRadioButton.setSelected(false);
        }
        if (nameSpace.isWarn()) {
            this.warnCheckBox.setSelected(true);
        } else {
            this.warnCheckBox.setSelected(false);
        }
        if (nameSpace.isIsallowed()) {
            this.allowAll.setSelected(true);
        } else {
            this.allowAll.setSelected(false);
        }
        this.elementCombo.removeAll();
        if (tableInfo.get(1) instanceof SVGElement) {
            SVGElement element = (SVGElement)tableInfo.get(1);
            int i = 0;
            if (i < this.myModules.size()) {
                SVGModule module = (SVGModule)this.myModules.get(i);
                if (module.getElementByTagName(element.getElementName()) != null) {
                    this.elementCombo.addItem(module.getElementByTagName(element.getElementName()));
                    this.elementCombo.setSelectedIndex(0);
                    if (element.isWarned()) {
                        this.warnCheckBox.setSelected(true);
                    } else {
                        this.warnCheckBox.setSelected(false);
                    }
                } else {
                    this.elementCombo.addItem(element);
                    this.elementCombo.setSelectedIndex(0);
                }
            }
            this.attributeCombo.removeAll();
            if (tableInfo.get(2) instanceof SVGAttribute) {
                SVGAttribute attribute = (SVGAttribute)tableInfo.get(2);
                if (attribute.isWarned()) {
                    this.warnCheckBox.setSelected(true);
                } else {
                    this.warnCheckBox.setSelected(false);
                }
                this.attributeCombo.addItem(element.getAttributeByTagName(attribute.getAttributeName()));
                this.attributeCombo.setSelectedIndex(0);
                this.valueTextField.setText((String)attribute.getAttributeValue());
            }
        }
    }

    public void setMyNameSpaces(ArrayList list) {
        this.myNameSpaces = list;
    }

    public ArrayList getMyNameSpaces() {
        return this.myNameSpaces;
    }

    public SVGNameSpace getDesiredNameSpace() {
        return this.desiredNameSpace;
    }

    public void setDesiredNameSpace(SVGNameSpace spaces) {
        this.desiredNameSpace = spaces;
    }
}

