/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.gui.AddDialog;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.localiser.Localiser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class PassThroughPanel
extends JPanel
implements ActionListener,
ConversionConstants {
    private SVGTConverterController myController = null;
    private JPanel tablePanel;
    private CustomTableModel dtm;
    private JTable nameSpaceTable;
    private TitledBorder titledBorder2;
    private JScrollPane scroll;
    private JButton addButton;
    private JButton removeButton;
    private JButton editButton;
    private JPanel buttonPanel;
    private Vector rowData;
    private Vector columns;
    private Vector rows;
    private ArrayList myNameSpaces = null;
    Localiser myLocaliser = null;
    AddDialog addDialog = null;
    private boolean changed = false;
    int selectedRow = 0;
    private Frame myMainFrame = null;

    public PassThroughPanel(SVGTConverterController parent, Localiser localiser, Frame frame) {
        this.myMainFrame = frame;
        this.myController = parent;
        this.myLocaliser = localiser;
        try {
            this.addDialog = new AddDialog(frame, this.myLocaliser, this.myLocaliser.getText("Add.title"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            this.createPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPanel() throws Exception {
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), this.myLocaliser.getText("PassThrough.Title"));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setBorder(this.titledBorder2);
        this.columns = new Vector();
        this.columns.add(this.myLocaliser.getText("PassThrough.table.column0"));
        this.columns.add(this.myLocaliser.getText("PassThrough.table.column1"));
        this.columns.add(this.myLocaliser.getText("PassThrough.table.column2"));
        this.columns.add(this.myLocaliser.getText("PassThrough.table.column3"));
        this.dtm = new CustomTableModel();
        this.dtm.setDataVector(null, this.columns);
        this.nameSpaceTable = new JTable(this.dtm);
        this.nameSpaceTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nameSpaceTable.getTableHeader().setReorderingAllowed(false);
        this.scroll = new JScrollPane();
        this.scroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scroll.getViewport().add(this.nameSpaceTable);
        this.tablePanel.add(this.scroll);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setPreferredSize(new Dimension(397, 36));
        this.addButton = new JButton(this.myLocaliser.getText("PassThrough.Addbutton"));
        this.addButton.setPreferredSize(new Dimension(80, 24));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(this.myLocaliser.getText("PassThrough.Removebutton"));
        this.removeButton.setPreferredSize(new Dimension(80, 24));
        this.removeButton.addActionListener(this);
        this.editButton = new JButton(this.myLocaliser.getText("PassThrough.Editbutton"));
        this.editButton.setPreferredSize(new Dimension(80, 24));
        this.editButton.addActionListener(this);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.nameSpaceTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    PassThroughPanel.this.setChanged(true);
                    PassThroughPanel.this.edit();
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.tablePanel);
        this.add(Box.createVerticalGlue());
        this.add(this.buttonPanel);
        this.add(Box.createVerticalGlue());
        this.setPreferredSize(new Dimension(400, 291));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nameSpaceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (PassThroughPanel.this.nameSpaceTable.getRowCount() == 0 || PassThroughPanel.this.nameSpaceTable.getSelectedRows().length == 0) {
                    PassThroughPanel.this.removeButton.setEnabled(false);
                    PassThroughPanel.this.editButton.setEnabled(false);
                } else if (PassThroughPanel.this.nameSpaceTable.getSelectedRows().length > 1) {
                    PassThroughPanel.this.editButton.setEnabled(false);
                    PassThroughPanel.this.removeButton.setEnabled(true);
                } else {
                    PassThroughPanel.this.editButton.setEnabled(true);
                    PassThroughPanel.this.removeButton.setEnabled(true);
                }
            }
        });
        this.nameSpaceTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    PassThroughPanel.this.setChanged(true);
                    int[] i = PassThroughPanel.this.nameSpaceTable.getSelectedRows();
                    Vector temp = new Vector();
                    if (i != null) {
                        Vector dataVector = PassThroughPanel.this.dtm.getDataVector();
                        int j = 0;
                        while (j < i.length) {
                            Vector<Object> rowData = new Vector<Object>();
                            try {
                                rowData.add(PassThroughPanel.this.dtm.getValueAt(i[j] - j, 0));
                                rowData.add(PassThroughPanel.this.dtm.getValueAt(i[j] - j, 1));
                                rowData.add(PassThroughPanel.this.dtm.getValueAt(i[j] - j, 2));
                                rowData.add(PassThroughPanel.this.dtm.getValueAt(i[j] - j, 3));
                                temp.add(rowData);
                                PassThroughPanel.this.dtm.removeRow(i[j] - j);
                            }
                            catch (Exception e1) {
                                System.out.println("Array Index Out Of Bounds :" + e1.getMessage());
                            }
                            ++j;
                        }
                    }
                    PassThroughPanel.this.removeFromList(temp);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals(this.myLocaliser.getText("PassThrough.Addbutton"))) {
            this.setChanged(true);
            this.addDialog.setMyNameSpaces(this.myNameSpaces);
            this.addDialog.populateDialog();
            this.addDialog.reset();
            this.addDialog.setTitle(this.myLocaliser.getText("Add.title"));
            this.addDialog.setSize(330, 434);
            this.addDialog.setResizable(false);
            this.addDialog.setLocation(300, 140);
            this.addDialog.setVisible(true);
            this.addDialog.setModal(true);
            this.addDialog.setDefaultCloseOperation(2);
            this.setMyNameSpaces(this.addDialog.getMyNameSpaces());
            this.populateTable();
        } else if (ae.getActionCommand().equals(this.myLocaliser.getText("PassThrough.Removebutton"))) {
            this.setChanged(true);
            int[] i = this.nameSpaceTable.getSelectedRows();
            int selRow = i[0];
            Vector temp = new Vector();
            if (i != null) {
                Vector dataVector = this.dtm.getDataVector();
                int j = 0;
                while (j < i.length) {
                    Vector<Object> rowData = new Vector<Object>();
                    try {
                        rowData.add(this.dtm.getValueAt(i[j] - j, 0));
                        rowData.add(this.dtm.getValueAt(i[j] - j, 1));
                        rowData.add(this.dtm.getValueAt(i[j] - j, 2));
                        rowData.add(this.dtm.getValueAt(i[j] - j, 3));
                        temp.add(rowData);
                        this.dtm.removeRow(i[j] - j);
                    }
                    catch (Exception e) {
                        System.out.println("Array Index Out Of Bounds :" + e.getMessage());
                    }
                    ++j;
                }
            }
            this.removeFromList(temp);
            this.nameSpaceTable.getSelectionModel().setSelectionMode(0);
            if (-1 != selRow - 1) {
                this.nameSpaceTable.getSelectionModel().setLeadSelectionIndex(selRow - 1);
            } else {
                this.nameSpaceTable.getSelectionModel().setLeadSelectionIndex(0);
            }
            this.nameSpaceTable.getSelectionModel().setSelectionMode(2);
        } else if (ae.getActionCommand().equals(this.myLocaliser.getText("PassThrough.Editbutton"))) {
            this.setChanged(true);
            this.edit();
        }
    }

    private void edit() {
        this.selectedRow = this.nameSpaceTable.getSelectedRow();
        if (-1 != this.selectedRow) {
            Vector<Object> tableInfo = new Vector<Object>();
            tableInfo.add((SVGNameSpace)this.dtm.getValueAt(this.selectedRow, 0));
            tableInfo.add(this.dtm.getValueAt(this.selectedRow, 1));
            tableInfo.add(this.dtm.getValueAt(this.selectedRow, 2));
            tableInfo.add(this.dtm.getValueAt(this.selectedRow, 3));
            this.addDialog.setMyNameSpaces(this.myNameSpaces);
            this.addDialog.populateDialog();
            this.addDialog.reset();
            this.addDialog.populateTableInfo(tableInfo);
            this.addDialog.setTitle(this.myLocaliser.getText("Edit.title"));
            this.addDialog.setSize(330, 434);
            this.addDialog.setResizable(false);
            this.addDialog.setLocation(300, 140);
            this.addDialog.setVisible(true);
            this.addDialog.setModal(true);
            this.addDialog.setDefaultCloseOperation(2);
            this.setMyNameSpaces(this.addDialog.getMyNameSpaces());
            this.populateTable();
        }
    }

    private void removeFromList(Vector temp) {
        int i = 0;
        while (i < temp.size()) {
            ArrayList elements;
            Vector temp2 = new Vector();
            temp2 = (Vector)temp.get(i);
            if (this.myNameSpaces == null || temp2 == null) {
                return;
            }
            SVGNameSpace svgNamespace = (SVGNameSpace)temp2.get(0);
            SVGElement svgElement = null;
            if (temp2.get(1) != null && temp2.get(1) instanceof SVGElement) {
                svgElement = (SVGElement)temp2.get(1);
            }
            SVGAttribute svgAttribute = null;
            if (temp2.get(2) != null && temp2.get(2) instanceof SVGAttribute) {
                svgAttribute = (SVGAttribute)temp2.get(2);
            }
            String value = (String)temp2.get(3);
            SVGNameSpace svgName = null;
            Object svgEle = null;
            Object svgAttr = null;
            Object valueOfAttr = null;
            int a = 0;
            while (a < this.myNameSpaces.size()) {
                svgName = (SVGNameSpace)this.myNameSpaces.get(a);
                if (svgName.getnameSpaceName().equalsIgnoreCase(svgNamespace.getnameSpaceName()) && svgElement != null && -1 != svgName.containsElement(svgElement.getElementName())) {
                    svgElement = svgName.getElementByTagName(svgElement.getElementName());
                    if (svgAttribute != null) {
                        System.out.println("Deleteing svgElement " + svgElement.hashCode());
                        if (value.equals("      -   ") || value != null) {
                            if (-1 != svgElement.containsAttribute(svgAttribute.getAttributeName())) {
                                svgElement.removeAttribute(svgAttribute.getAttributeName());
                            }
                        } else if (-1 != svgElement.containsAttribute(svgAttribute.getAttributeName(), value)) {
                            svgElement.removeAttribute(svgAttribute.getAttributeName(), value);
                        }
                    }
                }
                ++a;
            }
            a = 0;
            while (a < this.myNameSpaces.size()) {
                svgName = (SVGNameSpace)this.myNameSpaces.get(a);
                elements = svgName.getnameSpaceElements();
                if (elements != null) {
                    int j = 0;
                    while (j < elements.size()) {
                        svgElement = (SVGElement)elements.get(j);
                        if (svgElement.getElementAttributes().size() == 0) {
                            svgName.removeElement(svgElement.getElementName());
                            ((SVGNameSpace)this.myNameSpaces.get(a)).removeElement(svgElement.getElementName());
                        }
                        ++j;
                    }
                }
                ++a;
            }
            a = 0;
            while (a < this.myNameSpaces.size()) {
                svgName = (SVGNameSpace)this.myNameSpaces.get(a);
                elements = svgName.getnameSpaceElements();
                if (elements == null || elements.size() == 0) {
                    this.myNameSpaces.remove(a);
                }
                ++a;
            }
            ++i;
        }
    }

    public void populateTable() {
        int rowCount = this.dtm.getRowCount();
        if (rowCount != 0) {
            Vector temp = new Vector();
            Vector dataVector = this.dtm.getDataVector();
            int j = 0;
            while (j < rowCount) {
                temp.add(dataVector.get(j));
                ++j;
            }
            int k = 0;
            while (k < temp.size()) {
                Object obj = temp.get(k);
                dataVector.remove(obj);
                ++k;
            }
            this.dtm.fireTableRowsDeleted(0, rowCount - 1);
        }
        SVGNameSpace dname = this.addDialog.getDesiredNameSpace();
        SVGNameSpace nameSpace = null;
        SVGElement element = null;
        if (this.myNameSpaces == null) {
            return;
        }
        if (this.dtm == null) {
            return;
        }
        int i = 0;
        while (i < this.myNameSpaces.size()) {
            nameSpace = (SVGNameSpace)this.myNameSpaces.get(i);
            ArrayList allelements = nameSpace.getnameSpaceElements();
            if (nameSpace != null) {
                if (allelements == null) {
                    Vector<Object> rowData = new Vector<Object>();
                    rowData.add(nameSpace);
                    rowData.add(" -");
                    rowData.add(" -");
                    rowData.add(" -");
                    this.dtm.addRow(rowData);
                } else {
                    int j = 0;
                    while (j < allelements.size()) {
                        element = (SVGElement)nameSpace.getnameSpaceElements().get(j);
                        ArrayList allattributes = element.getElementAttributes();
                        if (element != null) {
                            if (allattributes == null) {
                                Vector<Object> rowData = new Vector<Object>();
                                rowData.add(nameSpace);
                                rowData.add(element);
                                rowData.add(" -");
                                rowData.add(" -");
                                this.dtm.addRow(rowData);
                            } else {
                                int k = 0;
                                while (k < allattributes.size()) {
                                    SVGAttribute attribute = (SVGAttribute)allattributes.get(k);
                                    if (attribute != null && allattributes != null) {
                                        Vector<Object> rowdata = new Vector<Object>();
                                        rowdata.add(nameSpace);
                                        rowdata.add(element);
                                        rowdata.add(attribute);
                                        if (attribute.getAttributeValue() == null) {
                                            rowdata.add("      -   ");
                                        } else {
                                            rowdata.add(attribute.getAttributeValue());
                                        }
                                        this.dtm.addRow(rowdata);
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.dtm.getRowCount() > 1) {
            this.nameSpaceTable.getSelectionModel().setSelectionMode(0);
            this.nameSpaceTable.getSelectionModel().setLeadSelectionIndex(this.selectedRow);
            this.nameSpaceTable.getSelectionModel().setSelectionMode(2);
        } else {
            this.nameSpaceTable.clearSelection();
        }
    }

    public void setMyNameSpaces(ArrayList list) {
        this.myNameSpaces = list;
    }

    public ArrayList getMyNameSpaces() {
        return this.myNameSpaces;
    }

    public void populateTable(ArrayList list) {
        if (list == null) {
            return;
        }
        int rowCount = this.dtm.getRowCount();
        if (rowCount != 0) {
            Vector temp = new Vector();
            Vector dataVector = this.dtm.getDataVector();
            int j = 0;
            while (j < rowCount) {
                temp.add(dataVector.get(j));
                ++j;
            }
            int k = 0;
            while (k < temp.size()) {
                Object obj = temp.get(k);
                dataVector.remove(obj);
                ++k;
            }
            this.dtm.fireTableRowsDeleted(0, rowCount - 1);
        }
        SVGNameSpace dname = this.addDialog.getDesiredNameSpace();
        SVGNameSpace nameSpace = null;
        SVGElement element = null;
        if (this.dtm == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            nameSpace = (SVGNameSpace)list.get(i);
            ArrayList allelements = nameSpace.getnameSpaceElements();
            if (nameSpace != null) {
                if (allelements == null) {
                    Vector<Object> rowData = new Vector<Object>();
                    rowData.add(nameSpace);
                    rowData.add(" -");
                    rowData.add(" -");
                    rowData.add(" -");
                    this.dtm.addRow(rowData);
                } else {
                    int j = 0;
                    while (j < allelements.size()) {
                        element = (SVGElement)nameSpace.getnameSpaceElements().get(j);
                        ArrayList allattributes = element.getElementAttributes();
                        if (element != null) {
                            if (allattributes == null) {
                                Vector<Object> rowData = new Vector<Object>();
                                rowData.add(nameSpace);
                                rowData.add(element);
                                rowData.add(" -");
                                rowData.add(" -");
                                this.dtm.addRow(rowData);
                            } else {
                                int k = 0;
                                while (k < allattributes.size()) {
                                    SVGAttribute attribute = (SVGAttribute)allattributes.get(k);
                                    if (attribute != null && allattributes != null) {
                                        Vector<Object> rowdata = new Vector<Object>();
                                        rowdata.add(nameSpace);
                                        rowdata.add(element);
                                        rowdata.add(attribute);
                                        if (attribute.getAttributeValue() == null) {
                                            rowdata.add("      -   ");
                                        } else {
                                            rowdata.add(attribute.getAttributeValue());
                                        }
                                        this.dtm.addRow(rowdata);
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.dtm.getRowCount() > 1) {
            this.nameSpaceTable.getSelectionModel().setSelectionMode(0);
            this.nameSpaceTable.getSelectionModel().setLeadSelectionIndex(this.selectedRow);
            this.nameSpaceTable.getSelectionModel().setSelectionMode(2);
        } else {
            this.nameSpaceTable.clearSelection();
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    class CustomTableModel
    extends DefaultTableModel {
        CustomTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Vector getDataVector() {
            return this.dataVector;
        }
    }
}

