/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.help;

import com.nokia.svg2svgt.help.MultiLanguageSupportForHelp;
import com.nokia.svg2svgt.help.SVG2SVGTToolHelp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class HelpMediator
implements ActionListener {
    private Hashtable components = new Hashtable();
    private Hashtable contexts = new Hashtable();
    private SVG2SVGTToolHelp helpWindow = new SVG2SVGTToolHelp();

    public void registerComponent(JComponent comp, String name) {
        this.components.put(comp, name);
        this.loadContext(name);
        String contextStr = (String)this.contexts.get(name);
        KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
        comp.registerKeyboardAction(this, keystroke, 1);
        this.helpWindow.registerHelp(comp, contextStr);
    }

    public void unregisterComponent(Component comp) {
        this.components.remove(comp);
    }

    public void registerHelpMenuItem(Component comp, String name) {
        this.components.put(comp, name);
        this.loadContext(name);
        String contextStr = (String)this.contexts.get(name);
        this.helpWindow.registerHelp(comp, contextStr);
    }

    public void unregisterHelpMenuItem(Component comp) {
        this.components.remove(comp);
    }

    public void invokeHelp(String contextStr) {
        this.helpWindow.launchHelp(contextStr);
    }

    public void invokeHelpIndex(Component comp) {
        String compName = (String)this.components.get(comp);
        String contextStr = (String)this.contexts.get(compName);
        this.helpWindow.launchHelpIndex(contextStr);
    }

    public void invokeHelpContents(Component comp) {
        String compName = (String)this.components.get(comp);
        String contextStr = (String)this.contexts.get(compName);
        this.helpWindow.launchHelpContents(contextStr);
    }

    public void actionPerformed(ActionEvent ae) {
        int i;
        Component comp = (Component)ae.getSource();
        String compName = (String)this.components.get(comp);
        String contextStr = (String)this.contexts.get(compName);
        if (comp instanceof JTabbedPane && (i = ((JTabbedPane)comp).getSelectedIndex()) != 0) {
            contextStr = "creationview";
        }
        this.invokeHelp(contextStr);
    }

    private void loadContext(String name) {
        try {
            String strTemp = MultiLanguageSupportForHelp.getLocalizedString(name);
            this.contexts.put(name, strTemp);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HelpMediator help = new HelpMediator();
        help.invokeHelp("introduction");
    }
}

