/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.help;

import com.nokia.svg2svgt.help.MultiLanguageSupportForHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class SVG2SVGTToolHelp {
    private HelpSet hs = null;
    private HelpBroker hb = null;
    private URL hsURL = null;
    private String defaultContext = "default";
    private String fontFamily = "Verdana";
    private int fontSize = 9;

    public SVG2SVGTToolHelp() {
        try {
            Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension d = new Dimension(rect.width, rect.height);
            int width = (int)d.getWidth();
            int height = (int)d.getHeight();
            int helpHeight = (int)((double)height * 0.5);
            int helpWidth = (int)((double)width * 0.5);
            this.readFont();
            String strAdminClientHelpSetFile = "ConverterToolHelp.hs";
            this.hsURL = HelpSet.findHelpSet(null, (String)strAdminClientHelpSetFile);
            this.hs = new HelpSet(null, this.hsURL);
            this.hb = this.hs.createHelpBroker();
            Dimension helpWindowDimension = new Dimension(helpWidth, helpHeight);
            Point helpWindowLocation = new Point(helpWidth / 2, helpHeight / 2);
            this.hb.setSize(helpWindowDimension);
            this.hb.setLocation(helpWindowLocation);
            Locale l = Locale.getDefault();
            this.hb.setLocale(l);
            this.hb.setFont(new Font(this.fontFamily, 0, this.fontSize));
            String strHelpTitle = MultiLanguageSupportForHelp.getLocalizedString("CONVERTERTOOL_HELP_TITLE");
            this.hs.setTitle(strHelpTitle);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readFont() {
        try {
            this.fontFamily = MultiLanguageSupportForHelp.getLocalizedString("FONT_FAMILY");
            String temp = MultiLanguageSupportForHelp.getLocalizedString("FONT_SIZE");
            this.fontSize = Integer.parseInt(temp.trim());
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void registerHelp(Component comp, String context) {
        this.hb.enableHelp(comp, context, this.hs);
    }

    public void launchHelp(String context) {
        try {
            this.hb.setCurrentView("TOC");
            this.hb.setCurrentID(context);
        }
        catch (Exception e) {
            this.hb.setCurrentID(this.defaultContext);
        }
        this.hb.setDisplayed(true);
    }

    public void launchHelpIndex(String context) {
        try {
            this.hb.setCurrentView("Index");
            this.hb.setCurrentID(context);
        }
        catch (Exception e) {
            this.hb.setCurrentID(this.defaultContext);
        }
        this.hb.setDisplayed(true);
    }

    public void launchHelpContents(String context) {
        try {
            this.hb.setCurrentView("TOC");
            this.hb.setCurrentID(context);
        }
        catch (Exception e) {
            this.hb.setCurrentID(this.defaultContext);
        }
        this.hb.setDisplayed(true);
    }

    public static void main(String[] args) {
        SVG2SVGTToolHelp help = new SVG2SVGTToolHelp();
        help.launchHelp("introduction");
    }
}

