/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class LogMessages {
    private static Hashtable logMessageFormats = new Hashtable();
    private static final String FILE_EXTENSION = ".properties";

    public static void init(String directory, String region) throws Exception {
        if (directory == null) {
            directory = ".";
        }
        if (region == null) {
            region = "GB";
        }
        String logMessageFile = "LogMessages_" + region + FILE_EXTENSION;
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(String.valueOf(directory) + File.separator + logMessageFile);
        }
        catch (FileNotFoundException _ex) {
            throw new Exception("Error reading from file " + logMessageFile);
        }
        try {
            properties.load(fis);
        }
        catch (IOException ioex) {
            throw new Exception("Error loading messages from " + logMessageFile);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Long code;
            String s = (String)enumeration.nextElement();
            String format = (String)properties.get(s);
            try {
                code = Long.valueOf(s);
            }
            catch (NumberFormatException nfex) {
                System.out.println("Invalid code number: " + s);
                continue;
            }
            MessageFormat messageformat = new MessageFormat(format);
            logMessageFormats.put(code, messageformat);
        }
    }

    public static String getLogMessage(long code) {
        return LogMessages.getLogMessage(code, null);
    }

    public static String getLogMessage(long code, Object[] params) {
        StringBuffer stringbuffer = new StringBuffer(200);
        MessageFormat messageformat = (MessageFormat)logMessageFormats.get(new Long(code));
        if (messageformat == null) {
            return null;
        }
        return messageformat.format(params).toString();
    }
}

