/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.Conversions;
import com.nokia.svg2svgt.converter.NameSpaceAnalyzer;
import com.nokia.svg2svgt.log.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpacityConverter
implements Conversions,
ConversionConstants {
    private Logger myLogger = null;

    public void doConversion(Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, Logger logger, String nsURL) throws DOMException {
        this.myLogger = logger;
        if (2 != svgNode.getNodeType()) {
            return;
        }
        if (1 != svgtNode.getNodeType()) {
            return;
        }
        Element svgtParentElement = (Element)svgtNode;
        String elemName = svgNode.getNodeName();
        String nsName = null;
        int index = elemName.indexOf(":");
        if (-1 != index) {
            nsName = elemName.substring(0, index - 1);
            elemName = elemName.substring(index + 1, elemName.length());
        }
        String attrValue = svgNode.getNodeValue();
        Attr fillOpacity = null;
        Attr strokeOpacity = null;
        if (nsName != null) {
            fillOpacity = svgtDoc.createAttribute(String.valueOf(nsName) + ":" + "fill-opacity");
            strokeOpacity = svgtDoc.createAttribute(String.valueOf(nsName) + ":" + "stroke-opacity");
        } else {
            fillOpacity = svgtDoc.createAttribute("fill-opacity");
            strokeOpacity = svgtDoc.createAttribute("stroke-opacity");
        }
        fillOpacity.setNodeValue(attrValue);
        if (this.retainNode(nsName, nsURL, "fill-opacity")) {
            svgtParentElement.setAttributeNode(fillOpacity);
        }
        strokeOpacity.setNodeValue(attrValue);
        if (this.retainNode(nsName, nsURL, "stroke-opacity")) {
            svgtParentElement.setAttributeNode(strokeOpacity);
        }
    }

    private boolean retainNode(String nsName, String nsURL, String nodeName) {
        if (this.isTagAllowed(nsName, nsURL, nodeName)) {
            this.isWarningRequired(nsName, nsURL, nodeName);
            return true;
        }
        return true;
    }

    private boolean isTagAllowed(String nsName, String nsURL, String nodeName) {
        NameSpaceAnalyzer nameSpaceA = (NameSpaceAnalyzer)ServiceRegistry.getService("com.nokia.svg2svgt.converter.NameSpaceAnalyzer");
        if (nameSpaceA == null) {
            return false;
        }
        return nameSpaceA.isNodeAllowed(nsName, nsURL, nodeName, (short)2);
    }

    private boolean isWarningRequired(String nsName, String nsURL, String nodeName) {
        NameSpaceAnalyzer nameSpaceA = (NameSpaceAnalyzer)ServiceRegistry.getService("com.nokia.svg2svgt.converter.NameSpaceAnalyzer");
        if (nameSpaceA == null) {
            return false;
        }
        if (nameSpaceA.isWarningTag(nsName, nsURL, nodeName, (short)2)) {
            this.logWarning(2800L, new String[]{nodeName});
        }
        return true;
    }

    private void logEvent(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }

    private void logWarning(long msgCode, Object[] params) {
        if (this.myLogger != null) {
            this.myLogger.logEvent(msgCode, params);
        }
    }
}

