/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.localiser;

import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.configuration.Parameter;
import java.io.File;
import java.util.ResourceBundle;

public class Localiser {
    private static final String FILE_EXTENSION = ".properties";
    private static final String TOOLTIPTEXT = "_ToolTipText";
    private static final String MNEUMONIC = "_Mneumonic";
    private static final String COMPONENTTEXT = "_Text";
    private ConfigurationManager myStringBundleMgr = null;
    private Configuration myStringBundle = null;
    private ConfigurationManager myIconBundleMgr = null;
    private Configuration myIconBundle = null;

    public Localiser(String region) throws Exception {
        try {
            if (region != null && region.length() > 0) {
                this.myStringBundleMgr = new ConfigurationManager(String.valueOf(ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_STRING_BUNDLE_FILE")) + File.separator + "StringBundle_" + region + FILE_EXTENSION);
                this.myStringBundle = this.myStringBundleMgr.getConfiguration();
                this.myIconBundleMgr = new ConfigurationManager(String.valueOf(ResourceBundle.getBundle("SVG2SVGTProperties").getString("SVGT_STRING_BUNDLE_FILE")) + File.separator + "IconBundle_" + region + FILE_EXTENSION);
                this.myIconBundle = this.myIconBundleMgr.getConfiguration();
            }
        }
        catch (Exception ex) {
            throw new Exception("Error creating localiser. Reason: " + ex.toString());
        }
    }

    public String getText(String componentName) {
        Parameter param = null;
        String text = String.valueOf(componentName) + COMPONENTTEXT;
        if (this.myStringBundle != null && (param = this.myStringBundle.getParameter(text)) != null) {
            return param.getValue();
        }
        return null;
    }

    public String getMneumonic(String componentName) {
        Parameter param = null;
        String mneumonic = String.valueOf(componentName) + MNEUMONIC;
        if (this.myStringBundle != null && (param = this.myStringBundle.getParameter(mneumonic)) != null) {
            return param.getValue();
        }
        return null;
    }

    public String getToolTipText(String componentName) {
        Parameter param = null;
        String toolTip = String.valueOf(componentName) + TOOLTIPTEXT;
        if (this.myStringBundle != null && (param = this.myStringBundle.getParameter(toolTip)) != null) {
            return param.getValue();
        }
        return null;
    }

    public String getIconPath(String componentName) {
        Parameter param = null;
        if (this.myIconBundle != null && (param = this.myIconBundle.getParameter(componentName)) != null) {
            return param.getValue();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            Localiser l = new Localiser("GB");
            System.out.println(l.getText("JMenu.fileMenuItem"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

