/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.skinapp.general;

import java.util.ResourceBundle;


public class SkinAppBundle {
	/**
	 * holds an instance of SkinAppBundle 
	 */
	private static SkinAppBundle _instance = new SkinAppBundle();
	/**
	 * This holds the ResourceBundle used 
	 */
	private ResourceBundle localeResourceBundle;
	/**
	 * This holds the ResourceBundle used 
	 */
	private ResourceBundle settingsResourceBundle;  
    
    
	/**
	* Default constructor
	*/
	private SkinAppBundle (){
        
		localeResourceBundle = ResourceBundle.getBundle("LCTLocalization");
		settingsResourceBundle = ResourceBundle.getBundle("LCTSettings");
	}
    
    
	/**
	* @return The handle to the properties bundle for handling Skin properties
	*/
	public static ResourceBundle getPropBundle () {
		return _instance.settingsResourceBundle;
	}


	/*
	* @return The handle to the properties bundle for handling Skin localization
	*/
	public static ResourceBundle getLocale () {
		return _instance.localeResourceBundle;
	}   
}
