/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt;

/**
 * Interface specifying all the constants and log constants used by the
 * converter tool.
 *
 */
public interface SVG2SVGTConstants
{

    /**
     * Specifies the mode of operation for the converter tool as GUI mode.
     */
    public static final String GUI_MODE                 = "GUI";

    /**
     * Specifies the mode of operation for the converter tool as BATCH
     * mode.
     */
    public static final String BATCH_MODE               = "BatchMode";

    /**
     * Specifies the mode of operation for the converter tool as UNKNOWN.
     */
    public static final String UNKNOWN_MODE             = "Unknown";

    /**
     * Option used for storing file names after resolving -svglist and
     * -file option.
     */
    public static final String SVGFILE_OPTION           = "-svgfile";

    /**
     * Command line option for specifying the file containing the list of
     * SVG files to be used for conversion.
     */
    public static final String SVGFILELIST_OPTION       = "-svglist";

    /**
     * Option used internally for specifying the conversions file name.
     */
    public static final String CONVERSIONSFILE_OPTION   = "-convfile";

    /**
     * Command line option for specifying the output directory.
     */
    public static final String OUTDIR_OPTION            = "-o";


    public static final String DIMENSION_OPTION = "-d";
    
	/**
	 * Command line option for specifying pass through file.
	 */
	public static final String PASSTHROUGHFILE_OPTION     = "-p";

    /**
     * Command line option for using the help on command line options.
     */
    public static final String HELP_OPTION              = "-help";

    /**
     * Command line option for specifying the command line parameters in a
     * file.
     */
    public static final String CMDLINEFILE_OPTION       = "-file";

    /**
     * Separator used for separating file names.
     */
    public static final String SEPARATOR                = ",";

    /**
     * Specifies the regions supported by the converter tool for
     * localisation.
     */
    public static final String[] SUPPORTED_REGIONS      = {"GB"};

    /**
     * Default region if the region specified by the user is not supported.
     */
    public static final String DEFAULT_REGION           = "GB";

	/**
	 * Key for the critical file size in the configuration file.
	 */
	public static final String CRITICAL_SIZE            = "CriticalFileSize";
	


	/**
	 * Key for the black list file name in the configuration file.
	 */
	public static final String PASSTHROUGH_FILE           = "PassThroughFileName";

	
	/**
	 * Key for the output directory in the configuration file.
	 */
	public static final String OUTDIR                   = "OutDir";



// -------- LOG CONSTANTS FOR LOGGING MESSAGES --------------------

    /**
     * Error constant specifying that invalid option has been entered by the
     * user.
     */
    public static final long INVALID_OPTION_ERROR       = 2000;

    /**
     * Error constant specifying that the value for an option is missing.
     */
    public static final long NO_OPTION_ERROR            = 2100;

    /**
     * Error constant specifying an error in reading a file.
     */
    public static final long FILE_READING_ERROR         = 2200;

    /**
     * Error constant specifying file specification error for -file option.
     */
    public static final long WRONG_FILE_SPECIFICATION_ERROR = 2300;

    /**
     * Error constant specifying an empty file error.
     */
    public static final long EMPTY_FILE_ERROR           = 2400;

    /**
     * Error constant specifying that file name is incorrect or missing.
     */
    public static final long NO_FILENAME_ERROR          = 2500;

    /**
     * Event constant for specifying  that conversions is in progress.
     */
    public static final long PERFORMING_CONVERSIONS_MESSAGE = 2600;

    /**
     * Constant specifying that black tag has been removed.
     */
    public static final long BLACK_TAG_REMOVED              = 2700;

    /**
     * Constant specifying that grey tag was encountered.
     */
    public static final long GREY_TAG_FOUND                 = 2800;

    /**
     * Constant specifying an error while parsing the file.
     */
    public static final long FILE_PARSING_ERROR             = 2900;

    /**
     * Constant specifying a conversions failure error.
     */
    public static final long CONVERSION_FAILURE_ERROR       = 3000;

    /**
     * Constant specifying that file is being loaded.
     */
    public static final long LOADING_FILE                   = 3100;

    /**
     * Constant specifying that command line option was encountered.
     */
    public static final long CMDLINE_OPTION_ENCOUNTERED     = 3200;

    /**
     * Constant specifying which file is currently being converted.
     */
    public static final long CURRENT_CONVERSION_FILENAME    = 3300;

    /**
     * Message that SVG name spaces are being removed.
     */
    public static final long REMOVE_SVG_NAMESPACE           = 3400;

    /**
     * Message that SVG file is being saved.
     */
    public static final long SAVING_SVGT_FILE               = 3500;

    /**
     * Message for removing non-referred id attributes.
     */
    public static final long REMOVING_NONREFERRED_IDS       = 3600;

    /**
     * Message for merging similar gradient paint definitions.
     */
    public static final long MERGING_SIMILAR_GARDIENT_DEFS  = 3700;

    /**
     * Message for removing empty nodes.
     */
    public static final long REMOVING_EMPTY_NODES           = 3800;

    /**
     * Message that input files are missing.
     */
    public static final long MISSING_INPUT_FILES            = 3900;
	/**
	 * Message that input files are missing.
	 */
	public static final long MISSING_STOP_ELEMENTS            = 4000;
	/**
	 * Message when file size exceeds critical size. 
	 */
	public static final long CRITICLE_SIZE_EXCEEDING_ERROR   = 4100;
}
