/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt;

import java.util.Hashtable;

/**
 * Provides a shared repository for registering common services used
 * in the converter tool. The services are registered by their class
 * names.
 *
 */
public class ServiceRegistry
{

   /**
    * Repository for registering services.
    */
   private static Hashtable myRegistry = new Hashtable();


   /**
    * Registers the service in the service registry.
    *
    * @param service    Servcie to be registered.
    */
   public static void registerService( Object service )
   {
        if ( null != service )
        {
            Class serviceClass = service.getClass();
            String serviceName = serviceClass.getName();
            if ( myRegistry.containsKey( serviceName ) )
            {
                myRegistry.remove( serviceName );
            }
            myRegistry.put( serviceName, service );
        }
   }


   /**
    * Obtains the service from the service registry.
    *
    * @param serviceName    Service to be fetched.
    * @return               Service to be fetched.
    */
   public static Object getService( String serviceName )
   {
       return myRegistry.get( serviceName );
   }

}
