/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of the License "Symbian Foundation License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */
package com.nokia.svg2svgt.configuration;

// imports
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * This class acts as a wrapper class for representing the configuration
 * specified in the file being used by <code>ConfigurationStorage</code> and
 * provides accessor methods to operate on individual <code>Parameter</code>(s).
 */
public class Configuration implements Serializable {

	/**
	 * Specifies the current configuration for a configuration file.
	 */
	public Hashtable myConfiguration = new Hashtable();

	/**
	 * Default constructor.
	 * 
	 */
	public Configuration() {
	}

	/**
	 * Creates a configuration for the configuration parameters specified in the
	 * <code>Hashtable</code>.
	 * 
	 * @param config
	 *            Hashtable containing the configuration.
	 */
	public Configuration(Hashtable config) {
		Enumeration enum1 = config.keys();
		while (enum1.hasMoreElements()) {
			String key = (String) enum1.nextElement();
			Parameter par = new Parameter(key, (String) config.get(key));
			put(par);
		}
	}

	/**
	 * Adds this <code>Parameter</code> to the configuration.
	 * 
	 * @param param
	 *            New configuration parameter.
	 * @return New configuration parameter.
	 */
	public Parameter put(Parameter param) {
		Parameter par = null;
		par = (Parameter) myConfiguration.put(param.getKey(), param);
		return par;
	}

	/**
	 * Removes the <code>Parameter</code> specified by name "key" from the
	 * configuration.
	 * 
	 * @param key
	 *            Parameter name to be removed.
	 * @return Removed parameter.
	 */
	public Parameter remove(String key) {
		Parameter par = null;
		par = (Parameter) myConfiguration.remove(key);
		return par;
	}

	/**
	 * Fetches the <code>Parameter</code> specified by name "key" from the
	 * configuration file.
	 * 
	 * @param key
	 *            Parameter name to be fetched.
	 * @return Fetched parameter.
	 */
	public Parameter getParameter(String key) {
		return (Parameter) (myConfiguration.get(key));
	}

	/**
	 * Return this Configuration as a Hashtable with only key-value pairs. No
	 * parameter attributes are included.
	 * 
	 * @return Configuration as a Hashtable
	 */
	public Hashtable toHash() {
		Hashtable hash = new Hashtable();
		Enumeration enum1 = elements();
		while (true == enum1.hasMoreElements()) {
			Parameter p = (Parameter) enum1.nextElement();
			hash.put(p.getKey(), p.getValue());
		}
		return hash;
	}

	/**
	 * Overwritten toString() method for debugging purpose.
	 * 
	 * @return Contents in this configuration file.
	 */
	public String toString() {
		StringBuffer to = new StringBuffer();
		Enumeration iter = elements();

		Parameter par = null;
		to.append(System.getProperty("line.separator"));
		while (iter.hasMoreElements()) {
			par = (Parameter) iter.nextElement();
			to.append(par.toString());
			to.append(System.getProperty("line.separator"));
		}
		return to.toString();
	}

	/**
	 * Returns the enumeration for elements in the configuration file.
	 * 
	 * @return Enumeration for the contents in the file.
	 */
	public Enumeration elements() {
		return myConfiguration.elements();
	}

}
