/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

package com.nokia.svg2svgt.converter;

import com.nokia.svg2svgt.log.Logger;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.*;

public class PercentageConverterForHeightAndWidthTag implements Conversions,
		ConversionConstants {

	public PercentageConverterForHeightAndWidthTag() {
		myLogger = null;
	}

	public void doConversion(Node svgNode, Document svgDoc, Node svgtNode,
			Document svgtDoc, Logger logger, String nsURL) {
		myLogger = logger;
		Element parentNode = ((Attr) svgNode).getOwnerElement();
		if (!parentNode.getNodeName().equals("svg"))
			return;
		if (2 != svgNode.getNodeType())
			return;
		if (1 != svgtNode.getNodeType())
			return;
		Element svgtParentElement = (Element) svgtNode;
		String elemName = svgNode.getNodeName();
		if (elemName.equalsIgnoreCase("width")
				|| elemName.equalsIgnoreCase("height")) {
			ResourceBundle bundle = ResourceBundle
					.getBundle("SVG2SVGTProperties");
			try {
				String value = bundle.getString("OVERWRITE_DIMENSION");
				if (value.length() > 0) {
					Attr svgtAttr = svgtDoc.createAttribute(elemName);
					svgtAttr.setValue(value.trim());
					svgtParentElement.setAttributeNode(svgtAttr);
				}
			} catch (MissingResourceException mre) {
				Attr svgtAttr = svgtDoc.createAttribute(elemName);
				svgtAttr.setValue(((Attr) svgNode).getValue());
				svgtParentElement.setAttributeNode(svgtAttr);
			}
		}
	}

	private void logEvent(long msgCode, Object params[]) {
		if (myLogger != null)
			myLogger.logEvent(msgCode, params);
	}

	private void logWarning(long msgCode, Object params[]) {
		if (myLogger != null)
			myLogger.logEvent(msgCode, params);
	}

	private Logger myLogger;
}