/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGModule;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.gui.ext.JMultiSelectionComboBox;
import com.nokia.svg2svgt.gui.ext.event.SelectionEvent;
import com.nokia.svg2svgt.gui.ext.event.SelectionListener;
import com.nokia.svg2svgt.localiser.Localiser;

public class AddDialog extends JDialog implements ActionListener,
		ConversionConstants {
	private JPanel nameSpacePanel = new JPanel();
	private TitledBorder titledBorder2;

	private JLabel nameSpaceNameLabel = new JLabel();
	private JComboBox nameSpaceCombo = new JComboBox();

	private JLabel urlLabel = new JLabel();
	private JComboBox urlCombo = new JComboBox();

	private JRadioButton equalsRadioButton = new JRadioButton();
	private JRadioButton containsRadioButton = new JRadioButton();
	private ButtonGroup group = new ButtonGroup();
	private JCheckBox allowAll = new JCheckBox();

	private JPanel elementPanel = new JPanel();
	private TitledBorder titledBorder4;

	private JLabel moduleNameLabel = new JLabel();
	private JComboBox moduleCombo = new JComboBox();

	private JLabel elementnameLabel = new JLabel();

	private JPanel attributePanel = new JPanel();
	private TitledBorder titledBorder6;

	private JLabel attributNameLabel = new JLabel();

	private JLabel attributeValueLabel = new JLabel();
	private JTextField valueTextField = new JTextField();

	private JCheckBox warnCheckBox = new JCheckBox();

	private JButton okButton = new JButton();
	private JButton cancelButton = new JButton();
	private JButton resetButton = new JButton();

	private JMultiSelectionComboBox elementCombo = null;
	private JMultiSelectionComboBox attributeCombo = null;

	private SVGDTDAnalyzer myAnaliser = null;
	private ArrayList myModules = null;
	private ArrayList myNameSpaces = null;
	private Vector myTableInfo = null;
	private Frame frame = null;
	private SVGNameSpace desiredNameSpace = null;
	Vector attr = null;
	Localiser myLocaliser = null;

	/**
	 * Constructer that takes three parameters ,parent frame , localiser which
	 * is responsible for extracting the bundle string, and the third is the
	 * title of the dialog.
	 */
	public AddDialog(Frame frame, Localiser localiser, String title) {
		super(frame, title, true);
		this.frame = frame;
		myLocaliser = localiser;
		try {
			myAnaliser = new SVGDTDAnalyzer(myLocaliser.getText("SVG_XML"),
					null);
			myModules = myAnaliser.getSVGModules();
		} catch (Exception e) {
			e.printStackTrace();
		}

		try {
			createDialog();
			pack();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * Creates GUI of the dialog
	 * 
	 * @throws Exception
	 */
	private void createDialog() throws Exception {

		titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(134, 134, 134)), myLocaliser
				.getText("Add.NameSpacePanel.title"));
		titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(134, 134, 134)), myLocaliser
				.getText("Add.Element.title"));
		titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(134, 134, 134)), myLocaliser
				.getText("Add.Attribute.title"));

		this.getContentPane().setLayout(null);

		nameSpacePanel.setLayout(null);
		nameSpacePanel.setBorder(titledBorder2);
		nameSpacePanel.setBounds(new Rectangle(10, 10, 300, 144));

		nameSpaceNameLabel.setText(myLocaliser
				.getText("Add.nameSpaceName.NameLabel"));
		nameSpaceNameLabel.setBounds(22, 24, 50, 24);

		nameSpaceCombo.setEditable(true);
		nameSpaceCombo.addActionListener(this);
		nameSpaceCombo.setBounds(78, 24, 200, 24);

		nameSpaceCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				String svg = null;
				if (nameSpaceCombo.getSelectedItem() instanceof String) {
					svg = (String) nameSpaceCombo.getSelectedItem();
				} else if (nameSpaceCombo.getSelectedItem() instanceof SVGNameSpace) {
					SVGNameSpace svg1 = (SVGNameSpace) nameSpaceCombo
							.getSelectedItem();
					svg = svg1.getnameSpaceName();
				}
				if (svg == null)
					return;

				if (svg.equals(TAG_SVG_ROOT))
					moduleCombo.setEnabled(true);
				else
					moduleCombo.setEnabled(false);
			}
		});

		urlLabel.setText(myLocaliser.getText("Add.nameSpaceName.UrlLabel"));
		urlLabel.setBounds(new Rectangle(22, 60, 50, 24));

		urlCombo.setEditable(true);
		urlCombo.setBounds(new Rectangle(78, 60, 200, 24));

		equalsRadioButton.setText(myLocaliser
				.getText("Add.nameSpaceName.equalsRadioButton"));
		equalsRadioButton.setBounds(new Rectangle(76, 84, 80, 24));

		containsRadioButton.setText(myLocaliser
				.getText("Add.nameSpaceName.ContainsRadioButton"));
		containsRadioButton.setBounds(new Rectangle(156, 84, 80, 24));
		group.add(equalsRadioButton);
		group.add(containsRadioButton);

		allowAll.setText(myLocaliser.getText("Add.nameSpaceName.AllowAll"));
		allowAll.setBounds(20, 108, 80, 24);
		allowAll.setSelected(true);

		elementPanel.setBorder(titledBorder4);
		elementPanel.setBounds(new Rectangle(10, 160, 300, 192));
		elementPanel.setLayout(null);

		moduleNameLabel.setText(myLocaliser
				.getText("Add.nameSpaceName.ModuleNameLabel"));
		moduleNameLabel.setBounds(22, 12, 50, 24);

		moduleCombo.setEditable(true);
		moduleCombo.setBounds(78, 12, 200, 24);
		moduleCombo.addActionListener(this);

		elementnameLabel.setText(myLocaliser
				.getText("Add.nameSpaceName.ElementNameLabel"));
		elementnameLabel.setBounds(new Rectangle(22, 48, 50, 24));
		elementCombo = new JMultiSelectionComboBox();
		elementCombo.setDelimiter(",");
		elementCombo.setBounds(78, 48, 200, 24);
		elementPanel.add(elementCombo, null);

		attributePanel.setBorder(titledBorder6);
		attributePanel.setBounds(new Rectangle(10, 84, 280, 96));
		attributePanel.setLayout(null);

		attributNameLabel.setText(myLocaliser
				.getText("Add.nameSpaceName.AttributeNameLabel"));
		attributNameLabel.setBounds(new Rectangle(12, 24, 50, 24));

		attributeCombo = new JMultiSelectionComboBox();

		attributeCombo.setBounds(new Rectangle(68, 24, 200, 24));
		attributePanel.add(attributeCombo);

		attributeValueLabel.setText(myLocaliser
				.getText("Add.nameSpaceName.AttributeValueLabel"));
		attributeValueLabel.setBounds(new Rectangle(12, 60, 50, 24));

		valueTextField.setText("");
		valueTextField.setBounds(new Rectangle(68, 60, 200, 24));

		warnCheckBox.setText(myLocaliser
				.getText("Add.nameSpaceName.warnCheckBox"));
		warnCheckBox.setBounds(10, 352, 80, 24);

		okButton.setBounds(new Rectangle(120, 380, 70, 24));
		okButton.setText(myLocaliser.getText("Add.nameSpaceName.oKButton"));
		okButton.addActionListener(this);

		cancelButton.setBounds(new Rectangle(195, 380, 70, 24));
		cancelButton.setText(myLocaliser
				.getText("Add.nameSpaceName.CancelButton"));
		cancelButton.addActionListener(this);

		resetButton.setBounds(new Rectangle(45, 380, 70, 24));
		resetButton.setText(myLocaliser
				.getText("Add.nameSpaceName.resetButton"));
		resetButton.addActionListener(this);

		nameSpacePanel.add(nameSpaceNameLabel, null);
		nameSpacePanel.add(nameSpaceCombo, null);
		nameSpacePanel.add(urlLabel, null);
		nameSpacePanel.add(urlCombo, null);
		nameSpacePanel.add(containsRadioButton, null);
		nameSpacePanel.add(equalsRadioButton, null);
		nameSpacePanel.add(allowAll, null);

		attributePanel.add(attributeValueLabel, null);
		attributePanel.add(valueTextField, null);
		attributePanel.add(attributNameLabel, null);

		elementPanel.add(moduleNameLabel, null);
		elementPanel.add(moduleCombo, null);
		elementPanel.add(elementnameLabel, null);
		elementPanel.add(attributePanel, null);

		this.getContentPane().add(nameSpacePanel, null);
		this.getContentPane().add(elementPanel, null);
		this.getContentPane().add(resetButton, null);
		this.getContentPane().add(okButton, null);
		this.getContentPane().add(cancelButton, null);
		this.getContentPane().add(warnCheckBox, null);
		allowAll.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				if (true == allowAll.isSelected()) {
					moduleCombo.setEnabled(false);
					elementCombo.setEnabled(false);
					attributeCombo.setEnabled(false);
					valueTextField.setEnabled(false);
				} else {
					moduleCombo.setEnabled(true);
					elementCombo.setEnabled(true);
					attributeCombo.setEnabled(true);
					valueTextField.setEnabled(true);
				}
			}
		});

		elementCombo.addSelectionListener(new SelectionListener() {
			public void selectionChanged(SelectionEvent e) {
				if (e.getSource() instanceof JMultiSelectionComboBox) {
					JMultiSelectionComboBox combo = (JMultiSelectionComboBox) e
							.getSource();
					if (combo.getSelectedIndices().length > 1) {
						attributeCombo.setEnabled(false);
						valueTextField.setEditable(false);
					} else {
						attributeCombo.setEnabled(true);
						valueTextField.setBackground(Color.WHITE);
						valueTextField.setEditable(true);
						if ((combo.getSelectedValue() != null)
								&& (combo.getSelectedValue() instanceof SVGElement)) {
							SVGElement element = (SVGElement) combo
									.getSelectedValue();
							attributeCombo.removeAll();
							ArrayList attributes = element
									.getElementAttributes();
							for (int i = 0; i < attributes.size(); i++) {
								SVGAttribute attribute = (SVGAttribute) element
										.getElementAttributes().get(i);
								// System.out.println(" Attributes" +
								// attribute);
								attributeCombo.addItem(attribute);

							}
							attributeCombo.setSelectedIndex(0);
						}
					}

				}
			}

			public void selectionOver(SelectionEvent e) {
			}
		});

		attributeCombo.addSelectionListener(new SelectionListener() {
			public void selectionChanged(SelectionEvent e) {
				if (e.getSource() instanceof JMultiSelectionComboBox) {
					JMultiSelectionComboBox combo = (JMultiSelectionComboBox) e
							.getSource();

					if (attributeCombo.getSelectedIndices().length > 1) {
						valueTextField.setEnabled(false);
					} else {
						valueTextField.setEnabled(true);
					}
					if (null != attributeCombo.getSelectedValue()) {
						if (attributeCombo.getSelectedValue() instanceof SVGAttribute) {

							SVGAttribute attribute = (SVGAttribute) attributeCombo
									.getSelectedValue();
							if (true == attribute.isWarned()) {
								warnCheckBox.setSelected(true);
							}
							valueTextField.setText((String) attribute
									.getAttributeValue());
						}
					}
				}
			}

			public void selectionOver(SelectionEvent e) {
			}
		});
	}

	/**
	 * This is the actionperformed method for the Add dialog class Which takes
	 * care of all the action events of ADD Dialog
	 * 
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(okButton)) {
			if ((nameSpaceCombo.getSelectedItem() instanceof String)
					&& (((String) nameSpaceCombo.getSelectedItem()).trim()
							.length() == 0)) {
				JOptionPane
						.showMessageDialog(frame, "Select a Namespace name ");
			} else {
				if ((urlCombo.getSelectedItem() instanceof String)
						&& ((String) urlCombo.getSelectedItem()).trim()
								.length() == 0) {
					JOptionPane.showMessageDialog(frame,
							"Select a Namespace url ");
				} else {
					checkBeforeOk();
					this.dispose();
				}
			}

		} else if (e.getSource().equals(cancelButton)) {
			this.dispose();
		} else if (e.getSource().equals(resetButton)) {
			reset();
		} else if (e.getSource().equals(moduleCombo)) {
			if (0 != moduleCombo.getSelectedIndex()) {
				SVGModule selectedModule = (SVGModule) moduleCombo
						.getSelectedItem();
				if (null == selectedModule)
					return;
				for (int i = 0; i < myModules.size(); i++) {
					SVGModule module = (SVGModule) myModules.get(i);
					if (module.getModuleName().equalsIgnoreCase(
							selectedModule.toString())
							&& moduleCombo.getSelectedIndex() > 0) {
						ArrayList allElements = module.getModuleElements();
						elementCombo.removeAll();
						for (int j = 0; j < allElements.size(); j++) {
							SVGElement element = (SVGElement) allElements
									.get(j);
							elementCombo.addItem(element);
						}
						elementCombo.setSelectedIndex(0);
					}
				}
			} else if (0 == moduleCombo.getSelectedIndex()) {
				elementCombo.removeAll();
				for (int i = 0; i < myModules.size(); i++) {
					SVGModule module = (SVGModule) myModules.get(i);
					ArrayList listOfEle = module.getModuleElements();
					for (int j = 0; j < listOfEle.size(); j++) {
						elementCombo.addItem((SVGElement) listOfEle.get(j));
					}
					elementCombo.setSelectedIndex(0);
				}
			}
		} else if (e.getSource().equals(nameSpaceCombo)) {
			for (int i = 0; i < myNameSpaces.size(); i++) {
				SVGNameSpace nameSpaces = (SVGNameSpace) myNameSpaces.get(i);
				// if ( nameSpaces.getnameSpaceName().equalsIgnoreCase( ((
				// SVGNameSpace )nameSpaceCombo.getSelectedItem()
				// ).getnameSpaceName() ) )
				// {
				// for ( int j = 0; j < urlCombo.getItemCount(); j++ )
				// {
				// if ( urlCombo.getItemAt(j).equals( nameSpaces.getMyUri() ) )
				// {
				// urlCombo.setSelectedIndex( j );
				// }
				// }
				// }
				if (nameSpaces.isURI()) {
					equalsRadioButton.setSelected(true);
				}
				if (nameSpaces.isWarn())
					warnCheckBox.setSelected(true);
				else
					warnCheckBox.setSelected(false);
				if (nameSpaces.isIsallowed())
					allowAll.setSelected(true);
				else
					allowAll.setSelected(false);
			}
		}
	}

	/**
	 * This method takes care of the activities which are are to be taken care
	 * before clicking on OkButton ,
	 */

	private void checkBeforeOk() {

		SVGNameSpace nameSpace = null;
		if (nameSpaceCombo.getSelectedItem() instanceof String) {
			nameSpace = new SVGNameSpace((String) nameSpaceCombo
					.getSelectedItem());
		} else {
			nameSpace = new SVGNameSpace(nameSpaceCombo.getSelectedItem()
					.toString());
		}

		nameSpace.setMyUri((String) urlCombo.getSelectedItem());

		if (equalsRadioButton.isSelected()) {
			nameSpace.setURI(true);
		}

		if (allowAll.isSelected()) {
			nameSpace.setIsallowed(true);
			if (warnCheckBox.isSelected())
				nameSpace.setWarn(true);
			else
				nameSpace.setWarn(false);
		} else if (elementCombo.getSelectedIndices().length > 1) {
			Object[] elements = elementCombo.getSelectedValues();
			for (int i = 0; i < elements.length; i++) {
				SVGElement elem = (SVGElement) elements[i];
				SVGElement element = new SVGElement(elem.getElementName(),
						nameSpace.getnameSpaceName());
				ArrayList attrs = (ArrayList) elem.getElementAttributes()
						.clone();
				for (int k = 0; k < attrs.size(); k++) {
					element.addAttribute((SVGAttribute) attrs.get(k));
				}
				if (true == warnCheckBox.isSelected())
					element.setWarn(true);
				else
					element.setWarn(false);
				nameSpace.addElement(element);
			}
		} else if (attributeCombo.getSelectedIndices().length > 1) {
			SVGElement element = new SVGElement(elementCombo.getSelectedValue()
					.toString(), nameSpaceCombo.getSelectedItem().toString());
			Object[] attributes = attributeCombo.getSelectedValues();
			for (int k = 0; k < attributeCombo.getSelectedIndices().length; k++) {
				SVGAttribute attribute = new SVGAttribute(attributes[k]
						.toString(),
						elementCombo.getSelectedValue().toString(), null, null,
						valueTextField.getText());
				if (true == warnCheckBox.isSelected())
					attribute.setWarned(true);
				element.addAttribute(attribute);
			}
			nameSpace.addElement(element);
		} else if ((-1 != elementCombo.getSelectedIndex())
				&& (-1 != attributeCombo.getSelectedIndex())) {
			SVGElement element = new SVGElement(elementCombo.getSelectedValue()
					.toString(), nameSpaceCombo.getSelectedItem().toString());
			if (null != attributeCombo.getSelectedValue()) {
				SVGAttribute attribute = new SVGAttribute(attributeCombo
						.getSelectedValue().toString(), elementCombo
						.getSelectedValue().toString(), null, null,
						valueTextField.getText());
				if (true == warnCheckBox.isSelected())
					attribute.setWarned(true);
				else
					attribute.setWarned(false);
				element.addAttribute(attribute);
			} else {
				if (true == warnCheckBox.isSelected())
					element.setWarn(true);
			}
			nameSpace.addElement(element);
		} else if (elementCombo.getSelectedValue() instanceof String
				|| attributeCombo.getSelectedValue() instanceof String) {
			SVGElement element = new SVGElement((String) elementCombo
					.getSelectedValue(), nameSpaceCombo.getSelectedItem()
					.toString());
			if (null != attributeCombo.getSelectedValue()) {
				SVGAttribute attribute = new SVGAttribute(
						(String) attributeCombo.getSelectedValue(),
						(String) elementCombo.getSelectedValue(), null, null,
						valueTextField.getText());
				if (true == warnCheckBox.isSelected())
					attribute.setWarned(true);
				element.addAttribute(attribute);
			} else {
				if (true == warnCheckBox.isSelected())
					element.setWarn(true);
			}
			nameSpace.addElement(element);
		}
		setDesiredNameSpace(nameSpace);
		updateNSList(nameSpace);
	}// end of check

	/**
	 * simply populates the combo box @ params no parameters @ return no retun
	 * type
	 */
	public void populateDialog() {
		if (null == myNameSpaces)
			return;
		try {
			nameSpaceCombo.removeAllItems();
			urlCombo.removeAllItems();
		} catch (Exception e) {
			System.out.println("Error  " + e.getStackTrace());
		}

		for (int i = 0; i < myNameSpaces.size(); i++) {

			SVGNameSpace nameSpace = (SVGNameSpace) myNameSpaces.get(i);
			nameSpaceCombo.addItem(nameSpace);
			urlCombo.addItem(nameSpace.getMyUri());

			if (true == nameSpace.isURI()) {
				containsRadioButton.setSelected(false);
				equalsRadioButton.setSelected(true);
			} else {
				equalsRadioButton.setSelected(false);
				containsRadioButton.setSelected(true);
			}

			if (true == nameSpace.isIsallowed())
				allowAll.setSelected(true);
			else
				allowAll.setSelected(false);

			if (true == nameSpace.isWarn())
				warnCheckBox.setSelected(true);
			else
				warnCheckBox.setSelected(false);

		}

		moduleCombo.removeAllItems();
		SVGModule module1 = new SVGModule("--All--");
		moduleCombo.addItem(module1);

		for (int i = 0; i < myModules.size(); i++) {
			SVGModule module = (SVGModule) myModules.get(i);
			moduleCombo.addItem(module);
		}

	}

	/**
	 * Resets the fields such as value text field
	 * 
	 * @author nareshg
	 */
	public void reset() {
		moduleCombo.setSelectedIndex(0);
		allowAll.setSelected(false);
		warnCheckBox.setSelected(false);
		valueTextField.setText(" ");
	}

	/**
	 * This updates the arraylist that is maintained for populating the table
	 * and storing
	 * 
	 * @param nameSpace
	 */
	public void updateNSList(SVGNameSpace nameSpace) {

		// if nameSpace is not here in the nameSpace list then add it ot list
		if (null != myNameSpaces) {
			if (myNameSpaces.size() == 0)
				myNameSpaces.add(nameSpace);
			boolean flag = false;
			for (int i = 0; i < myNameSpaces.size(); i++) {
				SVGNameSpace name = (SVGNameSpace) myNameSpaces.get(i);
				// compare for the nameSpace if matchs with the namespaces of
				// the List
				if (name.getnameSpaceName().equalsIgnoreCase(
						nameSpace.getnameSpaceName())) {
					flag = true;
					break;
				}
			}
			if (!flag)
				myNameSpaces.add(nameSpace);
		}

		// otherwise check the nameSpace in nameSpace List
		if (null != myNameSpaces) {
			for (int i = 0; i < myNameSpaces.size(); i++) {

				// compare for the nameSpace if matchs with the namespaces of
				// the List
				SVGNameSpace name = (SVGNameSpace) myNameSpaces.get(i);
				if (name.getnameSpaceName().equalsIgnoreCase(
						nameSpace.getnameSpaceName())) {
					ArrayList elements = nameSpace.getnameSpaceElements();
					if (null == elements)
						continue;

					// find the element for the under the namespace that is to
					// be added

					SVGElement element = null;
					for (i = 0; i < elements.size(); i++) {
						element = (SVGElement) elements.get(i);
						if (null == element)
							continue;

						if (null != name.getElementByTagName(element
								.getElementName())) {
							SVGElement elem = name.getElementByTagName(element
									.getElementName());
							ArrayList attributes = element
									.getElementAttributes();
							if (null == attributes)
								continue;

							for (int k = 0; k < attributes.size(); k++) {
								SVGAttribute attribute = (SVGAttribute) attributes
										.get(k);
								if (null != elem
										.getAttributeByTagName(attribute
												.getAttributeName())) {
									SVGAttribute tempAttr = (SVGAttribute) elem
											.getAttributeByTagName(attribute
													.getAttributeName());
									tempAttr.setWarned(attribute.isWarned());
									tempAttr.setMyValue(valueTextField
											.getText());
									continue;
								} else {
									SVGElement ele = name
											.getElementByTagName(element
													.getElementName());
									ele.addAttribute(attribute);
								}
							}// end for
						}// end if
						else
							name.addElement(element);
					}// end for
				}// end if
				else
					continue;
			}// end for
		}
	}

	/**
	 * populates the information which is obtain from the table when a table row
	 * is selected
	 * 
	 * @param tableInfo
	 */
	public void populateTableInfo(Vector tableInfo) {
		SVGNameSpace nameSpace = (SVGNameSpace) tableInfo.get(0);
		nameSpaceCombo.setSelectedItem(nameSpace);
		if (nameSpace.isURI())
			equalsRadioButton.setSelected(true);
		else
			equalsRadioButton.setSelected(false);

		if (nameSpace.isWarn())
			warnCheckBox.setSelected(true);
		else
			warnCheckBox.setSelected(false);

		if (nameSpace.isIsallowed())
			allowAll.setSelected(true);
		else
			allowAll.setSelected(false);

		elementCombo.removeAll();

		if (tableInfo.get(1) instanceof SVGElement) {
			SVGElement element = (SVGElement) tableInfo.get(1);
			for (int i = 0; i < myModules.size(); i++) {
				SVGModule module = (SVGModule) myModules.get(i);
				if (null != module
						.getElementByTagName(element.getElementName())) {
					elementCombo.addItem(module.getElementByTagName(element
							.getElementName()));
					elementCombo.setSelectedIndex(0);
					if (element.isWarned())
						warnCheckBox.setSelected(true);
					else
						warnCheckBox.setSelected(false);
					break;
				} else {
					elementCombo.addItem(element);
					elementCombo.setSelectedIndex(0);
					break;
				}
			}
			attributeCombo.removeAll();
			if (tableInfo.get(2) instanceof SVGAttribute) {
				SVGAttribute attribute = (SVGAttribute) tableInfo.get(2);
				if (true == attribute.isWarned())
					warnCheckBox.setSelected(true);
				else
					warnCheckBox.setSelected(false);
				attributeCombo.addItem(element.getAttributeByTagName(attribute
						.getAttributeName()));
				attributeCombo.setSelectedIndex(0);
				valueTextField.setText((String) attribute.getAttributeValue());
			}
		}
	}

	/**
	 * sets the namespace
	 * 
	 * @return it does not return any thing
	 */
	public void setMyNameSpaces(ArrayList list) {
		myNameSpaces = list;
	}

	/**
	 * gets the name space
	 * 
	 * @return it returns the arraylist containing all the namespaces
	 */
	public ArrayList getMyNameSpaces() {
		return myNameSpaces;
	}

	/**
	 * @return
	 */
	public SVGNameSpace getDesiredNameSpace() {
		return desiredNameSpace;
	}

	/**
	 * @param spaces
	 */
	public void setDesiredNameSpace(SVGNameSpace spaces) {
		desiredNameSpace = spaces;
	}
}
