/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

import org.w3c.dom.Document;

import com.nokia.svg2svgt.SVG2SVGTConstants;
import com.nokia.svg2svgt.ServiceRegistry;
import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.localiser.Localiser;
import com.nokia.svg2svgt.util.WCMatcher;
import com.nokia.svg2svgt.util.XMLFileParser;

/**
 * This is a class which generates the main Panel which in turn is added to the
 * converter frame as and when required
 * 
 */
public class ConfigPanel extends JPanel implements ActionListener,
		SVG2SVGTConstants, ConversionConstants, CaretListener {

	private SVGTConverterController myController = null;

	private JPanel mainPanel;

	private JPanel inputPanel;
	private TitledBorder titledBorder1;
	private JPanel selInFilesPanel;
	private JPanel selFilesPanel;

	private JPanel configPanel;
	private TitledBorder titledBorder2;

	private JPanel controlPanel;

	private JLabel selectIFlabel;
	private JList inputSVGFilesList;
	private JScrollPane inputSVGFilesScrollPane;
	private JButton inputSVGFilesButton;

	private JPanel outPanel;
	private JPanel passTPanel;
	private JPanel critcleSPanel;

	private JLabel outputDLabel;
	private JTextField outputDirTextField;
	private JButton outputDirButton;

	private JLabel passThroughLabel;
	private JTextField passThroughTextField;
	private JButton passThroughButton;

	private JLabel criticleFSLabel;
	private JTextField criticleFSTextField;
	private JLabel kBytes;

	private JButton convertButton;
	private JButton resetButton;
	private final String inputdir_key = "inputFilePath";
	private final String critical_key = "criticlesize";

	private Localiser myLocaliser = null;
	private Hashtable mytable = null;
	private boolean modified = false;
	Vector vector = null;
	Vector vector1 = null;
	private Frame frame = null;
	private SVG2SVGTMainView myMainVeiw = null;
	private ConFigButton config = null;

	public ConfigPanel(SVGTConverterController parent, Localiser localiser,
			Frame frame, ConFigButton config, SVG2SVGTMainView mainVeiw) {
		this.config = config;
		this.myLocaliser = localiser;
		myMainVeiw = mainVeiw;
		myController = parent;
		this.frame = frame;
		try {
			createConfigPanel();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * This methods is responsible for creating the main panel Which holds all
	 * other components in a logical order This function returns a panel
	 * containing all the components
	 */
	public void createConfigPanel() throws Exception {
		selectIFlabel = new JLabel(myLocaliser
				.getText("mainPanel.inputPanel.inputSVGFileslabel"));
		selectIFlabel.setPreferredSize(new Dimension(100, 24));
		selectIFlabel.setMaximumSize(new Dimension(100, 24));

		inputSVGFilesList = new JList();
		inputSVGFilesList.setModel(new DefaultListModel());
		inputSVGFilesList.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.selectIFTextField"));

		inputSVGFilesScrollPane = new JScrollPane(inputSVGFilesList);
		inputSVGFilesScrollPane.setPreferredSize(new Dimension(180, 60));
		inputSVGFilesScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE,
				Integer.MAX_VALUE));

		inputSVGFilesButton = new JButton(myLocaliser
				.getText("mainPanel.Button"));
		inputSVGFilesButton.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.selectIFButton"));
		inputSVGFilesButton.setPreferredSize(new Dimension(90, 24));
		inputSVGFilesButton.setMaximumSize(new Dimension(90, 24));
		inputSVGFilesButton.addActionListener(this);

		inputPanel = new JPanel();
		inputPanel.setLayout(new BoxLayout(inputPanel, BoxLayout.X_AXIS));
		inputPanel.setPreferredSize(new Dimension(397, 96));
		inputPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE,
				Integer.MAX_VALUE));
		titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(148, 145, 140)), myLocaliser
				.getText("mainPanel.inputPanel.Title"));
		inputPanel.setBorder(titledBorder1);
		inputPanel.add(Box.createHorizontalStrut(12));
		inputPanel.add(selectIFlabel);
		inputPanel.add(Box.createHorizontalStrut(5));
		inputPanel.add(inputSVGFilesScrollPane);
		inputPanel.add(Box.createHorizontalStrut(5));
		inputPanel.add(inputSVGFilesButton);
		inputPanel.add(Box.createHorizontalStrut(12));

		outputDLabel = new JLabel(myLocaliser.getText("mainPanel.outputDLabel"));
		outputDLabel.setPreferredSize(new Dimension(100, 24));
		outputDLabel.setMaximumSize(new Dimension(100, 24));

		outputDirTextField = new JTextField("");
		outputDirTextField.setToolTipText(myLocaliser
				.getToolTipText("mainpanel.outputDTextField"));
		outputDirTextField.setPreferredSize(new Dimension(180, 24));
		outputDirTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
		outputDirTextField.setEditable(false);
		outputDirTextField.setBackground(Color.WHITE);
		outputDirTextField.addCaretListener(this);

		outputDirButton = new JButton(myLocaliser.getText("mainPanel.Button"));
		outputDirButton.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.outputDButton"));
		outputDirButton.setPreferredSize(new Dimension(90, 24));
		outputDirButton.setMaximumSize(new Dimension(90, 24));
		outputDirButton.addActionListener(this);

		outPanel = new JPanel();
		outPanel.setLayout(new BoxLayout(outPanel, BoxLayout.X_AXIS));
		outPanel.setPreferredSize(new Dimension(397, 36));
		outPanel.add(Box.createHorizontalStrut(12));
		outPanel.add(outputDLabel);
		outPanel.add(Box.createHorizontalStrut(5));
		outPanel.add(outputDirTextField);
		outPanel.add(Box.createHorizontalStrut(5));
		outPanel.add(outputDirButton);
		outPanel.add(Box.createHorizontalStrut(12));

		passThroughLabel = new JLabel(myLocaliser
				.getText("mainPanel.passThroughLabel"));
		passThroughLabel.setMaximumSize(new Dimension(100, 24));
		passThroughLabel.setPreferredSize(new Dimension(100, 24));

		passThroughTextField = new JTextField("");
		passThroughTextField.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.PassThroughTextField"));
		passThroughTextField.setPreferredSize(new Dimension(180, 24));
		passThroughTextField
				.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
		passThroughTextField.setEditable(false);
		passThroughTextField.setBackground(Color.WHITE);
		passThroughTextField.addCaretListener(this);

		passThroughButton = new JButton(myLocaliser.getText("mainPanel.Button"));
		passThroughButton.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.PassThroughButton"));
		passThroughButton.setPreferredSize(new Dimension(90, 24));
		passThroughButton.setMaximumSize(new Dimension(90, 24));
		passThroughButton.addActionListener(this);

		passTPanel = new JPanel();
		passTPanel.setLayout(new BoxLayout(passTPanel, BoxLayout.X_AXIS));
		passTPanel.add(Box.createHorizontalStrut(12));
		passTPanel.add(passThroughLabel);
		passTPanel.add(Box.createHorizontalStrut(5));
		passTPanel.add(passThroughTextField);
		passTPanel.add(Box.createHorizontalStrut(5));
		passTPanel.add(passThroughButton);
		passTPanel.add(Box.createHorizontalStrut(12));

		criticleFSLabel = new JLabel(myLocaliser
				.getText("mainPanel.criticleFSLabel"));
		criticleFSLabel.setPreferredSize(new Dimension(100, 24));
		criticleFSLabel.setMaximumSize(new Dimension(100, 24));

		criticleFSTextField = new JTextField("");
		criticleFSTextField.setToolTipText(myLocaliser
				.getToolTipText("mainPanel.criticleFSTextField"));
		criticleFSTextField.setPreferredSize(new Dimension(180, 24));
		criticleFSTextField
				.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
		criticleFSTextField.addCaretListener(this);

		kBytes = new JLabel(myLocaliser.getText("mainPanel.kBytes"));
		kBytes.setPreferredSize(new Dimension(90, 24));
		kBytes.setMaximumSize(new Dimension(90, 24));

		critcleSPanel = new JPanel();
		critcleSPanel.setLayout(new BoxLayout(critcleSPanel, BoxLayout.X_AXIS));
		critcleSPanel.setPreferredSize(new Dimension(397, 36));
		critcleSPanel.add(Box.createHorizontalStrut(12));
		critcleSPanel.add(criticleFSLabel);
		critcleSPanel.add(Box.createHorizontalStrut(5));
		critcleSPanel.add(criticleFSTextField);
		critcleSPanel.add(Box.createHorizontalStrut(5));
		critcleSPanel.add(kBytes);
		critcleSPanel.add(Box.createHorizontalStrut(12));

		configPanel = new JPanel();
		configPanel.setLayout(new BoxLayout(configPanel, BoxLayout.Y_AXIS));
		configPanel.setPreferredSize(new Dimension(397, 130));
		configPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE,
				Integer.MAX_VALUE));
		titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(148, 145, 140)), myLocaliser
				.getText("mainPanel.configPanel.title"));
		configPanel.setBorder(titledBorder2);
		configPanel.add(Box.createVerticalStrut(5));
		configPanel.add(outPanel);
		configPanel.add(Box.createVerticalStrut(5));
		configPanel.add(passTPanel);
		configPanel.add(Box.createVerticalStrut(5));
		configPanel.add(critcleSPanel);
		configPanel.add(Box.createVerticalStrut(5));

		convertButton = new JButton(myLocaliser
				.getText("mainPanel.convertButton"));
		convertButton.setPreferredSize(new Dimension(80, 24));
		convertButton.setMaximumSize(new Dimension(80, 24));
		convertButton.setEnabled(false);
		convertButton.addActionListener(this);

		resetButton = new JButton(myLocaliser.getText("mainPanel.resetButton"));
		resetButton.setPreferredSize(new Dimension(80, 24));
		resetButton.setMaximumSize(new Dimension(80, 24));
		resetButton.addActionListener(this);

		controlPanel = new JPanel();
		controlPanel.setLayout(new BoxLayout(controlPanel, BoxLayout.X_AXIS));
		controlPanel.setPreferredSize(new Dimension(397, 36));
		controlPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE,
				Integer.MAX_VALUE));
		controlPanel.add(Box.createHorizontalGlue());
		controlPanel.add(convertButton);
		controlPanel.add(Box.createHorizontalStrut(5));
		controlPanel.add(resetButton);
		controlPanel.add(Box.createHorizontalGlue());

		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this
				.setMaximumSize(new Dimension(Integer.MAX_VALUE,
						Integer.MAX_VALUE));
		this.add(Box.createVerticalStrut(5));
		this.add(inputPanel);
		this.add(Box.createVerticalStrut(5));
		this.add(configPanel);
		this.add(Box.createVerticalStrut(5));
		this.add(controlPanel);
		this.add(Box.createVerticalStrut(5));
		this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		inputSVGFilesList.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_DELETE) {
					int toBeDeletedItem = inputSVGFilesList.getSelectedIndex();
					vector.remove(inputSVGFilesList.getModel().getElementAt(
							toBeDeletedItem));
					inputSVGFilesList.setListData(vector);
				}
			}
		});

		inputSVGFilesList.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if (null != inputSVGFilesList) {
					if (null != inputSVGFilesList.getSelectedValues()) {
						convertButton.setEnabled(true);
					}
					if (null == inputSVGFilesList.getSelectedValue()) {
						convertButton.setEnabled(false);
					}
					if (inputSVGFilesList.isSelectionEmpty()) {
						config.setIfListisEmty(true);
					} else {
						config.setIfListisEmty(false);
					}
				}
			}
		});

	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(inputSVGFilesButton)) {
			String inputFilePath = (String) mytable.get(inputdir_key);
			SVGTFileChooser svgChooser = new SVGTFileChooser(frame, "Add");
			if (inputFilePath == null) {
				inputFilePath = myLocaliser.getText("CurrentDirectory");
			}
			svgChooser.setMyCurrentDirectory(new File(inputFilePath));
			svgChooser.setLocation(frame.getLocation().x + 50, frame
					.getLocation().y + 50);
			svgChooser.showCustomFileChooser();

			ServiceRegistry.registerService(svgChooser);
			File[] file = svgChooser.getSelectedSVGFiles();

			if (file == null)
				return;
			int[] filelength = new int[file.length];
			vector = new Vector();
			for (int i = 0; i < file.length; i++) {
				vector.add(file[i].getAbsolutePath());
				filelength[i] = i;
			}
			vector1 = new Vector();
			if (svgChooser.isCanceled() == false) {
				if (true == svgChooser.isAddOrAddWithWildCards()) {
					inputSVGFilesList.setListData(vector);
					inputSVGFilesList.setSelectedIndices(filelength);
				} else {
					String charseq = svgChooser.getMyCharSeq();
					vector1.add(charseq);

					inputSVGFilesList.setListData(vector1);
					inputSVGFilesList.setSelectedIndex(0);
				}

			}
			inputFilePath = ((File) svgChooser.getMyCurrentDirectory())
					.getAbsolutePath();
			mytable.put(inputdir_key, inputFilePath);
		} else if (e.getSource().equals(outputDirButton)) {

			String outputFilePath = (String) mytable
					.get(SVG2SVGTConstants.OUTDIR);
			if (outputFilePath == null) {
				outputFilePath = myLocaliser.getText("DefaultOutputDirectory");
			}
			JFileChooser chooser = new JFileChooser(new File(outputFilePath));
			chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
			chooser.setFileFilter(new MyFilter(null));
			int approved = chooser.showOpenDialog((Component) e.getSource());
			if (approved == JFileChooser.APPROVE_OPTION) {
				outputDirTextField.setText((String) chooser.getSelectedFile()
						.getAbsolutePath());
				mytable.put(SVG2SVGTConstants.OUTDIR, chooser.getSelectedFile()
						.getAbsolutePath());
			}
		} else if (e.getSource().equals(passThroughButton)) {

			String passThroughFilePath = (String) mytable
					.get(SVG2SVGTConstants.PASSTHROUGH_FILE);
			if (passThroughFilePath == null) {
				passThroughFilePath = myLocaliser
						.getText("DefaultPassThroughFile");
			}

			File fileE = new File(passThroughFilePath);
			System.out.println("file " + fileE.getAbsolutePath());
			JFileChooser chooser;

			try {

				chooser = new JFileChooser(new File(fileE.getCanonicalPath()));
				MyFileFilter filter = new MyFileFilter("*.xml");
				FileFilter fil = chooser.getFileFilter();
				chooser.setCurrentDirectory(new File(fileE.getCanonicalPath()));
				chooser.removeChoosableFileFilter(fil);
				chooser.addChoosableFileFilter(filter);
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int approved = chooser.showOpenDialog(this);
				if (approved == JFileChooser.APPROVE_OPTION) {
					if (true == checkForValidatePassThrough(chooser
							.getSelectedFile().getAbsolutePath())) {
						passThroughTextField.setText((String) chooser
								.getSelectedFile().getAbsolutePath());
						passThroughFilePath = chooser.getSelectedFile()
								.getAbsolutePath();
						mytable.put(SVG2SVGTConstants.PASSTHROUGH_FILE,
								passThroughFilePath);
						mytable.put(critical_key, "10");
					} else {
						JOptionPane.showMessageDialog(passThroughButton,
								"Invalid PassThrough File");
						passThroughTextField.setText(" ");
					}
				}
			} catch (Exception ek) {
				System.out.println("Theeeeeeeeeeee");
			}
		} else if (e.getSource().equals(convertButton)) {
			myMainVeiw.clearTextArea();
			setCursor(new Cursor(Cursor.WAIT_CURSOR));
			covertion();
			setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		} else if (e.getSource().equals(resetButton)) {
			reset();
		}

	}

	public boolean checkForValidatePassThrough(String string) {
		try {
			Document document = XMLFileParser.parseFile(string, true);
			org.w3c.dom.Element element = document.getDocumentElement();
			if (element.getNodeName().equals(TAG_PASSTHROUGH_ROOT)) {
				return true;
			}
		} catch (Exception e) {
			// e.printStackTrace();
		}
		return false;
	}

	/**
	 * This method is used to reset all the fields in the configuration panel.
	 */
	public void reset() {
		outputDirTextField.setText("");
		passThroughTextField.setText("");
		criticleFSTextField.setText("");
	}

	/**
	 * This the main conversion function which is responsible for the conversion
	 * of a SVG to SVGT.
	 */
	public void covertion() {
		Hashtable params = new Hashtable();
		ArrayList svgList = new ArrayList();

		Object[] listofSVGs = inputSVGFilesList.getSelectedValues();
		if (null != listofSVGs) {
			String checkWhetherValid = null;
			checkWhetherValid = (String) listofSVGs[0];
			if ((-1 != checkWhetherValid.indexOf("*"))
					|| (-1 != checkWhetherValid.indexOf("?"))) {
				SVGTFileChooser chooser = (SVGTFileChooser) ServiceRegistry
						.getService("com.nokia.svg2svgt.gui.SVGTFileChooser");
				chooser.getConvertionFiles();
				File[] files = chooser.getSelectedSVGFiles();
				for (int i = 0; i < files.length; i++) {
					svgList.add(i, files[i].getAbsolutePath());
				}
			} else {
				for (int i = 0; i < listofSVGs.length; i++) {
					svgList.add(i, (String) listofSVGs[i]);
				}

			}
		}

		String size = criticleFSTextField.getText();
		if ((null == size) || (size.equals(""))) {
			size = "1000";
		}

		String outDir = outputDirTextField.getText();
		if ((null == outDir) || (outDir.equals(""))) {
			outDir = myLocaliser.getText("DefaultOutputDirectory");
		}

		String passthroughfile = passThroughTextField.getText();
		boolean valid = checkForValidatePassThrough(passthroughfile);
		if (valid == false) {
			JOptionPane
					.showMessageDialog(frame,
							"Invalid PassThrough File. Taking the default pass through file. ");
			passthroughfile = myLocaliser.getText("DefaultPassThroughFile");
		}
		params.put(SVG2SVGTConstants.SVGFILE_OPTION, svgList);
		params.put(SVG2SVGTConstants.OUTDIR_OPTION, outDir);
		params.put(SVG2SVGTConstants.PASSTHROUGHFILE_OPTION, passthroughfile);
		params.put(SVG2SVGTConstants.CRITICAL_SIZE, size);
		params.put(SVG2SVGTConstants.CONVERSIONSFILE_OPTION, myLocaliser
				.getText("ConversionPropertiesFile"));

		myController.doConvert(params);
	}

	public boolean isModified() {
		return modified;
	}

	public void setModified(boolean b) {
		modified = b;
	}

	public void caretUpdate(CaretEvent e) {
		setModified(true);
	}

	public Hashtable getConfigHashTable() {
		Hashtable config = new Hashtable();
		config.put(SVG2SVGTConstants.OUTDIR, outputDirTextField.getText());
		config.put(SVG2SVGTConstants.PASSTHROUGH_FILE, passThroughTextField
				.getText());
		config.put(SVG2SVGTConstants.CRITICAL_SIZE, criticleFSTextField
				.getText());
		return config;
	}

	public void setConfigHashTable(Hashtable config) {
		String[] fields = { SVG2SVGTConstants.OUTDIR,
				SVG2SVGTConstants.PASSTHROUGH_FILE };
		outputDirTextField.setText((String) config.get(fields[0]));
		File file = new File((String) config.get(fields[1]));
		passThroughTextField.setText(file.getAbsolutePath());
		criticleFSTextField.setText((String) config
				.get(SVG2SVGTConstants.CRITICAL_SIZE));
	}

	public boolean isFieldsEmpty() {
		if ((outputDirTextField.getText().equals(null) || outputDirTextField
				.getText().trim().length() == 0)
				&& (passThroughTextField.getText().equals(null) || passThroughTextField
						.getText().trim().length() == 0)
				&& (criticleFSTextField.getText().equals(null) || criticleFSTextField
						.getText().trim().length() == 0)) {
			return true;
		} else {
			return false;
		}
	}

	public void setTable(Hashtable table) {
		this.mytable = table;
	}

	public Hashtable getTable() {
		return mytable;
	}

	private class MyFilter extends FileFilter {
		private String myFilteringCriteria = null;

		public MyFilter(String filter) {
			myFilteringCriteria = filter;
		}

		public boolean accept(File fileName) {
			if (true == fileName.isDirectory())
				return true;

			return false;
		}

		public String getDescription() {
			return myFilteringCriteria;
		}
	}

	private class MyFileFilter extends FileFilter {
		private String myFilteringCriteria = null;

		public MyFileFilter(String filter) {
			myFilteringCriteria = filter;
		}

		public boolean accept(File fileName) {

			if (true == fileName.isDirectory()) {
				return true;
			}

			return WCMatcher.match(myFilteringCriteria, fileName.getName());
		}

		public String getDescription() {
			return myFilteringCriteria;
		}
	}

}

// String passthroughfile = passThroughTextField.getText();
// boolean valid = checkForValidatePassThrough( passthroughfile );
// if( false == valid )
// {
// JOptionPane.showMessageDialog( this , "Invalid passthrough file !");
// }

