/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

import com.nokia.svg2svgt.localiser.Localiser;

/**
 * This dialog is show the some information about SVG to SVGT converter
 * 
 */
public class ConvertDialog extends JDialog implements ActionListener {
	/*
	 * Components of the dialog box
	 */
	private JPanel panel;
	private JScrollPane textAreaScrollpane;
	private JTextArea textArea;
	private EtchedBorder border;
	private JButton oKButton;
	private JLabel versionLabel;
	Localiser localizer = null;

	/*
	 * this the constructor of the dialog class
	 */
	public ConvertDialog(Frame frame, Localiser localiser)
			throws HeadlessException {
		super(frame);
		this.localizer = localiser;
		createDialog();
	}

	/*
	 * This method is to create a dialog
	 */
	private void createDialog() {
		panel = new JPanel();
		panel.setLayout(null);
		panel.setBounds(1, 1, 350, 200);

		textArea = new JTextArea();
		textArea.setLineWrap(true);
		textArea.setEditable(false);
		// textArea.setEditable(true);
		border = new EtchedBorder();
		textArea.setBorder(border);
		textArea.setWrapStyleWord(true);
		textArea.setText(localizer.getText("AboutDialog.textArea"));
		textAreaScrollpane = new JScrollPane(textArea);
		textAreaScrollpane.setBounds(10, 10, 330, 100);
		;
		panel.add(textAreaScrollpane);

		versionLabel = new JLabel(localizer.getText("AboutDialog.versionLabel"));
		versionLabel.setBounds(155, 112, 100, 24);
		panel.add(versionLabel);
		oKButton = new JButton(localizer.getText("AboutDialog.oKButton"));
		oKButton.setBounds(145, 148, 60, 24);
		oKButton.addActionListener(this);
		panel.add(oKButton);
		this.setResizable(false);
		getContentPane().add(panel);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		this.dispose();
	}
}
