/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

package com.nokia.svg2svgt.gui;

import javax.swing.*;
import java.awt.Container;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import java.io.File;

public class CustomFileChooser implements ListSelectionListener {
	private static JTextField textField = null;
	private JViewport viewport;
	static JList listTo = null;
	static JButton textButton = null;

	public CustomFileChooser() {
		listTo.addListSelectionListener(this);
	}

	public static JTextField makeComponentInvisible(Container cont,
			String fieldName) {
		int n = cont.getComponentCount();
		for (int i = 0; i < n; i++) {
			JComponent comp = null;
			try {
				comp = (JComponent) cont.getComponent(i);
			} catch (Exception e) {
				continue;
			}
			if (comp instanceof JTextField) {
				textField = ((JTextField) comp);
			}
			if (cont instanceof JList) {
				System.out.println("Keep List trying please ");
				listTo = (JList) cont;
			}
			if (comp instanceof Container) {
				try {
					makeComponentInvisible((Container) comp, fieldName);
				} catch (Exception e) {
				}
			}
		}
		return textField;
	}

	public static JButton getButton(Container cont, String fieldName) {
		int n = cont.getComponentCount();
		for (int i = 0; i < n; i++) {
			JComponent comp = null;
			try {
				comp = (JComponent) cont.getComponent(i);
			} catch (Exception e) {
				continue;
			}
			if (comp instanceof JButton) {
				if (((JButton) comp).getText().equals("Add")) {
					textButton = ((JButton) comp);
					return textButton;
				}
			}
			if (comp instanceof Container) {
				try {
					getButton((Container) comp, fieldName);
				} catch (Exception e) {
				}
			}
		}
		return textButton;
	}

	public void valueChanged(ListSelectionEvent listSelectionEvent) {
		Object[] files = listTo.getSelectedValues();
		if (listTo.getSelectedValues() != null) {
			String x = "";
			for (int i = 0; i < files.length; i++) {
				if (1 == files.length) {
					x = new File(files[0].toString()).getName();
				} else {
					x = x + "\"";
					x = x + new File(files[i].toString()).getName();
					x = x + "\"";
					x = x + " ";
				}
			}
			textField.setText(x);
		}
	}

}
