/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

/**
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

import com.nokia.svg2svgt.converter.ConversionConstants;
import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.localiser.Localiser;

public class PassThroughPanel extends JPanel implements ActionListener,
		ConversionConstants {

	private SVGTConverterController myController = null;

	private JPanel tablePanel;
	private CustomTableModel dtm;
	private JTable nameSpaceTable;
	private TitledBorder titledBorder2;
	private JScrollPane scroll;

	private JButton addButton;
	private JButton removeButton;
	private JButton editButton;
	private JPanel buttonPanel;

	private Vector rowData;
	private Vector columns;
	private Vector rows;

	private ArrayList myNameSpaces = null;
	// private ArrayList myDefaultNameSpaces = null;
	Localiser myLocaliser = null;
	AddDialog addDialog = null;
	private boolean changed = false;
	int selectedRow = 0;
	private Frame myMainFrame = null;

	/**
	 * This the constructor of the black list panel creation class which
	 * involves in calling the createBlacklistPanel method.
	 * 
	 * @param parent
	 * @param localiser
	 * @param frame
	 */
	public PassThroughPanel(SVGTConverterController parent,
			Localiser localiser, Frame frame) {
		myMainFrame = frame;
		myController = parent;
		myLocaliser = localiser;
		try {
			addDialog = new AddDialog(frame, myLocaliser, myLocaliser
					.getText("Add.title"));
			//SVG2SVGTConverterApplication.getHelpMediator().registerComponent((
			// JFrame ) addDialog,"MENU_BAR");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		try {
			createPanel();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * This is the method which is responsible for creating the table and the
	 * panel containing the gray list and black list tables and control buttons.
	 */
	public void createPanel() throws Exception {

		titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(
				Color.white, new Color(148, 145, 140)), myLocaliser
				.getText("PassThrough.Title"));

		tablePanel = new JPanel();
		tablePanel.setLayout(new BorderLayout());
		tablePanel.setBorder(titledBorder2);

		columns = new Vector();
		columns.add(myLocaliser.getText("PassThrough.table.column0"));
		columns.add(myLocaliser.getText("PassThrough.table.column1"));
		columns.add(myLocaliser.getText("PassThrough.table.column2"));
		columns.add(myLocaliser.getText("PassThrough.table.column3"));

		dtm = new CustomTableModel();
		dtm.setDataVector(null, columns);
		nameSpaceTable = new JTable(dtm);
		nameSpaceTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		(nameSpaceTable.getTableHeader()).setReorderingAllowed(false);

		scroll = new JScrollPane();
		scroll.setBorder(BorderFactory.createLoweredBevelBorder());
		scroll.getViewport().add(nameSpaceTable);
		tablePanel.add(scroll);

		buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setPreferredSize(new Dimension(397, 36));

		addButton = new JButton(myLocaliser.getText("PassThrough.Addbutton"));
		addButton.setPreferredSize(new Dimension(80, 24));
		addButton.addActionListener(this);

		removeButton = new JButton(myLocaliser
				.getText("PassThrough.Removebutton"));
		removeButton.setPreferredSize(new Dimension(80, 24));
		removeButton.addActionListener(this);

		editButton = new JButton(myLocaliser.getText("PassThrough.Editbutton"));
		editButton.setPreferredSize(new Dimension(80, 24));
		editButton.addActionListener(this);

		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(addButton);
		buttonPanel.add(Box.createHorizontalStrut(5));
		buttonPanel.add(removeButton);
		buttonPanel.add(Box.createHorizontalStrut(5));
		buttonPanel.add(editButton);
		buttonPanel.add(Box.createHorizontalGlue());

		nameSpaceTable.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() > 1) {
					setChanged(true);
					edit();
				}
			}
		});

		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.add(Box.createVerticalGlue());
		this.add(tablePanel);
		this.add(Box.createVerticalGlue());
		this.add(buttonPanel);
		this.add(Box.createVerticalGlue());
		this.setPreferredSize(new Dimension(400, 291));
		this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		nameSpaceTable.getSelectionModel().addListSelectionListener(
				new ListSelectionListener() {
					public void valueChanged(ListSelectionEvent e) {
						if ((0 == nameSpaceTable.getRowCount())
								|| (nameSpaceTable.getSelectedRows().length == 0)) {
							removeButton.setEnabled(false);
							editButton.setEnabled(false);
						} else if (nameSpaceTable.getSelectedRows().length > 1) {
							editButton.setEnabled(false);
							removeButton.setEnabled(true);
						} else {
							editButton.setEnabled(true);
							removeButton.setEnabled(true);
						}
					}
				});

		nameSpaceTable.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_DELETE) {
					setChanged(true);
					int i[] = nameSpaceTable.getSelectedRows();
					Vector temp = new Vector();

					if (null != i) {
						Vector dataVector = dtm.getDataVector();
						for (int j = 0; j < i.length; j++) {
							Vector rowData = new Vector();
							try {
								rowData.add(dtm.getValueAt(i[j] - j, 0));
								rowData.add(dtm.getValueAt(i[j] - j, 1));
								rowData.add(dtm.getValueAt(i[j] - j, 2));
								rowData.add(dtm.getValueAt(i[j] - j, 3));
								temp.add(rowData);
								dtm.removeRow(i[j] - j);
							} catch (Exception e1) {
								System.out
										.println("Array Index Out Of Bounds :"
												+ e1.getMessage());
							}
						}
					}
					removeFromList(temp);
				}
			}
		});

	}

	public void actionPerformed(ActionEvent ae) {
		if (ae.getActionCommand().equals(
				myLocaliser.getText("PassThrough.Addbutton"))) {
			setChanged(true);
			addDialog.setMyNameSpaces(myNameSpaces);
			addDialog.populateDialog();
			addDialog.reset();
			addDialog.setTitle(myLocaliser.getText("Add.title"));
			addDialog.setSize(330, 434);
			addDialog.setResizable(false);
			addDialog.setLocation(300, 140);
			addDialog.setVisible(true);
			addDialog.setModal(true);
			addDialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			setMyNameSpaces(addDialog.getMyNameSpaces());
			populateTable();
		} else if (ae.getActionCommand().equals(
				myLocaliser.getText("PassThrough.Removebutton"))) {
			setChanged(true);
			int i[] = nameSpaceTable.getSelectedRows();
			int selRow = i[0];
			Vector temp = new Vector();
			if (null != i) {
				Vector dataVector = dtm.getDataVector();
				for (int j = 0; j < i.length; j++) {
					Vector rowData = new Vector();
					try {
						rowData.add(dtm.getValueAt(i[j] - j, 0));
						rowData.add(dtm.getValueAt(i[j] - j, 1));
						rowData.add(dtm.getValueAt(i[j] - j, 2));
						rowData.add(dtm.getValueAt(i[j] - j, 3));
						temp.add(rowData);
						dtm.removeRow(i[j] - j);
					} catch (Exception e) {
						System.out.println("Array Index Out Of Bounds :"
								+ e.getMessage());
					}
				}
			}
			removeFromList(temp);

			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.SINGLE_SELECTION);

			if (-1 != (selRow - 1)) {
				nameSpaceTable.getSelectionModel().setLeadSelectionIndex(
						selRow - 1);
			} else {
				nameSpaceTable.getSelectionModel().setLeadSelectionIndex(0);
			}
			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		} else if (ae.getActionCommand().equals(
				myLocaliser.getText("PassThrough.Editbutton"))) {
			setChanged(true);
			edit();
		}
	}

	/**
     * 
     */
	private void edit() {
		selectedRow = nameSpaceTable.getSelectedRow();
		if (-1 != selectedRow) {
			Vector tableInfo = new Vector();
			tableInfo.add((SVGNameSpace) dtm.getValueAt(selectedRow, 0));
			tableInfo.add(dtm.getValueAt(selectedRow, 1));
			tableInfo.add(dtm.getValueAt(selectedRow, 2));
			tableInfo.add(dtm.getValueAt(selectedRow, 3));

			addDialog.setMyNameSpaces(myNameSpaces);
			addDialog.populateDialog();
			addDialog.reset();
			addDialog.populateTableInfo(tableInfo);
			addDialog.setTitle(myLocaliser.getText("Edit.title"));
			addDialog.setSize(330, 434);
			addDialog.setResizable(false);
			addDialog.setLocation(300, 140);
			addDialog.setVisible(true);
			addDialog.setModal(true);
			addDialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			setMyNameSpaces(addDialog.getMyNameSpaces());
			populateTable();
		}
	}

	private void removeFromList(Vector temp) {

		for (int i = 0; i < temp.size(); i++) {
			Vector temp2 = new Vector();
			temp2 = (Vector) temp.get(i);
			if ((null == myNameSpaces) || (null == temp2)) {
				return;
			}

			SVGNameSpace svgNamespace = (SVGNameSpace) temp2.get(0);
			SVGElement svgElement = null;
			if (null != temp2.get(1) && (temp2.get(1) instanceof SVGElement)) {
				svgElement = (SVGElement) temp2.get(1);
			}
			SVGAttribute svgAttribute = null;
			if (null != temp2.get(2) && (temp2.get(2) instanceof SVGAttribute)) {
				svgAttribute = (SVGAttribute) temp2.get(2);
			}

			String value = (String) temp2.get(3);

			SVGNameSpace svgName = null;
			SVGElement svgEle = null;
			SVGAttribute svgAttr = null;
			String valueOfAttr = null;

			for (int a = 0; a < myNameSpaces.size(); a++) {
				svgName = (SVGNameSpace) myNameSpaces.get(a);
				if (svgName.getnameSpaceName().equalsIgnoreCase(
						svgNamespace.getnameSpaceName())) {
					if (null != svgElement) {
						if (-1 != svgName.containsElement(svgElement
								.getElementName())) {
							svgElement = svgName.getElementByTagName(svgElement
									.getElementName());
							if (null != svgAttribute) {
								System.out.println("Deleteing svgElement "
										+ svgElement.hashCode());
								if (value.equals("      -   ")
										|| (null != value)) {
									if (-1 != svgElement
											.containsAttribute(svgAttribute
													.getAttributeName())) {
										svgElement.removeAttribute(svgAttribute
												.getAttributeName());
									}
								} else {
									if (-1 != svgElement.containsAttribute(
											svgAttribute.getAttributeName(),
											value)) {
										svgElement.removeAttribute(svgAttribute
												.getAttributeName(), value);
									}
								}

							}
						}
					}
				}
			}
			for (int a = 0; a < myNameSpaces.size(); a++) {
				svgName = (SVGNameSpace) myNameSpaces.get(a);
				ArrayList elements = svgName.getnameSpaceElements();
				if (elements == null)
					continue;
				for (int j = 0; j < elements.size(); j++) {
					svgElement = (SVGElement) elements.get(j);
					if (0 == svgElement.getElementAttributes().size()) {
						svgName.removeElement(svgElement.getElementName());
						((SVGNameSpace) myNameSpaces.get(a))
								.removeElement(svgElement.getElementName());
					}
				}
			}
			for (int a = 0; a < myNameSpaces.size(); a++) {
				svgName = (SVGNameSpace) myNameSpaces.get(a);
				ArrayList elements = svgName.getnameSpaceElements();
				if (null == elements || 0 == elements.size()) {
					myNameSpaces.remove(a);
				}
			}
		}
	}

	public void populateTable() {
		int rowCount = dtm.getRowCount();
		if (rowCount != 0) {
			Vector temp = new Vector();
			Vector dataVector = dtm.getDataVector();
			for (int j = 0; j < rowCount; j++) {
				temp.add(dataVector.get(j));
			}
			for (int k = 0; k < temp.size(); k++) {
				Object obj = temp.get(k);
				dataVector.remove(obj);
			}
			dtm.fireTableRowsDeleted(0, rowCount - 1);
		}

		SVGNameSpace dname = addDialog.getDesiredNameSpace();
		SVGNameSpace nameSpace = null;
		SVGElement element = null;

		if (null == myNameSpaces)
			return;
		if (null == dtm)
			return;

		for (int i = 0; i < myNameSpaces.size(); i++) {
			nameSpace = (SVGNameSpace) myNameSpaces.get(i);
			ArrayList allelements = nameSpace.getnameSpaceElements();
			if (null == nameSpace)
				continue;
			if (null == allelements) {
				Vector rowData = new Vector();
				rowData.add(nameSpace);
				rowData.add(" -");
				rowData.add(" -");
				rowData.add(" -");
				dtm.addRow(rowData);
				continue;
			}

			for (int j = 0; j < allelements.size(); j++) {
				element = (SVGElement) nameSpace.getnameSpaceElements().get(j);

				ArrayList allattributes = (ArrayList) element
						.getElementAttributes();

				if (null == element)
					continue;
				if (null == allattributes) {
					Vector rowData = new Vector();
					rowData.add(nameSpace);
					rowData.add(element);
					rowData.add(" -");
					rowData.add(" -");
					dtm.addRow(rowData);
					continue;
				}

				for (int k = 0; k < allattributes.size(); k++) {
					SVGAttribute attribute = (SVGAttribute) allattributes
							.get(k);

					if ((null == attribute) || (null == allattributes))
						continue;

					Vector rowdata = new Vector();
					rowdata.add(nameSpace);
					rowdata.add(element);
					rowdata.add(attribute);
					// System.out.println(nameSpace.toString() +
					// element.toString() +
					// attribute.toString()+attribute.getAttributeValue() );
					if (null == attribute.getAttributeValue())
						rowdata.add("      -   ");
					else
						rowdata.add(attribute.getAttributeValue());

					dtm.addRow(rowdata);
				}// end of second for
			}// end of first for
		}
		if (dtm.getRowCount() > 1) {
			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.SINGLE_SELECTION);
			nameSpaceTable.getSelectionModel().setLeadSelectionIndex(
					selectedRow);
			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		} else
			nameSpaceTable.clearSelection();
	}

	public void setMyNameSpaces(ArrayList list) {
		myNameSpaces = list;
	}

	public ArrayList getMyNameSpaces() {
		return myNameSpaces;
	}

	public void populateTable(ArrayList list) {
		if (null == list) {
			return;
		}

		int rowCount = dtm.getRowCount();
		if (rowCount != 0) {
			Vector temp = new Vector();
			Vector dataVector = dtm.getDataVector();
			for (int j = 0; j < rowCount; j++) {
				temp.add(dataVector.get(j));
			}
			for (int k = 0; k < temp.size(); k++) {
				Object obj = temp.get(k);
				dataVector.remove(obj);
			}
			dtm.fireTableRowsDeleted(0, rowCount - 1);
		}

		SVGNameSpace dname = addDialog.getDesiredNameSpace();
		SVGNameSpace nameSpace = null;
		SVGElement element = null;

		if (null == dtm) {
			return;
		}

		for (int i = 0; i < list.size(); i++) {
			nameSpace = (SVGNameSpace) list.get(i);
			ArrayList allelements = nameSpace.getnameSpaceElements();
			if (null == nameSpace)
				continue;
			if (null == allelements) {
				Vector rowData = new Vector();
				rowData.add(nameSpace);
				rowData.add(" -");
				rowData.add(" -");
				rowData.add(" -");
				dtm.addRow(rowData);
				continue;
			}
			for (int j = 0; j < allelements.size(); j++) {
				element = (SVGElement) nameSpace.getnameSpaceElements().get(j);

				ArrayList allattributes = (ArrayList) element
						.getElementAttributes();
				if (null == element)
					continue;
				if (null == allattributes) {
					Vector rowData = new Vector();
					rowData.add(nameSpace);
					rowData.add(element);
					rowData.add(" -");
					rowData.add(" -");
					dtm.addRow(rowData);
					continue;
				}

				for (int k = 0; k < allattributes.size(); k++) {
					SVGAttribute attribute = (SVGAttribute) allattributes
							.get(k);

					if ((null == attribute) || (null == allattributes))
						continue;

					Vector rowdata = new Vector();
					rowdata.add(nameSpace);
					rowdata.add(element);
					rowdata.add(attribute);

					if (null == attribute.getAttributeValue())
						rowdata.add("      -   ");
					else
						rowdata.add(attribute.getAttributeValue());

					dtm.addRow(rowdata);
				}// end of second for
			}// end of first for
		}
		if (dtm.getRowCount() > 1) {
			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.SINGLE_SELECTION);
			nameSpaceTable.getSelectionModel().setLeadSelectionIndex(
					selectedRow);
			nameSpaceTable.getSelectionModel().setSelectionMode(
					ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		} else
			nameSpaceTable.clearSelection();
	}

	public boolean isChanged() {
		return changed;
	}

	public void setChanged(boolean b) {
		changed = b;
	}

	class CustomTableModel extends DefaultTableModel {
		public boolean isCellEditable(int row, int column) {
			return false;
		}

		public Vector getDataVector() {
			return dataVector;
		}
	}

}
